/*
 * Decompiled with CFR 0.152.
 */
package me.paulschwarz.springdotenv;

import me.paulschwarz.springdotenv.DotenvPropertyLoader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertySource;

public class DotenvPropertySource
extends PropertySource<DotenvPropertyLoader> {
    private static final Log logger = LogFactory.getLog(DotenvPropertySource.class);
    public static final String DOTENV_PROPERTY_SOURCE_NAME = "env";
    private static final String PREFIX = "env.";

    public DotenvPropertySource(String name) {
        super(name, (Object)new DotenvPropertyLoader());
    }

    public DotenvPropertySource() {
        this(DOTENV_PROPERTY_SOURCE_NAME);
    }

    public Object getProperty(String name) {
        if (!name.startsWith(PREFIX)) {
            return null;
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Getting env property for '" + name + "'"));
        }
        return ((DotenvPropertyLoader)this.getSource()).getValue(name.substring(PREFIX.length()));
    }

    public static void addToEnvironment(ConfigurableEnvironment environment) {
        environment.getPropertySources().addAfter("systemEnvironment", (PropertySource)new DotenvPropertySource(DOTENV_PROPERTY_SOURCE_NAME));
        logger.trace((Object)"DotenvPropertySource add to Environment");
    }
}

