/*
 * Decompiled with CFR 0.152.
 */
package me.paulschwarz.springdotenv;

import java.util.Properties;

public class DotenvConfig {
    private final String prefix;
    private final String directory;
    private final String filename;
    private final boolean ignoreIfMalformed;
    private final boolean ignoreIfMissing;
    private final boolean systemProperties;
    private final boolean suppressPrefixDeprecationWarning;

    public DotenvConfig(Properties propertiesFile) {
        this.prefix = DotenvConfig.getStringProperty(propertiesFile, "prefix");
        this.directory = DotenvConfig.getStringProperty(propertiesFile, "directory");
        this.filename = DotenvConfig.getStringProperty(propertiesFile, "filename");
        this.ignoreIfMalformed = DotenvConfig.getBooleanProperty(propertiesFile, "ignoreIfMalformed", false);
        this.ignoreIfMissing = DotenvConfig.getBooleanProperty(propertiesFile, "ignoreIfMissing", true);
        this.systemProperties = DotenvConfig.getBooleanProperty(propertiesFile, "systemProperties", false);
        this.suppressPrefixDeprecationWarning = DotenvConfig.getBooleanProperty(propertiesFile, "suppressPrefixDeprecationWarning", false);
    }

    private static String getStringProperty(Properties propertiesFile, String key) {
        String value = propertiesFile.getProperty(key);
        if ("\"\"".equals(value)) {
            return "";
        }
        return value;
    }

    private static boolean getBooleanProperty(Properties propertiesFile, String key, boolean defaultValue) {
        return Boolean.parseBoolean(propertiesFile.getProperty(key, String.valueOf(defaultValue)));
    }

    public String getDirectory() {
        return this.directory;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public boolean ignoreIfMalformed() {
        return this.ignoreIfMalformed;
    }

    public boolean ignoreIfMissing() {
        return this.ignoreIfMissing;
    }

    public boolean systemProperties() {
        return this.systemProperties;
    }

    public boolean suppressPrefixDeprecationWarning() {
        return this.suppressPrefixDeprecationWarning;
    }

    public String toString() {
        return "DotenvConfig{directory=" + this.directory + ", filename=" + this.filename + ", ignoreIfMalformed=" + this.ignoreIfMalformed + ", ignoreIfMissing=" + this.ignoreIfMissing + ", systemProperties=" + this.systemProperties + ", prefix=" + this.prefix + '}';
    }
}

