/*
 * Copyright 2017 Phoboslabs.me
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package me.phoboslabs.illuminati.common.dto.enums;

public enum MappingType {

    TEXT("text"),
    KEYWORD("keyword");

    private String mappingType;

    MappingType(String mappingType) {
        this.mappingType = mappingType;
    }

    public String getMappingType () {
        return this.mappingType;
    }

    public static MappingType getMappingType (final String mappingType) throws Exception {
        switch (mappingType.toLowerCase()) {
            case "text" :
                return MappingType.TEXT;
            case "keyword" :
                return MappingType.KEYWORD;
            default :
                throw new Exception(mappingType + " is not support yet.");
        }
    }
}
