/*
 * Decompiled with CFR 0.152.
 */
package me.phoboslabs.illuminati.common.constant;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import me.phoboslabs.illuminati.common.dto.enums.IlluminatiStorageType;
import me.phoboslabs.illuminati.common.properties.IlluminatiJsonCodeProperties;
import me.phoboslabs.illuminati.common.util.PropertiesUtil;

public abstract class IlluminatiConstant {
    public static final String PROFILES_PHASE = System.getProperty("spring.profiles.active");
    public static final DateFormat DATE_FORMAT_EVENT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", Locale.getDefault());
    public static Map<String, Thread> SYSTEM_THREAD_MAP = new HashMap<String, Thread>();
    public static boolean ILLUMINATI_DEBUG = false;
    public static boolean ILLUMINATI_SWITCH_ACTIVATION = false;
    public static IlluminatiStorageType ILLUMINATI_BACKUP_STORAGE_TYPE = null;
    public static boolean ILLUMINATI_BACKUP_ACTIVATION = false;
    public static AtomicBoolean ILLUMINATI_SWITCH_VALUE = new AtomicBoolean(false);
    public static final String BASIC_ILLUMINATI_SWITCH_VALUE_CHECK_INTERVAL = "5000";
    public static final List<String> PROPERTIES_KEYS = Collections.unmodifiableList(Arrays.asList("parentModuleName", "samplingRate", "broker", "clusterList", "virtualHost", "topic", "queueName", "userName", "password", "isAsync", "isCompression", "compressionType", "performance", "debug", "chaosBomber"));
    public static final List<String> CONFIG_FILE_EXTENSTIONS = Collections.unmodifiableList(Arrays.asList("properties", "yml", "yaml"));
    public static final List<String> BASIC_CONFIG_FILES = Collections.unmodifiableList(Arrays.asList("application.properties", "application.yml", "application.yaml"));
    public static final Gson ILLUMINATI_GSON_OBJ = new GsonBuilder().serializeNulls().excludeFieldsWithoutExposeAnnotation().excludeFieldsWithModifiers(new int[]{128}).create();
    public static final ObjectMapper YAML_MAPPER = new ObjectMapper((JsonFactory)new YAMLFactory());
    public static final ObjectMapper BASIC_OBJECT_MAPPER;
    public static final ObjectMapper BASIC_OBJECT_STRING_MAPPER;
    public static final IlluminatiJsonCodeProperties JSON_STATUS_CODE;
    public static final Type TYPE_FOR_TYPE_TOKEN;
    public static final String BASE_CHARSET = "UTF-8";
    public static final String BASIC_PACKAGE_TYPE = "default";

    static {
        YAML_MAPPER.setVisibility(YAML_MAPPER.getSerializationConfig().getDefaultVisibilityChecker().withFieldVisibility(JsonAutoDetect.Visibility.ANY).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withSetterVisibility(JsonAutoDetect.Visibility.NONE).withCreatorVisibility(JsonAutoDetect.Visibility.NONE));
        BASIC_OBJECT_MAPPER = new ObjectMapper();
        BASIC_OBJECT_STRING_MAPPER = new ObjectMapper();
        BASIC_OBJECT_STRING_MAPPER.configure(SerializationFeature.INDENT_OUTPUT, true);
        BASIC_OBJECT_STRING_MAPPER.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        JSON_STATUS_CODE = PropertiesUtil.getIlluminatiProperties(IlluminatiJsonCodeProperties.class, "jsonStatusCode");
        TYPE_FOR_TYPE_TOKEN = new TypeToken<Map<String, Object>>(){}.getType();
    }
}

