/*
 * Decompiled with CFR 0.152.
 */
package me.phoboslabs.illuminati.common.dto;

import com.google.gson.annotations.Expose;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import me.phoboslabs.illuminati.common.util.StringObjectUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestGeneralModel {
    private static final Logger REQUEST_GENERAL_MODEL_LOGGER = LoggerFactory.getLogger(RequestGeneralModel.class);
    @Expose
    private String clientIp;
    @Expose
    private String methodName;
    @Expose
    private Map<String, Object> methodParams;
    @Expose
    private String path;
    @Expose
    private String anotherPath;
    @Expose
    private String queryString;
    private transient Method method;
    private static final List<String> CLIENT_INFO_KEY_LIST = Collections.unmodifiableList(Arrays.asList("path", "queryString", "clientIp", "anotherPath"));
    private static final String CLIENT_IP_KEYWORD = "clientIp";
    private static final String REMOTE_ADDR_KEYWORD = "remoteAddr";

    public RequestGeneralModel() {
    }

    public RequestGeneralModel(Map<String, Object> requestMap) throws Exception {
        if (MapUtils.isEmpty(requestMap)) {
            String errorMessage = "Sorry. check your requestMap variable.";
            REQUEST_GENERAL_MODEL_LOGGER.error("Sorry. check your requestMap variable.");
            throw new Exception("Sorry. check your requestMap variable.");
        }
        for (Map.Entry<String, Object> entry : requestMap.entrySet()) {
            if (entry.getValue() == null) {
                REQUEST_GENERAL_MODEL_LOGGER.debug("Sorry. check your requestMap " + entry.getKey() + " key variable.");
                continue;
            }
            try {
                Field field = this.getClass().getDeclaredField(entry.getKey());
                field.setAccessible(true);
                if ("serverPort".equals(entry.getKey())) {
                    field.setInt(this, (Integer)entry.getValue());
                    continue;
                }
                field.set(this, entry.getValue().toString());
            }
            catch (NoSuchFieldException ex) {
                String errorMessage = "Sorry. check your class field. (" + ex.toString() + ")";
                REQUEST_GENERAL_MODEL_LOGGER.error(errorMessage, (Throwable)ex);
                throw new Exception(errorMessage);
            }
            catch (IllegalAccessException ex) {
                String errorMessage = "Sorry. check your class field permission. (" + ex.toString() + ")";
                REQUEST_GENERAL_MODEL_LOGGER.error(errorMessage, (Throwable)ex);
                throw new Exception(errorMessage);
            }
        }
    }

    public void initClientInfo(Map<String, String> clientInfoMap) {
        if (MapUtils.isEmpty(clientInfoMap)) {
            return;
        }
        for (String key : CLIENT_INFO_KEY_LIST) {
            if (!clientInfoMap.containsKey(key)) continue;
            try {
                String value = clientInfoMap.get(key);
                if (CLIENT_IP_KEYWORD.equals(key) && !StringObjectUtils.isValid(value)) {
                    value = clientInfoMap.get(REMOTE_ADDR_KEYWORD);
                }
                if (!StringObjectUtils.isValid(value)) continue;
                Field field = this.getClass().getDeclaredField(key);
                field.setAccessible(true);
                field.set(this, value);
            }
            catch (Exception exception) {}
        }
    }

    public String getServerIp() {
        return this.getServerIp();
    }

    private boolean isParamValidated(String[] paramNames, Object[] paramValues) {
        return paramNames != null && paramNames.length > 0 && paramValues != null && paramValues.length > 0;
    }

    public void setMethod(Method method, String[] paramNames, Object[] paramValues) {
        this.method = method;
        this.methodName = this.method.toString();
        try {
            if (this.isParamValidated(paramNames, paramValues)) {
                HashMap<String, Object> paramMap = new HashMap<String, Object>();
                IntStream.range(0, paramNames.length).forEach(i -> paramMap.put(paramNames[i], paramValues[i]));
                this.methodParams = paramMap;
            }
        }
        catch (Exception ex) {
            REQUEST_GENERAL_MODEL_LOGGER.error("Sorry. check your class method params. ({})", (Object)ex.toString(), (Object)ex);
        }
    }

    public void setCustomForEnv() {
        this.setReplaceMethodName("public java.lang.Object ");
        this.setPathForGrails();
    }

    private void setReplaceMethodName(String replaceText) {
        if (StringObjectUtils.isValid(this.methodName)) {
            this.methodName = this.methodName.replace(replaceText, "");
        }
    }

    private void setPathForGrails() {
        if (this.path.indexOf("/grails") == 0 && this.path.indexOf(".dispatch") > -1 && this.path.indexOf(".dispatch") + 9 == this.path.length()) {
            this.path = this.path.replace("/grails", "");
            this.path = this.path.substring(0, this.path.indexOf(".dispatch"));
        }
    }

    public String getMethodName() {
        return this.methodName;
    }
}

