/*
 * Decompiled with CFR 0.152.
 */
package me.phoboslabs.illuminati.common.dto;

import com.google.gson.annotations.Expose;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import me.phoboslabs.illuminati.common.util.StringObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestHeaderModel {
    private static final Logger REQUEST_HEADER_MODEL_LOGGER = LoggerFactory.getLogger(RequestHeaderModel.class);
    @Expose
    private String illuminatiProcId;
    @Expose
    private String illuminatiSProcId;
    @Expose
    private String illuminatiGProcId;
    @Expose
    private String accept;
    @Expose
    private String acceptCharset;
    @Expose
    private String acceptEncoding;
    @Expose
    private String acceptLanguage;
    @Expose
    private String authorization;
    @Expose
    private String cookie;
    @Expose
    private String expect;
    @Expose
    private String from;
    @Expose
    private String host;
    @Expose
    private String ifMatch;
    @Expose
    private String ifModifiedSince;
    @Expose
    private String ifNoneMatch;
    @Expose
    private String ifRange;
    @Expose
    private String ifUnmodifiedSince;
    @Expose
    private String maxForwards;
    @Expose
    private String proxyAuthorization;
    @Expose
    private String range;
    @Expose
    private String referer;
    @Expose
    private String te;
    @Expose
    private String userAgent;
    @Expose
    private String connection;
    @Expose
    private String cacheControl;
    @Expose
    private String upgradeInsecureRequests;
    @Expose
    private String contentType;
    @Expose
    private String contentLength;
    @Expose
    private String postContentBody;
    @Expose
    private String origin;
    @Expose
    private String xRequestedWith;
    @Expose
    private String xRealIp;
    @Expose
    private String xScheme;
    @Expose
    private String xForwardedProto;
    @Expose
    private String xForwardedHost;
    @Expose
    private String xForwardedServer;
    @Expose
    private String xForwardedSsl;
    @Expose
    private String dnt;
    @Expose
    private String pragma;
    @Expose
    private String sessionInfo;
    @Expose
    private Map<String, String> anotherHeader;
    @Expose
    private Map<String, String> parsedCookie;

    public RequestHeaderModel setRequestInfo(HttpServletRequest request) {
        if (request == null) {
            return this;
        }
        this.init(request);
        if ("post".equalsIgnoreCase(request.getMethod())) {
            try {
                this.postContentBody = StringObjectUtils.getPostBodyString(request);
            }
            catch (IOException ex) {
                REQUEST_HEADER_MODEL_LOGGER.error("Sorry. check your formData. ({})", (Object)ex.toString(), (Object)ex);
            }
        }
        return this;
    }

    private void init(HttpServletRequest request) {
        Enumeration headerNames = request.getHeaderNames();
        if (headerNames == null) {
            return;
        }
        while (headerNames.hasMoreElements()) {
            try {
                String originKey = (String)headerNames.nextElement();
                String value = request.getHeader(originKey);
                String key = originKey.toLowerCase();
                if (key.indexOf("-") > -1) {
                    StringBuilder methodKey = new StringBuilder();
                    String[] splitedKey = key.split("-");
                    for (int i = 0; i < splitedKey.length; ++i) {
                        String partOfString = splitedKey[i];
                        if (i > 0) {
                            partOfString = partOfString.substring(0, 1).toUpperCase().concat(partOfString.substring(1));
                        }
                        methodKey.append(partOfString);
                    }
                    key = methodKey.toString();
                }
                Field field = this.getClass().getDeclaredField(key);
                field.setAccessible(true);
                field.set(this, value);
            }
            catch (Exception ex) {
                try {
                    if (this.anotherHeader == null) {
                        this.anotherHeader = new HashMap<String, String>();
                    }
                    String key = (String)headerNames.nextElement();
                    String value = request.getHeader(key);
                    this.anotherHeader.put(key, value);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                REQUEST_HEADER_MODEL_LOGGER.debug("Sorry. check your header (There Exception is no problem in operation). (" + ex.toString() + ")");
            }
        }
    }

    @Deprecated
    private void getIlluminatiProcId(HttpServletRequest request) {
        Enumeration enumeration = request.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            String value = request.getAttribute(key).toString();
            if (!"illuminatiProcId".equals(key)) continue;
            this.illuminatiProcId = value;
            break;
        }
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public String getPostContentBody() {
        return this.postContentBody;
    }

    public void parsingCookie() {
        if (!StringObjectUtils.isValid(this.cookie)) {
            return;
        }
        for (String cookieData : this.cookie.split(";")) {
            String[] tmpCookieData = cookieData.split("=");
            if (tmpCookieData.length != 2) continue;
            this.setParsedCookieElement(tmpCookieData[0].trim(), tmpCookieData[1].trim());
        }
    }

    public void setParsedCookieElement(String key, String value) {
        if (this.parsedCookie == null) {
            this.parsedCookie = new HashMap<String, String>();
        }
        this.parsedCookie.put(key, value);
    }

    public RequestHeaderModel setSessionTransactionId(String illuminatiSProcId) {
        if (StringObjectUtils.isValid(illuminatiSProcId)) {
            this.illuminatiSProcId = illuminatiSProcId;
            return this;
        }
        return this;
    }

    public RequestHeaderModel setGlobalTransactionId(String illuminatiGProcId) {
        if (StringObjectUtils.isValid(illuminatiGProcId)) {
            this.illuminatiGProcId = illuminatiGProcId;
        }
        return this;
    }

    public RequestHeaderModel setTransactionId(String illuminatiProcId) {
        if (StringObjectUtils.isValid(illuminatiProcId)) {
            this.illuminatiProcId = illuminatiProcId;
        }
        return this;
    }

    public String getIlluminatiSProcId() {
        return this.illuminatiSProcId;
    }

    public String getIlluminatiGProcId() {
        return this.illuminatiGProcId;
    }
}

