/*
 * Decompiled with CFR 0.152.
 */
package me.phoboslabs.illuminati.common.dto;

import com.google.gson.annotations.Expose;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import me.phoboslabs.illuminati.common.dto.GroupMapping;
import me.phoboslabs.illuminati.common.dto.enums.MappingType;
import me.phoboslabs.illuminati.common.util.StringObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerInfo {
    private static final Logger SERVER_INFO_LOGGER = LoggerFactory.getLogger(ServerInfo.class);
    @Expose
    private String domain;
    @Expose
    private int serverPort = 0;
    @Expose
    @GroupMapping(mappingType=MappingType.KEYWORD)
    private String hostName;
    @Expose
    @GroupMapping(mappingType=MappingType.KEYWORD)
    private String serverIp;
    private static final String DOMAIN_KEYWORD = "domain";
    private static final String SERVER_PORT_KEYWORD = "serverPort";

    public ServerInfo() {
    }

    public ServerInfo(boolean init) {
        if (init) {
            this.init();
        }
    }

    private void init() {
        try {
            InetAddress ip = InetAddress.getLocalHost();
            this.serverIp = ip.getHostAddress();
            this.hostName = ip.getHostName();
        }
        catch (UnknownHostException ex) {
            SERVER_INFO_LOGGER.error("Sorry. check your spring network. ({})", (Object)ex.toString(), (Object)ex);
        }
    }

    public String getServerIp() {
        return this.serverIp;
    }

    public boolean isAlreadySetServerDomainAndPort() {
        return StringObjectUtils.isValid(this.domain) && this.serverPort > 0;
    }

    private boolean isKeywordValidatedOnStaticInfo(Map<String, Object> staticInfo, String keyword) {
        return staticInfo.containsKey(keyword) && staticInfo.get(keyword) != null;
    }

    public void setStaticInfoFromRequest(Map<String, Object> staticInfo) {
        if (this.isKeywordValidatedOnStaticInfo(staticInfo, DOMAIN_KEYWORD)) {
            this.domain = (String)staticInfo.get(DOMAIN_KEYWORD);
        }
        if (this.isKeywordValidatedOnStaticInfo(staticInfo, SERVER_PORT_KEYWORD)) {
            this.serverPort = (Integer)staticInfo.get(SERVER_PORT_KEYWORD);
        }
    }
}

