/*
 * Decompiled with CFR 0.152.
 */
package me.phoboslabs.illuminati.common.http;

import java.io.IOException;
import java.util.HashSet;
import java.util.Properties;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeader;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;

public class IlluminatiHttpClient
extends CloseableHttpClient {
    private CloseableHttpClient httpClient;
    private static final int MAX_CONNECTION = 1000;
    private static final int MAX_CONNECTION_PER_ROUTE = 1000;
    private static final int CONNECTION_TIMEOUT = 1000;
    private static final int SOCKET_TIMEOUT = 3000;
    private final Properties properties = new Properties();

    public IlluminatiHttpClient() {
        this.initPoolingHttpClientManager();
    }

    protected CloseableHttpResponse doExecute(HttpHost httpHost, HttpRequest httpRequest, HttpContext httpContext) throws IOException, ClientProtocolException {
        return this.httpClient.execute(httpHost, httpRequest, httpContext);
    }

    public void setProperties(String key, String value) {
        this.properties.put(key, value);
    }

    private void initPoolingHttpClientManager() {
        Registry socketFactoryRegistry = RegistryBuilder.create().register("https", (Object)SSLConnectionSocketFactory.getSocketFactory()).register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).build();
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        connectionManager.setMaxTotal(1000);
        connectionManager.setDefaultMaxPerRoute(1000);
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom().setConnectTimeout(1000).setConnectionRequestTimeout(1000).setSocketTimeout(3000);
        RequestConfig requestConfig = requestConfigBuilder.build();
        HashSet<BasicHeader> defaultHeaders = new HashSet<BasicHeader>();
        defaultHeaders.add(new BasicHeader("Pragma", "no-cache"));
        defaultHeaders.add(new BasicHeader("Cache-Control", "no-cache"));
        HttpClientBuilder httpClientBuilder = HttpClients.custom().setDefaultHeaders(defaultHeaders).disableAuthCaching().disableContentCompression();
        this.httpClient = httpClientBuilder.setConnectionManager((HttpClientConnectionManager)connectionManager).setDefaultRequestConfig(requestConfig).build();
    }

    public void close() throws IOException {
        if (this.httpClient != null) {
            this.httpClient.close();
        }
    }

    @Deprecated
    public HttpParams getParams() {
        return null;
    }

    @Deprecated
    public ClientConnectionManager getConnectionManager() {
        return null;
    }
}

