/*
 * Decompiled with CFR 0.152.
 */
package me.phoboslabs.illuminati.common.properties;

import java.lang.reflect.Method;
import me.phoboslabs.illuminati.common.properties.IlluminatiProperties;
import me.phoboslabs.illuminati.common.util.PropertiesUtil;
import me.phoboslabs.illuminati.common.util.StringObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IlluminatiPropertiesHelper {
    private static final Logger FILE_UTIL_LOGGER = LoggerFactory.getLogger(IlluminatiPropertiesHelper.class);
    private static final String ILLUMINATI_SWITCH_CONFIGURATION_CLASS_NAME = "me.phoboslabs.illuminati.client.switcher.IlluminatiSwitch";

    public static boolean isIlluminatiSwitcherActive() {
        boolean isIlluminatiSwitcherActive = true;
        try {
            Class.forName(ILLUMINATI_SWITCH_CONFIGURATION_CLASS_NAME);
        }
        catch (ClassNotFoundException e) {
            isIlluminatiSwitcherActive = false;
        }
        return isIlluminatiSwitcherActive;
    }

    public static String getPropertiesValueByKey(Class<? extends IlluminatiProperties> clazz, String configPropertiesFileName, String key, String defaultValue) {
        IlluminatiProperties illuminatiProperties = PropertiesUtil.getIlluminatiProperties(clazz, configPropertiesFileName);
        String propertiesValue = null;
        if (StringObjectUtils.isValid(key) && illuminatiProperties != null) {
            try {
                String methodName = "get" + key.substring(0, 1).toUpperCase() + key.substring(1);
                Method getNameMethod = clazz.getMethod(methodName, new Class[0]);
                propertiesValue = (String)getNameMethod.invoke((Object)illuminatiProperties, new Object[0]);
            }
            catch (Exception ex) {
                FILE_UTIL_LOGGER.debug("Sorry, unable to find method. (" + ex.toString() + ")");
            }
        }
        return StringObjectUtils.isValid(propertiesValue) ? propertiesValue : defaultValue;
    }
}

