/*
 * Decompiled with CFR 0.152.
 */
package me.phoboslabs.illuminati.common.util;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class ConvertUtil {
    private static final String CHAOS_BOMBER_KEYWORD = "ChaosBomber";

    public static Map<String, String> getClientInfoFromHttpRequest(HttpServletRequest request) throws Exception {
        if (request == null) {
            throw new Exception("The Request must not be null.");
        }
        HashMap<String, String> clientInfoMap = new HashMap<String, String>();
        clientInfoMap.put("clientIp", request.getHeader("X-FORWARDED-FOR"));
        clientInfoMap.put("path", request.getRequestURI());
        clientInfoMap.put("remoteAddr", request.getRemoteAddr());
        clientInfoMap.put("queryString", request.getQueryString());
        Object anotherPath = request.getAttribute("javax.servlet.forward.request_uri");
        if (anotherPath != null) {
            clientInfoMap.put("anotherPath", anotherPath.toString());
        }
        return clientInfoMap;
    }

    public static Map<String, Object> getStaticInfoFromHttpRequest(HttpServletRequest request) {
        HashMap<String, Object> staticInfoMap = new HashMap<String, Object>();
        staticInfoMap.put("domain", request.getServerName());
        staticInfoMap.put("serverPort", request.getLocalPort());
        if (request.getAttribute(CHAOS_BOMBER_KEYWORD) != null && "true".equals(request.getAttribute(CHAOS_BOMBER_KEYWORD).toString())) {
            request.setAttribute(CHAOS_BOMBER_KEYWORD, null);
            staticInfoMap.put(CHAOS_BOMBER_KEYWORD, true);
        }
        return staticInfoMap;
    }

    public static boolean getChaosBomberFromHttpRequest(HttpServletRequest request) {
        if (request.getAttribute(CHAOS_BOMBER_KEYWORD) != null && "true".equals(request.getAttribute(CHAOS_BOMBER_KEYWORD).toString())) {
            request.setAttribute(CHAOS_BOMBER_KEYWORD, null);
            return true;
        }
        return false;
    }

    public static <K, V> Map<K, V> castToMapOf(Class<K> clazzK, Class<V> clazzV, Map<?, ?> map) {
        map.forEach((key, value) -> {
            ConvertUtil.checkCast(clazzK, key);
            ConvertUtil.checkCast(clazzV, value);
        });
        Map<?, ?> result = map;
        return result;
    }

    private static <T> void checkCast(Class<T> clazz, Object obj) {
        if (obj != null && !clazz.isInstance(obj)) {
            StringBuilder exMessage = new StringBuilder().append("Expected : ").append(clazz.getName()).append("Was : ").append(obj.getClass().getName()).append("Value : ").append(obj);
            throw new ClassCastException(exMessage.toString());
        }
    }

    public static Map<String, Object> convertObjectToMap(Object obj) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Field[] fields = obj.getClass().getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            fields[i].setAccessible(true);
            try {
                map.put(fields[i].getName(), fields[i].get(obj));
                continue;
            }
            catch (Exception e) {
                throw new Exception(e.toString());
            }
        }
        return map;
    }
}

