/*
 * Decompiled with CFR 0.152.
 */
package me.phoboslabs.illuminati.common.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import me.phoboslabs.illuminati.common.constant.IlluminatiConstant;
import me.phoboslabs.illuminati.common.properties.IlluminatiProperties;
import me.phoboslabs.illuminati.common.properties.IlluminatiPropertiesHelper;
import me.phoboslabs.illuminati.common.util.StringObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesUtil {
    private static final Logger PROPERTIES_UTIL_LOGGER = LoggerFactory.getLogger(PropertiesUtil.class);

    private static List<String> getPropertiesFileNames(String configPropertiesFileName) {
        ArrayList<String> fileNames = new ArrayList<String>();
        IlluminatiConstant.CONFIG_FILE_EXTENSTIONS.forEach(extension -> fileNames.add(configPropertiesFileName.concat(PropertiesUtil.getDotBeforeExtension()).concat((String)extension)));
        return fileNames;
    }

    private static List<String> getPropertiesFileNamesWithoutProfiles(String configPropertiesFileName) {
        ArrayList<String> fileNames = new ArrayList<String>();
        IlluminatiConstant.CONFIG_FILE_EXTENSTIONS.forEach(extension -> fileNames.add(configPropertiesFileName.concat(".").concat((String)extension)));
        return fileNames;
    }

    private static String getDotBeforeExtension() {
        String dotBeforeExtension = ".";
        if (StringObjectUtils.isValid(IlluminatiConstant.PROFILES_PHASE)) {
            int indexOfFirstComma = IlluminatiConstant.PROFILES_PHASE.indexOf(",");
            dotBeforeExtension = "-".concat(indexOfFirstComma > 0 ? IlluminatiConstant.PROFILES_PHASE.substring(0, IlluminatiConstant.PROFILES_PHASE.indexOf(",")) : IlluminatiConstant.PROFILES_PHASE).concat(".");
        }
        return dotBeforeExtension;
    }

    public static <T extends IlluminatiProperties> T getIlluminatiProperties(Class<T> clazz, String configPropertiesFileName) {
        String fullFileName;
        T illuminatiProperties = null;
        Iterator<String> iterator = PropertiesUtil.getPropertiesFileNames(configPropertiesFileName).iterator();
        while (iterator.hasNext() && (illuminatiProperties = (T)PropertiesUtil.getIlluminatiPropertiesByFile(clazz, fullFileName = iterator.next())) == null) {
        }
        if (illuminatiProperties == null) {
            iterator = PropertiesUtil.getPropertiesFileNamesWithoutProfiles(configPropertiesFileName).iterator();
            while (iterator.hasNext() && (illuminatiProperties = (T)PropertiesUtil.getIlluminatiPropertiesByFile(clazz, fullFileName = iterator.next())) == null) {
            }
        }
        if (illuminatiProperties == null) {
            illuminatiProperties = PropertiesUtil.getIlluminatiPropertiesFromBasicFiles(clazz);
        }
        if (illuminatiProperties == null) {
            PROPERTIES_UTIL_LOGGER.debug("Sorry, unable to find " + configPropertiesFileName);
        }
        return illuminatiProperties;
    }

    private static <T extends IlluminatiProperties> T getIlluminatiPropertiesFromBasicFiles(Class<T> clazz) {
        T illuminatiProperties = null;
        for (String fileName : IlluminatiConstant.BASIC_CONFIG_FILES) {
            illuminatiProperties = PropertiesUtil.getIlluminatiPropertiesByFile(clazz, fileName);
            if (illuminatiProperties == null) continue;
            return illuminatiProperties;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T extends IlluminatiProperties> T getIlluminatiPropertiesByFile(Class<T> clazz, String configPropertiesFileName) {
        InputStream input = IlluminatiPropertiesHelper.class.getClassLoader().getResourceAsStream(configPropertiesFileName);
        if (input == null) {
            return null;
        }
        IlluminatiProperties illuminatiProperties = null;
        try {
            if (configPropertiesFileName.indexOf(".yml") > -1 || configPropertiesFileName.indexOf(".yaml") > -1) {
                illuminatiProperties = (IlluminatiProperties)IlluminatiConstant.YAML_MAPPER.readValue(input, clazz);
            } else {
                Properties prop = new Properties();
                prop.load(input);
                if (prop == null) {
                    PROPERTIES_UTIL_LOGGER.debug("Sorry, unable to convert properties file to Properties. (" + configPropertiesFileName + ")");
                    T t = null;
                    return t;
                }
                try {
                    illuminatiProperties = (IlluminatiProperties)clazz.newInstance();
                    illuminatiProperties.setProperties(prop);
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
        }
        catch (IOException ex) {
            PROPERTIES_UTIL_LOGGER.debug("Sorry, something is wrong in read process. (" + ex.toString() + ")");
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException ex) {
                    PROPERTIES_UTIL_LOGGER.debug("Sorry, something is wrong in close InputStream process. (" + ex.toString() + ")");
                }
            }
        }
        return (T)illuminatiProperties;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Properties getPropertiesFromFile(String filePath) throws IOException {
        try (InputStream input = PropertiesUtil.class.getClassLoader().getResourceAsStream(filePath);){
            Properties prop = new Properties();
            prop.load(input);
            Properties properties = prop;
            return properties;
        }
        catch (IOException ex) {
            throw new IOException(ex.toString());
        }
    }
}

