/*
 * Decompiled with CFR 0.152.
 */
package me.phoboslabs.illuminati.common.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.UUID;
import java.util.stream.IntStream;
import java.util.zip.GZIPInputStream;
import javax.servlet.http.HttpServletRequest;
import me.phoboslabs.illuminati.common.constant.IlluminatiConstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringObjectUtils {
    private static final Logger STRINGUTIL_LOGGER = LoggerFactory.getLogger(StringObjectUtils.class);

    public static boolean isValid(String value) {
        return value != null && value.trim().length() > 0;
    }

    public static boolean isNotValid(String value) {
        return !StringObjectUtils.isValid(value);
    }

    /*
     * Exception decompiling
     */
    public static byte[] gzipMessage(String message) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String decompressGzip(byte[] compressed) throws Exception {
        if (compressed == null || compressed.length == 0) {
            throw new Exception("compressed byte array must not be null.");
        }
        StringBuilder outStr = new StringBuilder();
        if (StringObjectUtils.isCompressed(compressed)) {
            String line;
            GZIPInputStream gis = new GZIPInputStream(new ByteArrayInputStream(compressed));
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)gis, "UTF-8"));
            while ((line = bufferedReader.readLine()) != null) {
                outStr.append(line);
            }
            gis.close();
            bufferedReader.close();
        } else {
            outStr.append(compressed);
        }
        return outStr.toString();
    }

    public static boolean isCompressed(byte[] compressed) {
        return compressed[0] == 31 && compressed[1] == -117;
    }

    /*
     * Exception decompiling
     */
    public static String getPostBodyString(HttpServletRequest request) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String getExceptionMessageChain(Throwable throwable) {
        StringBuilder result = new StringBuilder().append("[IlluminatiException] : An exception occurred while running").append("\r\n\r\n");
        while (throwable != null) {
            result.append(throwable.toString());
            throwable = throwable.getCause();
        }
        return result.toString();
    }

    public static String removeDotAndUpperCase(String value) throws Exception {
        if (!StringObjectUtils.isValid(value)) {
            throw new Exception("value must not be null.");
        }
        StringBuilder returnValue = new StringBuilder(value);
        IntStream.range(0, value.length()).filter(i -> value.charAt(i) == '.').forEach(i -> returnValue.setCharAt(i + 1, Character.toUpperCase(value.charAt(i + 1))));
        return returnValue.toString().replace(".", "");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String objectToString(Object object) throws Exception {
        if (object == null) {
            throw new Exception("object must not be null.");
        }
        try (StringWriter stringWriter = new StringWriter();){
            IlluminatiConstant.BASIC_OBJECT_STRING_MAPPER.writeValue((Writer)stringWriter, object);
            String resultString = stringWriter.toString();
            String string = resultString.replaceAll(System.getProperty("line.separator"), "");
            return string;
        }
        catch (IOException ex) {
            String errorMessage = "Sorry. had a error on during Object to String. (" + ex.toString() + ")";
            STRINGUTIL_LOGGER.info(errorMessage);
            throw new Exception(errorMessage);
        }
    }

    private static boolean isDeleteKeywordArrayValidated(String[] deleteKeyword, int deleteKeywordLocationIndexLength) {
        return deleteKeyword != null && deleteKeyword.length > 0 && deleteKeyword.length == deleteKeywordLocationIndexLength;
    }

    public static String deleteKeywordInString(String origin, String[] deleteKeyword, int[] deleteKeywordLocationIndex) {
        if (StringObjectUtils.isValid(origin) && StringObjectUtils.isDeleteKeywordArrayValidated(deleteKeyword, deleteKeywordLocationIndex.length)) {
            for (int i = 0; i < deleteKeyword.length; ++i) {
                if (origin.indexOf(deleteKeyword[i]) != deleteKeywordLocationIndex[i]) continue;
                origin = origin.replace(deleteKeyword[i], "");
            }
        }
        return origin;
    }

    public static byte[] encode(char[] charArray) throws Exception {
        try {
            CharsetEncoder encoder = Charset.forName("UTF-8").newEncoder();
            ByteBuffer bb = encoder.encode(CharBuffer.wrap(charArray));
            byte[] ba = new byte[bb.limit()];
            bb.get(ba);
            return ba;
        }
        catch (CharacterCodingException ex) {
            String errorMessage = "Sorry. had a error on during string encode. (" + ex.toString() + ")";
            STRINGUTIL_LOGGER.error(errorMessage, (Throwable)ex);
            throw new Exception(errorMessage);
        }
    }

    public static String generateId(long idTimestamp, String postfix) {
        StringBuilder id = new StringBuilder();
        id.append(UUID.randomUUID().toString().replace("-", ""));
        id.append(idTimestamp);
        if (StringObjectUtils.isValid(postfix)) {
            id.append("-");
            id.append(postfix);
        }
        return id.toString();
    }

    public static String convertFirstLetterToLowerlize(String str) {
        StringBuilder convertString = new StringBuilder().append(str.substring(0, 1).toLowerCase()).append(str.substring(1));
        return convertString.toString();
    }
}

