/*
 * Decompiled with CFR 0.152.
 */
package me.phoboslabs.illuminati.common.util;

import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import me.phoboslabs.illuminati.common.constant.IlluminatiConstant;
import me.phoboslabs.illuminati.common.dto.enums.IlluminatiTransactionIdType;
import me.phoboslabs.illuminati.common.util.StringObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemUtil {
    public static final Logger SYSTEM_UTIL_LOGGER = LoggerFactory.getLogger(SystemUtil.class);
    private static final DecimalFormat DECIMAL_POINT = new DecimalFormat("#.###");
    private static final Runtime RUNTIME = Runtime.getRuntime();
    private static final OperatingSystemMXBean M_BEAN = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
    private static final List<String> INCLUDE_JAVA_SYSTEM_PROPERTIES = Collections.unmodifiableList(Arrays.asList("user.timezone", "user.country.format", "user.country", "java.home", "user.language", "file.encoding", "catalina.home", "PID"));
    private static final int MEGA_BYTE = 0x100000;
    private static final String JAVA_VM_PREFIX = "java.vm.";

    public static Map<String, Object> getJvmInfo() {
        HashMap<String, Object> jvmInfo = new HashMap<String, Object>();
        Properties javaSystemProperties = System.getProperties();
        for (String name : javaSystemProperties.stringPropertyNames()) {
            if (name.indexOf(JAVA_VM_PREFIX) <= -1 && !INCLUDE_JAVA_SYSTEM_PROPERTIES.contains(name)) continue;
            try {
                jvmInfo.put(StringObjectUtils.removeDotAndUpperCase(name), javaSystemProperties.getProperty(name));
            }
            catch (Exception ex) {
                SYSTEM_UTIL_LOGGER.error(ex.toString(), (Throwable)ex);
            }
        }
        return jvmInfo;
    }

    public static Map<String, Object> getJvmMemoryInfo() {
        HashMap<String, Object> jvmInfo = new HashMap<String, Object>();
        jvmInfo.put("jvmUsedMemory", (RUNTIME.totalMemory() - RUNTIME.freeMemory()) / 0x100000L);
        jvmInfo.put("jvmFreeMemory", RUNTIME.freeMemory() / 0x100000L);
        jvmInfo.put("jvmTotalMemory", RUNTIME.totalMemory() / 0x100000L);
        jvmInfo.put("jvmMaxMemory", RUNTIME.maxMemory() / 0x100000L);
        jvmInfo.put("jvmCpuUsage", DECIMAL_POINT.format(M_BEAN.getProcessCpuLoad()));
        jvmInfo.put("jvmActiveThreadCount", Thread.activeCount());
        return jvmInfo;
    }

    public static String generateTransactionIdByRequest(HttpServletRequest request, IlluminatiTransactionIdType illuminatiTransactionIdType) throws Exception {
        String keyName = illuminatiTransactionIdType.getValue();
        String trxId = SystemUtil.getValueFromHeaderByKey(request, keyName);
        if (!StringObjectUtils.isValid(trxId) && request != null) {
            switch (illuminatiTransactionIdType) {
                case ILLUMINATI_PROC_ID: 
                case ILLUMINATI_G_PROC_ID: {
                    trxId = StringObjectUtils.generateId(new Date().getTime(), keyName);
                    request.setAttribute(keyName, (Object)trxId);
                    break;
                }
            }
        }
        if (!StringObjectUtils.isValid(trxId)) {
            throw new Exception("trxId must not be null.");
        }
        return trxId;
    }

    public static String getValueFromHeaderByKey(HttpServletRequest request, String keyName) throws Exception {
        Object value = null;
        if (request != null && keyName != null && (value = request.getHeader(keyName)) == null) {
            value = request.getAttribute(keyName);
        }
        if (value != null) {
            throw new Exception("value must not be null. (you can ignore this message)");
        }
        return value.toString();
    }

    private static boolean isThreadNameValidated(String threadName) {
        return !StringUtils.isEmpty((CharSequence)threadName) && !IlluminatiConstant.SYSTEM_THREAD_MAP.containsKey(threadName);
    }

    public static void createSystemThread(Runnable runnable, String threadName) {
        if (runnable != null && SystemUtil.isThreadNameValidated(threadName)) {
            Thread newThread = new Thread(runnable);
            if (!"debug".equalsIgnoreCase(threadName)) {
                newThread.setName(threadName);
            }
            newThread.setDaemon(true);
            newThread.start();
            IlluminatiConstant.SYSTEM_THREAD_MAP.put(threadName, newThread);
        } else {
            if (runnable == null) {
                SYSTEM_UTIL_LOGGER.warn("Runnable is required.");
            }
            if (StringUtils.isEmpty((CharSequence)threadName)) {
                SYSTEM_UTIL_LOGGER.warn("threadName is required.");
            }
            if (IlluminatiConstant.SYSTEM_THREAD_MAP.containsKey(threadName)) {
                SYSTEM_UTIL_LOGGER.warn(threadName + " thread is already exists.");
            }
        }
    }

    public static void createThreadStatusDebugThread() {
        if (IlluminatiConstant.ILLUMINATI_DEBUG && SYSTEM_UTIL_LOGGER.isInfoEnabled()) {
            Runnable threadCheckRunnable = () -> {
                while (true) {
                    for (Map.Entry<String, Thread> elem : IlluminatiConstant.SYSTEM_THREAD_MAP.entrySet()) {
                        SYSTEM_UTIL_LOGGER.info("");
                        SYSTEM_UTIL_LOGGER.info("#########################################################################################################");
                        SYSTEM_UTIL_LOGGER.info("# debug info");
                        SYSTEM_UTIL_LOGGER.info("# -------------------------------------------------------------------------------------------------------");
                        SYSTEM_UTIL_LOGGER.info("# ILLUMINATI_SWITCH_ACTIVATION : " + IlluminatiConstant.ILLUMINATI_SWITCH_ACTIVATION);
                        SYSTEM_UTIL_LOGGER.info("# ILLUMINATI_SWITCH_VALUE : " + IlluminatiConstant.ILLUMINATI_SWITCH_VALUE.get());
                        SYSTEM_UTIL_LOGGER.info("# ILLUMINATI_SWITCH_VALUE_CHECK_INTERVAL : 5000ms");
                        SYSTEM_UTIL_LOGGER.info("# threadName : " + elem.getKey() + ", ThreadIsAlive : " + elem.getValue().isAlive() + ", ThreadNowStatus : " + elem.getValue().getState().name());
                        SYSTEM_UTIL_LOGGER.info("#########################################################################################################");
                        SYSTEM_UTIL_LOGGER.info("");
                    }
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            };
            SystemUtil.createSystemThread(threadCheckRunnable, "ILLUMINATI_DEBUG_THREAD");
        }
    }
}

