/*
 * Decompiled with CFR 0.152.
 */
package lombok.eclipse.handlers;

import lombok.MybatisParam;
import lombok.core.AST;
import lombok.core.AnnotationValues;
import lombok.core.LombokNode;
import lombok.core.TypeLibrary;
import lombok.core.TypeResolver;
import lombok.eclipse.Eclipse;
import lombok.eclipse.EclipseAnnotationHandler;
import lombok.eclipse.EclipseNode;
import org.apache.ibatis.annotations.Param;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.QualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.SingleMemberAnnotation;
import org.eclipse.jdt.internal.compiler.ast.StringLiteral;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;

public class HandleMybatisParam
extends EclipseAnnotationHandler<MybatisParam> {
    private static final String PARAM = Param.class.getName();

    public void handle(AnnotationValues<MybatisParam> annotation, Annotation ast, EclipseNode annotationNode) {
        HandleMybatisParam.handle(annotationNode);
    }

    private static void handle(EclipseNode annotationNode) {
        EclipseNode node = (EclipseNode)annotationNode.up();
        if (node != null) {
            for (EclipseNode child : node.down()) {
                if (!AST.Kind.METHOD.equals((Object)child.getKind())) continue;
                HandleMybatisParam.handleMethod(child);
            }
        }
    }

    private static void handleMethod(EclipseNode method) {
        Argument[] arguments = ((AbstractMethodDeclaration)method.get()).arguments;
        if (arguments.length <= 1) {
            return;
        }
        char[][] name = Eclipse.fromQualifiedName((String)PARAM);
        QualifiedTypeReference type = new QualifiedTypeReference(name, new long[name.length]);
        for (Argument argument : arguments) {
            if (HandleMybatisParam.hasParam(method, argument.annotations)) continue;
            SingleMemberAnnotation annotation = new SingleMemberAnnotation((TypeReference)type, 0);
            annotation.memberValue = new StringLiteral(argument.name, 0, 0, 0);
            argument.annotations = HandleMybatisParam.copyAnnotations(argument.annotations, annotation);
        }
    }

    private static Annotation[] copyAnnotations(Annotation[] annotations, SingleMemberAnnotation annotation) {
        if (annotations == null || annotations.length == 0) {
            return new Annotation[]{annotation};
        }
        int length = annotations.length;
        Annotation[] newAnnotations = new Annotation[length + 1];
        System.arraycopy(annotations, 0, newAnnotations, 0, length);
        newAnnotations[length] = annotation;
        return newAnnotations;
    }

    private static boolean hasParam(EclipseNode method, Annotation[] annotations) {
        if (annotations == null || annotations.length == 0) {
            return false;
        }
        TypeLibrary typeLibrary = TypeLibrary.createLibraryForSingleType((String)PARAM);
        TypeResolver typeResolver = new TypeResolver(method.getImportList());
        for (Annotation annotation : annotations) {
            String type = Eclipse.toQualifiedName((char[][])annotation.type.getTypeName());
            String fqn = typeResolver.typeRefToFullyQualifiedName((LombokNode)method, typeLibrary, type);
            if (!PARAM.equals(fqn)) continue;
            return true;
        }
        return false;
    }
}

