/*
 * Decompiled with CFR 0.152.
 */
package lombok.javac.handlers;

import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.List;
import lombok.MybatisParam;
import lombok.core.AST;
import lombok.core.AnnotationValues;
import lombok.core.LombokNode;
import lombok.core.TypeLibrary;
import lombok.core.TypeResolver;
import lombok.javac.JavacAnnotationHandler;
import lombok.javac.JavacNode;
import lombok.javac.JavacTreeMaker;
import lombok.javac.handlers.JavacHandlerUtil;
import org.apache.ibatis.annotations.Param;

public class HandleMybatisParam
extends JavacAnnotationHandler<MybatisParam> {
    private static final String PARAM = Param.class.getName();

    public void handle(AnnotationValues<MybatisParam> annotation, JCTree.JCAnnotation ast, JavacNode annotationNode) {
        HandleMybatisParam.handle(annotationNode);
    }

    private static void handle(JavacNode annotationNode) {
        JavacNode node = (JavacNode)annotationNode.up();
        if (node != null) {
            for (JavacNode child : node.down()) {
                if (!AST.Kind.METHOD.equals((Object)child.getKind())) continue;
                HandleMybatisParam.handleMethod(child);
            }
        }
    }

    private static void handleMethod(JavacNode method) {
        List<JCTree.JCVariableDecl> params = ((JCTree.JCMethodDecl)method.get()).params;
        if (params.size() <= 1) {
            return;
        }
        JavacTreeMaker maker = method.getTreeMaker();
        JCTree.JCExpression type = JavacHandlerUtil.chainDotsString((JavacNode)method, (String)PARAM);
        for (JCTree.JCVariableDecl param : params) {
            if (HandleMybatisParam.hasParam(method, param.mods.annotations)) continue;
            List<JCTree.JCLiteral> args = List.of(maker.Literal((Object)param.name.toString()));
            JCTree.JCAnnotation annotation = maker.Annotation((JCTree)type, args);
            param.mods.annotations = param.mods.annotations.append(annotation);
        }
    }

    private static boolean hasParam(JavacNode method, List<JCTree.JCAnnotation> annotations) {
        if (annotations == null || annotations.isEmpty()) {
            return false;
        }
        TypeLibrary typeLibrary = TypeLibrary.createLibraryForSingleType((String)PARAM);
        TypeResolver typeResolver = new TypeResolver(method.getImportList());
        for (JCTree.JCAnnotation annotation : annotations) {
            String type = annotation.annotationType.toString();
            String fqn = typeResolver.typeRefToFullyQualifiedName((LombokNode)method, typeLibrary, type);
            if (!PARAM.equals(fqn)) continue;
            return true;
        }
        return false;
    }
}

