/*
 * Decompiled with CFR 0.152.
 */
package me.pjq.musicplayer;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import me.pjq.musicplayer.MusicPlayerConfig;
import me.pjq.musicplayer.MusicPlayerItem;

public interface IMusicPlayerListener
extends IInterface {
    public String getListenerTag() throws RemoteException;

    public void onVideoSizeChanged(int var1, int var2) throws RemoteException;

    public void onSeekComplete() throws RemoteException;

    public boolean onInfo(int var1, int var2) throws RemoteException;

    public void onCompletion() throws RemoteException;

    public void onPrepared() throws RemoteException;

    public boolean onError(int var1, int var2) throws RemoteException;

    public void onBufferingUpdate(int var1) throws RemoteException;

    public void onStop() throws RemoteException;

    public void onPause() throws RemoteException;

    public void onStart() throws RemoteException;

    public void onSeekTo(int var1) throws RemoteException;

    public void onPrev(MusicPlayerItem var1, int var2) throws RemoteException;

    public void onNext(MusicPlayerItem var1, int var2) throws RemoteException;

    public void onPrePlaying(MusicPlayerItem var1, int var2) throws RemoteException;

    public void onStartPlaying(MusicPlayerItem var1) throws RemoteException;

    public void onUpdatePlayingProgress(MusicPlayerItem var1, int var2, int var3) throws RemoteException;

    public void onUpdateStepCount(int var1) throws RemoteException;

    public void onUpdateStepFrequency(float var1, float var2) throws RemoteException;

    public void onShowMessage(MusicPlayerItem var1, int var2, String var3) throws RemoteException;

    public MusicPlayerConfig getPlayerConfig() throws RemoteException;

    public void onPlayerListChange() throws RemoteException;

    public void onSavePlayingProgress(MusicPlayerItem var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IMusicPlayerListener {
        private static final String DESCRIPTOR = "me.pjq.musicplayer.IMusicPlayerListener";
        static final int TRANSACTION_getListenerTag = 1;
        static final int TRANSACTION_onVideoSizeChanged = 2;
        static final int TRANSACTION_onSeekComplete = 3;
        static final int TRANSACTION_onInfo = 4;
        static final int TRANSACTION_onCompletion = 5;
        static final int TRANSACTION_onPrepared = 6;
        static final int TRANSACTION_onError = 7;
        static final int TRANSACTION_onBufferingUpdate = 8;
        static final int TRANSACTION_onStop = 9;
        static final int TRANSACTION_onPause = 10;
        static final int TRANSACTION_onStart = 11;
        static final int TRANSACTION_onSeekTo = 12;
        static final int TRANSACTION_onPrev = 13;
        static final int TRANSACTION_onNext = 14;
        static final int TRANSACTION_onPrePlaying = 15;
        static final int TRANSACTION_onStartPlaying = 16;
        static final int TRANSACTION_onUpdatePlayingProgress = 17;
        static final int TRANSACTION_onUpdateStepCount = 18;
        static final int TRANSACTION_onUpdateStepFrequency = 19;
        static final int TRANSACTION_onShowMessage = 20;
        static final int TRANSACTION_getPlayerConfig = 21;
        static final int TRANSACTION_onPlayerListChange = 22;
        static final int TRANSACTION_onSavePlayingProgress = 23;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IMusicPlayerListener asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IMusicPlayerListener) {
                return (IMusicPlayerListener)iin;
            }
            return new Proxy(obj);
        }

        public IBinder asBinder() {
            return this;
        }

        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            switch (code) {
                case 1598968902: {
                    reply.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    data.enforceInterface(DESCRIPTOR);
                    String _result = this.getListenerTag();
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
                case 2: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    this.onVideoSizeChanged(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 3: {
                    data.enforceInterface(DESCRIPTOR);
                    this.onSeekComplete();
                    reply.writeNoException();
                    return true;
                }
                case 4: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    boolean _result = this.onInfo(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 5: {
                    data.enforceInterface(DESCRIPTOR);
                    this.onCompletion();
                    reply.writeNoException();
                    return true;
                }
                case 6: {
                    data.enforceInterface(DESCRIPTOR);
                    this.onPrepared();
                    reply.writeNoException();
                    return true;
                }
                case 7: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    boolean _result = this.onError(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 8: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    this.onBufferingUpdate(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 9: {
                    data.enforceInterface(DESCRIPTOR);
                    this.onStop();
                    reply.writeNoException();
                    return true;
                }
                case 10: {
                    data.enforceInterface(DESCRIPTOR);
                    this.onPause();
                    reply.writeNoException();
                    return true;
                }
                case 11: {
                    data.enforceInterface(DESCRIPTOR);
                    this.onStart();
                    reply.writeNoException();
                    return true;
                }
                case 12: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    this.onSeekTo(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 13: {
                    data.enforceInterface(DESCRIPTOR);
                    MusicPlayerItem _arg0 = 0 != data.readInt() ? (MusicPlayerItem)MusicPlayerItem.CREATOR.createFromParcel(data) : null;
                    int _arg1 = data.readInt();
                    this.onPrev(_arg0, _arg1);
                    reply.writeNoException();
                    if (_arg0 != null) {
                        reply.writeInt(1);
                        _arg0.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 14: {
                    data.enforceInterface(DESCRIPTOR);
                    MusicPlayerItem _arg0 = 0 != data.readInt() ? (MusicPlayerItem)MusicPlayerItem.CREATOR.createFromParcel(data) : null;
                    int _arg1 = data.readInt();
                    this.onNext(_arg0, _arg1);
                    reply.writeNoException();
                    if (_arg0 != null) {
                        reply.writeInt(1);
                        _arg0.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 15: {
                    data.enforceInterface(DESCRIPTOR);
                    MusicPlayerItem _arg0 = 0 != data.readInt() ? (MusicPlayerItem)MusicPlayerItem.CREATOR.createFromParcel(data) : null;
                    int _arg1 = data.readInt();
                    this.onPrePlaying(_arg0, _arg1);
                    reply.writeNoException();
                    if (_arg0 != null) {
                        reply.writeInt(1);
                        _arg0.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 16: {
                    data.enforceInterface(DESCRIPTOR);
                    MusicPlayerItem _arg0 = 0 != data.readInt() ? (MusicPlayerItem)MusicPlayerItem.CREATOR.createFromParcel(data) : null;
                    this.onStartPlaying(_arg0);
                    reply.writeNoException();
                    if (_arg0 != null) {
                        reply.writeInt(1);
                        _arg0.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 17: {
                    data.enforceInterface(DESCRIPTOR);
                    MusicPlayerItem _arg0 = 0 != data.readInt() ? (MusicPlayerItem)MusicPlayerItem.CREATOR.createFromParcel(data) : null;
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    this.onUpdatePlayingProgress(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    if (_arg0 != null) {
                        reply.writeInt(1);
                        _arg0.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 18: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    this.onUpdateStepCount(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 19: {
                    data.enforceInterface(DESCRIPTOR);
                    float _arg0 = data.readFloat();
                    float _arg1 = data.readFloat();
                    this.onUpdateStepFrequency(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 20: {
                    data.enforceInterface(DESCRIPTOR);
                    MusicPlayerItem _arg0 = 0 != data.readInt() ? (MusicPlayerItem)MusicPlayerItem.CREATOR.createFromParcel(data) : null;
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    this.onShowMessage(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    if (_arg0 != null) {
                        reply.writeInt(1);
                        _arg0.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 21: {
                    data.enforceInterface(DESCRIPTOR);
                    MusicPlayerConfig _result = this.getPlayerConfig();
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 22: {
                    data.enforceInterface(DESCRIPTOR);
                    this.onPlayerListChange();
                    reply.writeNoException();
                    return true;
                }
                case 23: {
                    data.enforceInterface(DESCRIPTOR);
                    MusicPlayerItem _arg0 = 0 != data.readInt() ? (MusicPlayerItem)MusicPlayerItem.CREATOR.createFromParcel(data) : null;
                    this.onSavePlayingProgress(_arg0);
                    reply.writeNoException();
                    if (_arg0 != null) {
                        reply.writeInt(1);
                        _arg0.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        private static class Proxy
        implements IMusicPlayerListener {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getListenerTag() throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onVideoSizeChanged(int width, int height) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(width);
                    _data.writeInt(height);
                    this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            @Override
            public void onSeekComplete() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean onInfo(int what, int extra) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(what);
                    _data.writeInt(extra);
                    this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            @Override
            public void onCompletion() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            @Override
            public void onPrepared() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean onError(int what, int extra) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(what);
                    _data.writeInt(extra);
                    this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onBufferingUpdate(int percent) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(percent);
                    this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            @Override
            public void onStop() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            @Override
            public void onPause() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            @Override
            public void onStart() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSeekTo(int position) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(position);
                    this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPrev(MusicPlayerItem object, int itemIndex) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (object != null) {
                        _data.writeInt(1);
                        object.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(itemIndex);
                    this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                    if (0 != _reply.readInt()) {
                        object.readFromParcel(_reply);
                    }
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNext(MusicPlayerItem object, int itemIndex) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (object != null) {
                        _data.writeInt(1);
                        object.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(itemIndex);
                    this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                    if (0 != _reply.readInt()) {
                        object.readFromParcel(_reply);
                    }
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPrePlaying(MusicPlayerItem item, int itemIndex) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (item != null) {
                        _data.writeInt(1);
                        item.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(itemIndex);
                    this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                    if (0 != _reply.readInt()) {
                        item.readFromParcel(_reply);
                    }
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onStartPlaying(MusicPlayerItem item) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (item != null) {
                        _data.writeInt(1);
                        item.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                    if (0 != _reply.readInt()) {
                        item.readFromParcel(_reply);
                    }
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onUpdatePlayingProgress(MusicPlayerItem item, int itemIndex, int position) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (item != null) {
                        _data.writeInt(1);
                        item.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(itemIndex);
                    _data.writeInt(position);
                    this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                    if (0 != _reply.readInt()) {
                        item.readFromParcel(_reply);
                    }
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onUpdateStepCount(int stepCount) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(stepCount);
                    this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onUpdateStepFrequency(float freq, float avgFreq) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeFloat(freq);
                    _data.writeFloat(avgFreq);
                    this.mRemote.transact(19, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onShowMessage(MusicPlayerItem item, int type, String message) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (item != null) {
                        _data.writeInt(1);
                        item.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(type);
                    _data.writeString(message);
                    this.mRemote.transact(20, _data, _reply, 0);
                    _reply.readException();
                    if (0 != _reply.readInt()) {
                        item.readFromParcel(_reply);
                    }
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public MusicPlayerConfig getPlayerConfig() throws RemoteException {
                MusicPlayerConfig _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(21, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? (MusicPlayerConfig)MusicPlayerConfig.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            @Override
            public void onPlayerListChange() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(22, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSavePlayingProgress(MusicPlayerItem item) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (item != null) {
                        _data.writeInt(1);
                        item.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(23, _data, _reply, 0);
                    _reply.readException();
                    if (0 != _reply.readInt()) {
                        item.readFromParcel(_reply);
                    }
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }
}

