/*
 * Decompiled with CFR 0.152.
 */
package me.pjq.musicplayer;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;

public class MusicPlayerItem
implements Parcelable {
    String url;
    String name;
    String description;
    int position;
    int fileType;
    int time;
    int playingStatus;
    int isNeedOrder;
    int musicId;
    String musicAlbumId;
    long fileSize;
    public static final Parcelable.Creator<MusicPlayerItem> CREATOR = new Parcelable.Creator<MusicPlayerItem>(){

        public MusicPlayerItem createFromParcel(Parcel in) {
            return new MusicPlayerItem(in);
        }

        public MusicPlayerItem[] newArray(int size) {
            return new MusicPlayerItem[size];
        }
    };

    public MusicPlayerItem() {
        this.url = "";
        this.name = "";
        this.time = 0;
        this.description = "";
        this.position = 0;
        this.fileType = 45;
        this.playingStatus = 36;
        this.isNeedOrder = -1;
        this.musicId = 0;
        this.musicAlbumId = "";
        this.fileSize = 0L;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("url=" + this.url + '\n');
        stringBuilder.append("name=" + this.name + '\n');
        stringBuilder.append("time=" + this.time + '\n');
        stringBuilder.append("description=" + this.description + '\n');
        stringBuilder.append("position=" + this.position + '\n');
        stringBuilder.append("fileType=" + this.fileType + '\n');
        stringBuilder.append("playingStatus=" + this.playingStatus + '\n');
        stringBuilder.append("isNeedOrder=" + this.isNeedOrder + '\n');
        stringBuilder.append("musicId=" + this.musicId + '\n');
        stringBuilder.append("mRpidBookId=" + this.musicAlbumId + '\n');
        return stringBuilder.toString();
    }

    public void writeToParcel(Parcel out, int flags) {
        out.writeString(this.url);
        out.writeString(this.name);
        out.writeString(this.description);
        out.writeInt(this.position);
        out.writeInt(this.fileType);
        out.writeInt(this.time);
        out.writeInt(this.playingStatus);
        out.writeInt(this.isNeedOrder);
        out.writeInt(this.musicId);
        out.writeString(this.musicAlbumId);
        out.writeLong(this.fileSize);
    }

    private MusicPlayerItem(Parcel in) {
        this.readFromParcel2(in);
    }

    private void readFromParcel2(Parcel in) {
        this.url = in.readString();
        this.name = in.readString();
        this.description = in.readString();
        this.position = in.readInt();
        this.fileType = in.readInt();
        this.time = in.readInt();
        this.playingStatus = in.readInt();
        this.isNeedOrder = in.readInt();
        this.musicId = in.readInt();
        this.musicAlbumId = in.readString();
        this.fileSize = in.readLong();
    }

    public void readFromParcel(Parcel in) {
        this.readFromParcel2(in);
    }

    public int hashCode() {
        int result = 17;
        return result += this.musicId * 31;
    }

    public boolean equals(Object o) {
        if (null == o) {
            return false;
        }
        MusicPlayerItem other = (MusicPlayerItem)o;
        return this.url.equalsIgnoreCase(other.getUrl());
    }

    public String getUrl() {
        if (null == this.url) {
            this.url = "";
        }
        this.url = this.url.replace(" ", "%20");
        return this.url;
    }

    public void setUrl(String url) {
        if (!TextUtils.isEmpty((CharSequence)url)) {
            // empty if block
        }
        this.url = url;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getTime() {
        return this.time;
    }

    public String getTimeReadable() {
        int ss = this.time / 1000;
        int bb_1 = ss / 60;
        int bb_2 = ss % 60;
        String bb_11 = "";
        String bb_22 = "";
        bb_11 = bb_1 < 10 ? "0" + bb_1 : "" + bb_1;
        bb_22 = bb_2 < 10 ? "0" + bb_2 : "" + bb_2;
        String bofangshijian = bb_11 + ":" + bb_22;
        return bofangshijian;
    }

    public void setTime(int time) {
        this.time = time;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public int getFileType() {
        return this.fileType;
    }

    public void setFileType(int fileType) {
        this.fileType = fileType;
    }

    public boolean isLocalFileType() {
        return !this.isUrlType();
    }

    public boolean isUrlType() {
        if (!TextUtils.isEmpty((CharSequence)this.url)) {
            if (this.url.startsWith("file://")) {
                return false;
            }
            if (this.url.startsWith("http://")) {
                return true;
            }
        }
        return this.fileType == 45;
    }

    public int getPlayingStatus() {
        return this.playingStatus;
    }

    public void setPlayingStatus(int playingStatus) {
        this.playingStatus = playingStatus;
    }

    public boolean isPlaying() {
        return 40 == this.playingStatus;
    }

    public int getIsNeedOrder() {
        return this.isNeedOrder;
    }

    public void setIsNeedOrder(boolean isNeedOrder) {
        this.isNeedOrder = true == isNeedOrder ? 1 : -1;
    }

    public boolean isNeedOrder() {
        return 1 == this.isNeedOrder;
    }

    public int describeContents() {
        return 0;
    }

    public int getMusicId() {
        return this.musicId;
    }

    public void setMusicId(int musicId) {
        this.musicId = musicId;
    }

    public String getMusicAlbumId() {
        return this.musicAlbumId;
    }

    public void setMusicAlbumId(String musicAlbumId) {
        this.musicAlbumId = musicAlbumId;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public void setFileSize(long fileSize) {
        this.fileSize = fileSize;
    }
}

