/*
 * Decompiled with CFR 0.152.
 */
package me.pjq.musicplayer;

import android.content.Context;
import android.os.RemoteException;
import android.util.Log;
import java.util.ArrayList;
import java.util.Vector;
import me.pjq.musicplayer.IMusicPlayerListener;
import me.pjq.musicplayer.MusicAlbumObject;
import me.pjq.musicplayer.MusicPlayerConfig;
import me.pjq.musicplayer.MusicPlayerItem;
import me.pjq.musicplayer.utils.Utils;

public class MusicPlayerListeners {
    private Vector<IMusicPlayerListener> mIPlayerListeners = new Vector();

    public synchronized boolean setPlayerListener(IMusicPlayerListener listener) {
        if (null == listener) {
            return false;
        }
        try {
            int index = this.contains(listener);
            if (index < 0) {
                this.mIPlayerListeners.add(listener);
                Utils.i("PlayerListeners", "setPlayerListener,add listener success, listener=" + listener.getListenerTag());
                return true;
            }
            this.mIPlayerListeners.remove(index);
            this.mIPlayerListeners.add(listener);
            Utils.i("PlayerListeners", "setPlayerListener,already exists, listener=" + listener.getListenerTag());
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private int contains(IMusicPlayerListener listener) {
        int size = this.mIPlayerListeners.size();
        for (int i = 0; i < size; ++i) {
            IMusicPlayerListener item = this.mIPlayerListeners.get(i);
            try {
                if (!item.getListenerTag().equals(listener.getListenerTag())) continue;
                return i;
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        return -1;
    }

    private ArrayList<IMusicPlayerListener> containsCount(IMusicPlayerListener listener) {
        int size = this.mIPlayerListeners.size();
        ArrayList<IMusicPlayerListener> indexList = new ArrayList<IMusicPlayerListener>();
        for (int i = 0; i < size; ++i) {
            IMusicPlayerListener item = this.mIPlayerListeners.get(i);
            try {
                if (!item.getListenerTag().equals(listener.getListenerTag())) continue;
                indexList.add(item);
                continue;
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        return indexList;
    }

    public synchronized boolean unSetPlayerListener(IMusicPlayerListener listener) {
        if (null == listener) {
            return false;
        }
        try {
            ArrayList<IMusicPlayerListener> indexList = this.containsCount(listener);
            int count = indexList.size();
            if (count >= 1) {
                for (int i = 0; i < count; ++i) {
                    this.mIPlayerListeners.remove(indexList.get(i));
                }
                Utils.i("PlayerListeners", "unSetPlayerListener,remove success, listener=" + listener.getListenerTag());
                return true;
            }
            Utils.i("PlayerListeners", "unSetPlayerListener,remove failed,count<=1, listener=" + listener.getListenerTag());
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void onVideoSizeChanged(int width, int height) throws RemoteException {
        int size = this.mIPlayerListeners.size();
        for (int i = 0; i < size; ++i) {
            IMusicPlayerListener listener = this.mIPlayerListeners.get(i);
            try {
                listener.onVideoSizeChanged(width, height);
                continue;
            }
            catch (RemoteException e) {
                e.printStackTrace();
                size = this.remoteExceptionHandle(listener);
            }
        }
    }

    public void onSeekComplete() throws RemoteException {
        int size = this.mIPlayerListeners.size();
        for (int i = 0; i < size; ++i) {
            IMusicPlayerListener listener = this.mIPlayerListeners.get(i);
            try {
                listener.onSeekComplete();
                continue;
            }
            catch (RemoteException e) {
                e.printStackTrace();
                size = this.remoteExceptionHandle(listener);
            }
        }
    }

    public boolean onInfo(int what, int extra) throws RemoteException {
        int size = this.mIPlayerListeners.size();
        for (int i = 0; i < size; ++i) {
            IMusicPlayerListener listener = this.mIPlayerListeners.get(i);
            try {
                listener.onInfo(what, extra);
                continue;
            }
            catch (RemoteException e) {
                e.printStackTrace();
                size = this.remoteExceptionHandle(listener);
            }
        }
        return false;
    }

    public void onCompletion() throws RemoteException {
        int size = this.mIPlayerListeners.size();
        for (int i = 0; i < size; ++i) {
            IMusicPlayerListener listener = this.mIPlayerListeners.get(i);
            try {
                listener.onCompletion();
                continue;
            }
            catch (RemoteException e) {
                e.printStackTrace();
                size = this.remoteExceptionHandle(listener);
            }
        }
    }

    public void onPrepared() throws RemoteException {
        int size = this.mIPlayerListeners.size();
        for (int i = 0; i < size; ++i) {
            IMusicPlayerListener listener = this.mIPlayerListeners.get(i);
            try {
                listener.onPrepared();
                continue;
            }
            catch (RemoteException e) {
                e.printStackTrace();
                size = this.remoteExceptionHandle(listener);
            }
        }
    }

    public boolean onError(int what, int extra) throws RemoteException {
        int size = this.mIPlayerListeners.size();
        for (int i = 0; i < size; ++i) {
            IMusicPlayerListener listener = this.mIPlayerListeners.get(i);
            try {
                listener.onError(what, extra);
                continue;
            }
            catch (RemoteException e) {
                e.printStackTrace();
                size = this.remoteExceptionHandle(listener);
            }
        }
        return false;
    }

    public void onBufferingUpdate(int percent) throws RemoteException {
        int size = this.mIPlayerListeners.size();
        for (int i = 0; i < size; ++i) {
            IMusicPlayerListener listener = this.mIPlayerListeners.get(i);
            try {
                listener.onBufferingUpdate(percent);
                continue;
            }
            catch (RemoteException e) {
                e.printStackTrace();
                size = this.remoteExceptionHandle(listener);
            }
        }
    }

    public void onStop() throws RemoteException {
        int size = this.mIPlayerListeners.size();
        for (int i = 0; i < size; ++i) {
            IMusicPlayerListener listener = this.mIPlayerListeners.get(i);
            try {
                listener.onStop();
                continue;
            }
            catch (RemoteException e) {
                e.printStackTrace();
                size = this.remoteExceptionHandle(listener);
            }
        }
    }

    public void onPause() throws RemoteException {
        int size = this.mIPlayerListeners.size();
        for (int i = 0; i < size; ++i) {
            IMusicPlayerListener listener = this.mIPlayerListeners.get(i);
            try {
                listener.onPause();
                continue;
            }
            catch (RemoteException e) {
                e.printStackTrace();
                size = this.remoteExceptionHandle(listener);
            }
        }
    }

    public void onStart() throws RemoteException {
        int size = this.mIPlayerListeners.size();
        for (int i = 0; i < size; ++i) {
            IMusicPlayerListener listener = this.mIPlayerListeners.get(i);
            try {
                listener.onStart();
                continue;
            }
            catch (RemoteException e) {
                e.printStackTrace();
                size = this.remoteExceptionHandle(listener);
            }
        }
    }

    public void onSeekTo(int position) throws RemoteException {
        int size = this.mIPlayerListeners.size();
        for (int i = 0; i < size; ++i) {
            IMusicPlayerListener listener = this.mIPlayerListeners.get(i);
            try {
                listener.onSeekTo(position);
                continue;
            }
            catch (RemoteException e) {
                e.printStackTrace();
                size = this.remoteExceptionHandle(listener);
            }
        }
    }

    public void onPrev(MusicPlayerItem object, int itemIndex) throws RemoteException {
        int size = this.mIPlayerListeners.size();
        for (int i = 0; i < size; ++i) {
            IMusicPlayerListener listener = this.mIPlayerListeners.get(i);
            try {
                listener.onPrev(object, itemIndex);
                continue;
            }
            catch (RemoteException e) {
                e.printStackTrace();
                size = this.remoteExceptionHandle(listener);
            }
        }
    }

    public void onNext(MusicPlayerItem object, int itemIndex) throws RemoteException {
        int size = this.mIPlayerListeners.size();
        for (int i = 0; i < size; ++i) {
            IMusicPlayerListener listener = this.mIPlayerListeners.get(i);
            try {
                listener.onNext(object, itemIndex);
                continue;
            }
            catch (RemoteException e) {
                e.printStackTrace();
                size = this.remoteExceptionHandle(listener);
            }
        }
    }

    public void onPrePlaying(MusicPlayerItem item, int itemIndex) throws RemoteException {
        int size = this.mIPlayerListeners.size();
        for (int i = 0; i < size; ++i) {
            IMusicPlayerListener listener = this.mIPlayerListeners.get(i);
            try {
                listener.onPrePlaying(item, itemIndex);
                continue;
            }
            catch (RemoteException e) {
                e.printStackTrace();
                size = this.remoteExceptionHandle(listener);
            }
        }
    }

    public void onStartPlaying(MusicPlayerItem item) throws RemoteException {
        int size = this.mIPlayerListeners.size();
        for (int i = 0; i < size; ++i) {
            IMusicPlayerListener listener = this.mIPlayerListeners.get(i);
            try {
                listener.onStartPlaying(item);
                continue;
            }
            catch (RemoteException e) {
                e.printStackTrace();
                size = this.remoteExceptionHandle(listener);
            }
        }
    }

    public void onUpdatePlayingProgress(MusicPlayerItem item, int itemIndex, int position) {
        int size = this.mIPlayerListeners.size();
        for (int i = 0; i < size; ++i) {
            IMusicPlayerListener listener = this.mIPlayerListeners.get(i);
            try {
                listener.onUpdatePlayingProgress(item, itemIndex, position);
                continue;
            }
            catch (RemoteException e) {
                e.printStackTrace();
                size = this.remoteExceptionHandle(listener);
            }
        }
    }

    public void onUpdateStepCount(int stepCount) {
        int size = this.mIPlayerListeners.size();
        for (int i = 0; i < size; ++i) {
            IMusicPlayerListener listener = this.mIPlayerListeners.get(i);
            try {
                listener.onUpdateStepCount(stepCount);
                continue;
            }
            catch (RemoteException e) {
                e.printStackTrace();
                size = this.remoteExceptionHandle(listener);
            }
        }
    }

    public void onUpdateStepFreq(float freq, float avgFreq) {
        int size = this.mIPlayerListeners.size();
        for (int i = 0; i < size; ++i) {
            IMusicPlayerListener listener = this.mIPlayerListeners.get(i);
            try {
                listener.onUpdateStepFrequency(freq, avgFreq);
                continue;
            }
            catch (RemoteException e) {
                e.printStackTrace();
                size = this.remoteExceptionHandle(listener);
            }
        }
    }

    private int remoteExceptionHandle(IMusicPlayerListener listener) {
        this.mIPlayerListeners.remove(listener);
        listener = null;
        return this.mIPlayerListeners.size();
    }

    public void onShowMessage(MusicPlayerItem item, int type, String message) throws RemoteException {
        int size = this.mIPlayerListeners.size();
        for (int i = 0; i < size; ++i) {
            IMusicPlayerListener listener = this.mIPlayerListeners.get(i);
            try {
                listener.onShowMessage(item, type, message);
                continue;
            }
            catch (RemoteException e) {
                e.printStackTrace();
                size = this.remoteExceptionHandle(listener);
            }
        }
    }

    public MusicPlayerConfig getPlayerConfig() {
        int size = this.mIPlayerListeners.size();
        MusicPlayerConfig config = null;
        for (int i = 0; i < size; ++i) {
            IMusicPlayerListener listener = null;
            try {
                listener = this.mIPlayerListeners.get(i);
                config = listener.getPlayerConfig();
                if (null == config) continue;
                break;
            }
            catch (RemoteException e) {
                e.printStackTrace();
                size = this.remoteExceptionHandle(listener);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return config;
    }

    public void onPlayerListChange() {
        int size = this.mIPlayerListeners.size();
        for (int i = 0; i < size; ++i) {
            IMusicPlayerListener listener = this.mIPlayerListeners.get(i);
            try {
                listener.onPlayerListChange();
                continue;
            }
            catch (RemoteException e) {
                e.printStackTrace();
                size = this.remoteExceptionHandle(listener);
            }
        }
    }

    public void onSavePlayingProgress(Context context, MusicPlayerItem item, MusicAlbumObject musicList, int totalCount, int index) {
        if (null == item) {
            return;
        }
        this.savePlayingStatus(context, item, musicList, totalCount, index);
        Log.i((String)"PlayerListeners", (String)("onSavePlayingProgress,item=" + item));
        int size = this.mIPlayerListeners.size();
        for (int i = 0; i < size; ++i) {
            IMusicPlayerListener listener = null;
            try {
                listener = this.mIPlayerListeners.get(i);
                listener.onSavePlayingProgress(item);
                continue;
            }
            catch (RemoteException e) {
                e.printStackTrace();
                size = this.remoteExceptionHandle(listener);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void savePlayingStatus(Context context, MusicPlayerItem item, MusicAlbumObject musicList, int totalCount, int index) {
        if (null == item) {
            return;
        }
    }

    public void clear() {
        this.mIPlayerListeners.clear();
        this.mIPlayerListeners = null;
    }
}

