/*
 * Decompiled with CFR 0.152.
 */
package me.pjq.musicplayer;

import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.Parcelable;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.LinearInterpolator;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.SeekBar;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.List;
import me.pjq.musicplayer.IMusicPlayerListener;
import me.pjq.musicplayer.IMusicPlayerService;
import me.pjq.musicplayer.MusicAlbumObject;
import me.pjq.musicplayer.MusicPlayerConfig;
import me.pjq.musicplayer.MusicPlayerConstants;
import me.pjq.musicplayer.MusicPlayerItem;
import me.pjq.musicplayer.MusicPlayerUIBridgeInterface;
import me.pjq.musicplayer.R;
import me.pjq.musicplayer.utils.PlayerUtils;
import me.pjq.musicplayer.utils.ToastUtil;

public class MusicPlayerMainView
extends LinearLayout
implements View.OnClickListener,
MusicPlayerConstants {
    private static String TAG = MusicPlayerMainView.class.getSimpleName();
    private static final boolean DEBUG_LOG = true;
    private IMusicPlayerService mIMusicPlayerService;
    private Context mContext;
    private View mPlayPauseLinLayout;
    private LinearLayout mMp3upLinLayout;
    private View mMp3downLinLayout;
    private ImageView mPlayorpauseIv;
    private TextView mPlayingTimeTv;
    private TextView mPlayzongTimeTv;
    private SeekBar mSeekBar;
    private ProgressBar mProBarlarge;
    private View mView;
    private MusicPlayerUIBridgeInterface mPlayerUIInterface;
    boolean isSimpleView = true;
    private boolean mIsInSeekMode = false;
    ObjectAnimator animator;
    private IMusicPlayerListener mPlayerListener = new IMusicPlayerListener.Stub(){

        @Override
        public void onStop() {
            MusicPlayerMainView.this.log("onStop");
            MusicPlayerMainView.this.mLocalHandler.sendEmptyMessage(1);
        }

        @Override
        public void onStart() {
            MusicPlayerMainView.this.log("onStart");
            MusicPlayerMainView.this.mLocalHandler.sendEmptyMessage(2);
        }

        @Override
        public void onSeekTo(int position) {
            MusicPlayerMainView.this.log("onSeekTo,position=" + position);
            Message msg = MusicPlayerMainView.this.mLocalHandler.obtainMessage(3);
            Bundle data = new Bundle();
            data.putInt("position", position);
            msg.setData(data);
            MusicPlayerMainView.this.mLocalHandler.sendMessage(msg);
        }

        @Override
        public void onPause() {
            MusicPlayerMainView.this.log("onPause");
            MusicPlayerMainView.this.mLocalHandler.sendEmptyMessage(4);
        }

        @Override
        public void onCompletion() {
            MusicPlayerMainView.this.log("onCompletion");
            MusicPlayerMainView.this.mLocalHandler.sendEmptyMessage(5);
        }

        @Override
        public void onPrev(MusicPlayerItem item, int itemIndex) {
            MusicPlayerMainView.this.log("onPrev");
            Message msg = MusicPlayerMainView.this.mLocalHandler.obtainMessage(6);
            Bundle data = new Bundle();
            data.putParcelable("player_item", (Parcelable)item);
            data.putInt("index", itemIndex);
            msg.setData(data);
            MusicPlayerMainView.this.mLocalHandler.sendMessage(msg);
        }

        @Override
        public void onNext(MusicPlayerItem item, int itemIndex) {
            MusicPlayerMainView.this.log("onNext");
            Message msg = MusicPlayerMainView.this.mLocalHandler.obtainMessage(7);
            Bundle data = new Bundle();
            data.putParcelable("player_item", (Parcelable)item);
            data.putInt("index", itemIndex);
            msg.setData(data);
            MusicPlayerMainView.this.mLocalHandler.sendMessage(msg);
        }

        @Override
        public void onPrePlaying(MusicPlayerItem item, int itemIndex) {
            MusicPlayerMainView.this.log("onPrePlaying");
            Message msg = MusicPlayerMainView.this.mLocalHandler.obtainMessage(8);
            Bundle data = new Bundle();
            data.putParcelable("player_item", (Parcelable)item);
            data.putInt("index", itemIndex);
            msg.setData(data);
            MusicPlayerMainView.this.mLocalHandler.sendMessage(msg);
        }

        @Override
        public void onStartPlaying(MusicPlayerItem item) {
            MusicPlayerMainView.this.log("onStartPlaying");
            Message msg = MusicPlayerMainView.this.mLocalHandler.obtainMessage(9);
            Bundle data = new Bundle();
            data.putParcelable("player_item", (Parcelable)item);
            msg.setData(data);
            MusicPlayerMainView.this.mLocalHandler.sendMessage(msg);
        }

        @Override
        public void onUpdatePlayingProgress(MusicPlayerItem item, int itemIndex, int position) {
            Message msg = MusicPlayerMainView.this.mLocalHandler.obtainMessage(10);
            Bundle data = new Bundle();
            data.putParcelable("player_item", (Parcelable)item);
            data.putInt("index", itemIndex);
            data.putInt("position", position);
            msg.setData(data);
            MusicPlayerMainView.this.mLocalHandler.sendMessage(msg);
        }

        @Override
        public void onUpdateStepCount(int stepCount) throws RemoteException {
            Message msg = MusicPlayerMainView.this.mLocalHandler.obtainMessage(30);
            Bundle data = new Bundle();
            data.putInt("count", stepCount);
            msg.setData(data);
            MusicPlayerMainView.this.mLocalHandler.sendMessage(msg);
        }

        @Override
        public void onUpdateStepFrequency(float freq, float avgFreq) throws RemoteException {
            Message msg = MusicPlayerMainView.this.mLocalHandler.obtainMessage(29);
            Bundle data = new Bundle();
            data.putFloat("freq", freq);
            data.putFloat("avg_freq", avgFreq);
            msg.setData(data);
            MusicPlayerMainView.this.mLocalHandler.sendMessage(msg);
        }

        @Override
        public void onShowMessage(MusicPlayerItem item, int type, String message) {
            Message msg = MusicPlayerMainView.this.mLocalHandler.obtainMessage(11);
            Bundle data = new Bundle();
            data.putParcelable("player_item", (Parcelable)item);
            data.putInt("type", type);
            data.putString("msg", message);
            msg.setData(data);
            MusicPlayerMainView.this.mLocalHandler.sendMessage(msg);
        }

        @Override
        public void onVideoSizeChanged(int width, int height) throws RemoteException {
            MusicPlayerMainView.this.log("onVideoSizeChanged ,width=" + width + ",height=" + height);
            Message msg = MusicPlayerMainView.this.mLocalHandler.obtainMessage(14);
            Bundle data = new Bundle();
            data.putInt("width", width);
            data.putInt("height", width);
            msg.setData(data);
            MusicPlayerMainView.this.mLocalHandler.sendMessage(msg);
        }

        @Override
        public void onSeekComplete() throws RemoteException {
            MusicPlayerMainView.this.log("onSeekComplete");
            MusicPlayerMainView.this.mLocalHandler.sendEmptyMessage(15);
        }

        @Override
        public boolean onInfo(int what, int extra) throws RemoteException {
            MusicPlayerMainView.this.log("onInfo,what=" + what + ",extra=" + extra);
            Message msg = MusicPlayerMainView.this.mLocalHandler.obtainMessage(16);
            Bundle data = new Bundle();
            data.putInt("what", what);
            data.putInt("extra", extra);
            msg.setData(data);
            MusicPlayerMainView.this.mLocalHandler.sendMessage(msg);
            return false;
        }

        @Override
        public void onPrepared() throws RemoteException {
            MusicPlayerMainView.this.log("onPrepared");
            MusicPlayerMainView.this.mLocalHandler.sendEmptyMessage(12);
        }

        @Override
        public boolean onError(int what, int extra) throws RemoteException {
            MusicPlayerMainView.this.log("onError,what=" + what + ",extra=" + extra);
            Message msg = MusicPlayerMainView.this.mLocalHandler.obtainMessage(17);
            Bundle data = new Bundle();
            data.putInt("what", what);
            data.putInt("extra", extra);
            msg.setData(data);
            MusicPlayerMainView.this.mLocalHandler.sendMessage(msg);
            return false;
        }

        @Override
        public void onBufferingUpdate(int percent) throws RemoteException {
            Message msg = MusicPlayerMainView.this.mLocalHandler.obtainMessage(13);
            Bundle data = new Bundle();
            data.putInt("percent", percent);
            msg.setData(data);
            MusicPlayerMainView.this.mLocalHandler.sendMessage(msg);
        }

        @Override
        public String getListenerTag() throws RemoteException {
            return MusicPlayerMainView.class.getSimpleName();
        }

        @Override
        public MusicPlayerConfig getPlayerConfig() throws RemoteException {
            if (null != MusicPlayerMainView.this.mPlayerUIInterface) {
                return MusicPlayerMainView.this.mPlayerUIInterface.getPlayerConfig();
            }
            return null;
        }

        @Override
        public void onPlayerListChange() throws RemoteException {
            MusicPlayerMainView.this.mLocalHandler.sendEmptyMessage(18);
        }

        @Override
        public void onSavePlayingProgress(MusicPlayerItem item) throws RemoteException {
            Message msg = MusicPlayerMainView.this.mLocalHandler.obtainMessage(19);
            Bundle data = new Bundle();
            data.putParcelable("player_item", (Parcelable)item);
            msg.setData(data);
            MusicPlayerMainView.this.mLocalHandler.sendMessage(msg);
        }
    };
    private Handler mLocalHandler = new Handler(){

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            int what = msg.what;
            switch (what) {
                case 1: {
                    MusicPlayerMainView.this.updatePlayingStatus(43);
                    MusicPlayerMainView.this.dismissWaitingDialog();
                    break;
                }
                case 2: {
                    MusicPlayerMainView.this.updatePlayingStatus(40);
                    break;
                }
                case 3: {
                    Bundle data = msg.getData();
                    int position = data.getInt("position");
                    MusicPlayerMainView.this.updatePlayingProgress(position);
                    break;
                }
                case 4: {
                    MusicPlayerMainView.this.updatePlayingStatus(41);
                    break;
                }
                case 5: {
                    MusicPlayerMainView.this.updatePlayingStatus(43);
                    break;
                }
                case 6: {
                    Bundle data = msg.getData();
                    MusicPlayerItem item = (MusicPlayerItem)data.getParcelable("player_item");
                    int itemIndex = data.getInt("index");
                    MusicPlayerMainView.this.updatePlayingChapterName(item, itemIndex);
                    if (null == item) break;
                    MusicPlayerMainView.this.updateOrderView(item.isNeedOrder());
                    break;
                }
                case 7: {
                    Bundle data = msg.getData();
                    MusicPlayerItem item = (MusicPlayerItem)data.getParcelable("player_item");
                    int itemIndex = data.getInt("index");
                    MusicPlayerMainView.this.updatePlayingChapterName(item, itemIndex);
                    if (null == item) break;
                    MusicPlayerMainView.this.updateOrderView(item.isNeedOrder());
                    break;
                }
                case 8: {
                    Bundle data = msg.getData();
                    MusicPlayerItem item = (MusicPlayerItem)data.getParcelable("player_item");
                    int itemIndex = data.getInt("index");
                    MusicPlayerMainView.this.updatePlayingChapterName(item, itemIndex);
                    MusicPlayerMainView.this.updateTotalTime(item);
                    MusicPlayerMainView.this.updatePlayingProgress(item.getPosition());
                    MusicPlayerMainView.this.mSeekBar.setEnabled(false);
                    MusicPlayerMainView.this.showWaitingDialog();
                    MusicPlayerMainView.this.updateBufferProgress(0);
                    MusicPlayerMainView.this.updatePlayingStatus(40);
                    if (null == item) break;
                    MusicPlayerMainView.this.updateOrderView(item.isNeedOrder());
                    break;
                }
                case 9: {
                    Bundle data = msg.getData();
                    MusicPlayerItem item = (MusicPlayerItem)data.getParcelable("player_item");
                    MusicPlayerMainView.this.mSeekBar.setEnabled(true);
                    MusicPlayerMainView.this.dismissWaitingDialog();
                    if (!item.isLocalFileType()) break;
                    break;
                }
                case 10: {
                    Bundle data = msg.getData();
                    MusicPlayerItem item = (MusicPlayerItem)data.getParcelable("player_item");
                    int itemIndex = data.getInt("index");
                    int position = data.getInt("position");
                    MusicPlayerMainView.this.updatePlayingProgress(position);
                    break;
                }
                case 29: {
                    Bundle data = msg.getData();
                    float freq = data.getFloat("freq");
                    float avgFreq = data.getFloat("avg_freq");
                    if (null == MusicPlayerMainView.this.mPlayerUIInterface) break;
                    MusicPlayerMainView.this.mPlayerUIInterface.onUpdateStepReq(freq, avgFreq);
                    break;
                }
                case 30: {
                    Bundle data = msg.getData();
                    int stepCount = data.getInt("count");
                    if (null == MusicPlayerMainView.this.mPlayerUIInterface) break;
                    MusicPlayerMainView.this.mPlayerUIInterface.onUpdateStepCount(stepCount);
                    break;
                }
                case 11: {
                    Bundle data = msg.getData();
                    MusicPlayerItem item = (MusicPlayerItem)data.getParcelable("player_item");
                    int type = data.getInt("type");
                    String message = data.getString("msg");
                    if (null == MusicPlayerMainView.this.mPlayerUIInterface) break;
                    MusicPlayerMainView.this.mPlayerUIInterface.onShowMessage(item, type, message);
                    break;
                }
                case 12: {
                    MusicPlayerMainView.this.log("MESSAGE_ON_PREPARED");
                    MusicPlayerMainView.this.updateTotalTime(MusicPlayerMainView.this.getCurrentPlayingItem());
                    MusicPlayerMainView.this.updateBufferProgress(0);
                    break;
                }
                case 13: {
                    Bundle data = msg.getData();
                    int percent = data.getInt("percent");
                    MusicPlayerMainView.this.updateBufferProgress(percent);
                    break;
                }
                case 14: {
                    Bundle data = msg.getData();
                    int width = data.getInt("width");
                    int height = data.getInt("height");
                    break;
                }
                case 15: {
                    break;
                }
                case 16: {
                    Bundle data = msg.getData();
                    int whatInt = data.getInt("what");
                    int extra = data.getInt("extra");
                    break;
                }
                case 17: {
                    Bundle data = msg.getData();
                    int whatInt = data.getInt("what");
                    int extra = data.getInt("extra");
                    if (whatInt != 1 || extra != -1004) break;
                    ToastUtil.showToast(MusicPlayerMainView.this.mContext, MusicPlayerMainView.this.mContext.getString(R.string.canot_play_error));
                    break;
                }
                case 18: {
                    MusicPlayerItem item = MusicPlayerMainView.this.getCurrentPlayingItem();
                    int index = MusicPlayerMainView.this.getCurrentPlayingIndex();
                    MusicPlayerMainView.this.updatePlayingChapterName(item, index);
                    if (null == item) break;
                    MusicPlayerMainView.this.updateOrderView(item.isNeedOrder());
                    break;
                }
                case 19: {
                    Bundle data = msg.getData();
                    MusicPlayerItem item = (MusicPlayerItem)data.getParcelable("player_item");
                    break;
                }
                case 20: {
                    MusicPlayerMainView.this.setPlayerListener();
                    break;
                }
            }
        }
    };
    private ServiceConnection mServiceConnection = new ServiceConnection(){

        public void onServiceDisconnected(ComponentName name) {
            MusicPlayerMainView.this.log("onServiceDisconnected");
        }

        public void onServiceConnected(ComponentName name, IBinder service) {
            MusicPlayerMainView.this.log("onServiceConnected");
            MusicPlayerMainView.this.mIMusicPlayerService = IMusicPlayerService.Stub.asInterface(service);
            if (null != MusicPlayerMainView.this.mIMusicPlayerService) {
                MusicPlayerItem item = MusicPlayerMainView.this.getCurrentPlayingItem();
                if (null != item) {
                    MusicPlayerMainView.this.log("recovery position:" + item.getPosition() + ",total time:" + MusicPlayerMainView.this.getCurrentPlayingTotalTime());
                    MusicPlayerMainView.this.updateTotalTime(item);
                    MusicPlayerMainView.this.updatePlayingProgress(item.getPosition());
                    MusicPlayerMainView.this.updatePlayingChapterName(item, MusicPlayerMainView.this.getCurrentPlayingIndex());
                }
                try {
                    MusicPlayerMainView.this.updatePlayingStatus(MusicPlayerMainView.this.mIMusicPlayerService.getPlayerPlayingStatus());
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
                MusicPlayerMainView.this.setPlayerListener();
                MusicPlayerMainView.this.onConnected();
            }
        }
    };
    int mSetListenerCount = 0;
    private boolean mAreadyInitVisible = false;
    MusicAlbumObject musicAlbumObject;
    ArrayList<MusicPlayerItem> musicList;

    public MusicPlayerMainView(Context context) {
        super(context);
        this.mContext = context;
        this.init();
    }

    public MusicPlayerMainView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        this.init();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mSetListenerCount = 0;
    }

    public void setPlayerUIInterface(MusicPlayerUIBridgeInterface playerUIInterface) {
        this.mPlayerUIInterface = playerUIInterface;
    }

    public void setMusicPlayerView(int resId) {
        this.mPlayPauseLinLayout.setBackgroundResource(resId);
    }

    private void initAnimation(boolean isPlaying) {
        if (this.isSimpleView) {
            if (null == this.animator) {
                this.animator = ObjectAnimator.ofFloat((Object)this.mPlayPauseLinLayout, (String)"rotation", (float[])new float[]{0.0f, 360.0f});
                this.animator.setInterpolator((TimeInterpolator)new LinearInterpolator());
                this.animator.setDuration(5000L);
                this.animator.setRepeatCount(-1);
            }
            if (isPlaying) {
                this.animator.start();
            } else {
                this.animator.pause();
            }
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.log("onDetachedFromWindow");
        PlayerUtils.returnNotificationController(this.mContext);
        if (null != this.mIMusicPlayerService) {
            try {
                this.mIMusicPlayerService.savePlayingStatus();
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        try {
            if (this.musicAlbumObject.isOnline()) {
                PlayerUtils.stopService(this.mContext);
            } else if (this.mIMusicPlayerService.isPlaying()) {
                PlayerUtils.showNotification(this.mContext);
            } else {
                PlayerUtils.dismissNotification(this.mContext);
                PlayerUtils.stopService(this.mContext);
            }
        }
        catch (RemoteException e1) {
            e1.printStackTrace();
        }
        if (null != this.mIMusicPlayerService) {
            try {
                this.mIMusicPlayerService.unSetPlayerListener(this.mPlayerListener);
                this.mPlayerListener = null;
                this.mSetListenerCount = 0;
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        if (null != this.mServiceConnection) {
            this.mContext.unbindService(this.mServiceConnection);
            this.mServiceConnection = null;
        }
    }

    private void init() {
        this.log("init");
        this.bindPlayerService();
        PlayerUtils.requireNotificationController(this.mContext);
        PlayerUtils.dismissNotification(this.mContext);
        View view = this.onCreateView(LayoutInflater.from((Context)this.mContext));
        this.addView(view);
    }

    private View onCreateView(LayoutInflater inflater) {
        this.log("onCreateView,mView=" + this.mView);
        if (this.isSimpleView) {
            this.mView = inflater.inflate(R.layout.musicplayer_controller_view_simple, null);
        } else {
            this.mView = inflater.inflate(R.layout.musicplayer_controller_view, null);
            this.mView.setBackgroundResource(R.drawable.musicplayer_player_bg);
        }
        this.ensureUi(this.mView);
        return this.mView;
    }

    public void onNewIntent(Context context, Bundle bundle) {
        if (null == bundle) {
            return;
        }
        String action = bundle.getString("action");
        String uri = bundle.getString("uri");
        if (!TextUtils.isEmpty((CharSequence)action) && action.equalsIgnoreCase("android.intent.action.VIEW")) {
            PlayerUtils.jumpToItem(context, uri);
        }
    }

    private void ensureUi(View view) {
        this.mPlayPauseLinLayout = view.findViewById(R.id.playorpause);
        this.mMp3upLinLayout = (LinearLayout)view.findViewById(R.id.mp3up);
        this.mMp3downLinLayout = view.findViewById(R.id.mp3down);
        this.mPlayorpauseIv = (ImageView)view.findViewById(R.id.playorpauseIv);
        this.mPlayingTimeTv = (TextView)view.findViewById(R.id.playingtime);
        this.mPlayzongTimeTv = (TextView)view.findViewById(R.id.playzongtime);
        this.mSeekBar = (SeekBar)view.findViewById(R.id.seekb);
        this.mProBarlarge = (ProgressBar)view.findViewById(R.id.ProgressBar04);
        this.mPlayPauseLinLayout.setOnClickListener((View.OnClickListener)this);
        this.mMp3upLinLayout.setOnClickListener((View.OnClickListener)this);
        this.mMp3downLinLayout.setOnClickListener((View.OnClickListener)this);
        this.mSeekBar.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                MusicPlayerMainView.this.mIsInSeekMode = true;
                int position = MusicPlayerMainView.this.mSeekBar.getProgress();
                MusicPlayerMainView.this.updatePlayingProgressTime(position);
                return false;
            }
        });
        this.mSeekBar.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener(){

            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
            }

            public void onStartTrackingTouch(SeekBar seekBar) {
                MusicPlayerMainView.this.mIsInSeekMode = true;
                int position = seekBar.getProgress();
                MusicPlayerMainView.this.updatePlayingProgressTime(position);
            }

            public void onStopTrackingTouch(SeekBar seekBar) {
                MusicPlayerMainView.this.mIsInSeekMode = false;
                int position = seekBar.getProgress();
                MusicPlayerMainView.this.log("onStopTrackingTouch,position=" + position);
                if (null != MusicPlayerMainView.this.mIMusicPlayerService) {
                    try {
                        MusicPlayerMainView.this.mIMusicPlayerService.seekTo(position);
                    }
                    catch (RemoteException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    private void showWaitingDialog() {
        this.mProBarlarge.setVisibility(0);
        this.mPlayorpauseIv.setVisibility(4);
    }

    private void dismissWaitingDialog() {
        this.mProBarlarge.setVisibility(8);
        this.mPlayorpauseIv.setVisibility(0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.mp3down) {
            this.onAutoPlayingStatusInterrupted();
            if (null == this.mIMusicPlayerService) return;
            try {
                if (this.mIMusicPlayerService.canForward()) {
                    boolean success = this.mIMusicPlayerService.playNextItem();
                    if (success) return;
                }
                this.showToast(this.mContext.getString(R.string.reach_last_item));
                return;
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
            return;
        }
        if (id2 == R.id.mp3up) {
            this.onAutoPlayingStatusInterrupted();
            if (null == this.mIMusicPlayerService) return;
            try {
                if (this.mIMusicPlayerService.canGoBack()) {
                    boolean success = this.mIMusicPlayerService.playPrevItem();
                    if (success) return;
                }
                this.showToast(this.mContext.getString(R.string.reach_first_item));
                return;
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
            return;
        }
        if (id2 != R.id.playorpause) return;
        this.onAutoPlayingStatusInterrupted();
        if (null == this.mIMusicPlayerService) return;
        try {
            int status = this.mIMusicPlayerService.getPlayerPlayingStatus();
            if (this.mIMusicPlayerService.isMediaPlayerStatusInvalid() || 43 == status) {
                MusicPlayerItem item = this.getCurrentPlayingItem();
                boolean isHandled = this.prePlayHandle(item);
                if (isHandled) {
                    return;
                }
                boolean success = this.mIMusicPlayerService.start();
                if (success) {
                    this.updatePlayingStatus(40);
                    return;
                } else if (null != item && !item.isNeedOrder()) return;
                return;
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return;
        }
        try {
            boolean isPrepared = this.mIMusicPlayerService.isPlayerPrepared();
            if (!isPrepared) {
                this.showToast(this.mContext.getString(R.string.it_is_preparing_now_please_wait));
                return;
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        try {
            if (this.mIMusicPlayerService.isPlaying()) {
                boolean success = this.mIMusicPlayerService.pause();
                if (!success) return;
                this.updatePlayingStatus(41);
                return;
            }
            MusicPlayerItem item = this.getCurrentPlayingItem();
            boolean isHandled = this.prePlayHandle(item);
            if (isHandled) {
                return;
            }
            boolean success = this.mIMusicPlayerService.start();
            if (!success) return;
            this.updatePlayingStatus(40);
            return;
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    private boolean prePlayHandle(MusicPlayerItem item) {
        if (null != item && !item.isNeedOrder() && TextUtils.isEmpty((CharSequence)item.getUrl())) {
            this.showToast(this.mContext.getString(R.string.sync_auth_list_please_wait));
            return true;
        }
        return false;
    }

    private void bindPlayerService() {
        Intent intent = new Intent();
        intent.setAction("me.pjq.musicplayer.MusicPlayerService");
        this.mContext.bindService(intent, this.mServiceConnection, 1);
    }

    private void log(String message) {
        if (null != message) {
            Log.i((String)TAG, (String)message);
        }
    }

    private void onConnected() {
        if (null != this.musicList) {
            PlayerUtils.appendList2(this.getContext(), this.musicList);
            PlayerUtils.updateMusicListObject(this.getContext(), this.musicAlbumObject);
        }
    }

    private void setPlayerListener() {
        if (null == this.mPlayerListener) {
            return;
        }
        try {
            ++this.mSetListenerCount;
            this.log("setPlayerListener,listener=" + this.mPlayerListener.getListenerTag());
            boolean success = this.mIMusicPlayerService.setPlayerListener(this.mPlayerListener);
            if (!success && this.mSetListenerCount <= 3) {
                this.mLocalHandler.sendEmptyMessageDelayed(20, (long)(1000 * this.mSetListenerCount));
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    private MusicPlayerItem getCurrentPlayingItem() {
        if (null != this.mIMusicPlayerService) {
            try {
                return this.mIMusicPlayerService.getCurrentPlayingItem();
            }
            catch (RemoteException e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    private int getCurrentPlayingIndex() {
        if (null != this.mIMusicPlayerService) {
            try {
                return this.mIMusicPlayerService.getCurrentPlayingIndex();
            }
            catch (RemoteException e) {
                e.printStackTrace();
                return 0;
            }
        }
        return 0;
    }

    private List<MusicPlayerItem> getPlayerList() {
        if (null != this.mIMusicPlayerService) {
            try {
                return this.mIMusicPlayerService.getPlayerList();
            }
            catch (RemoteException e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    private int getPlayerListCount() {
        List<MusicPlayerItem> musicPlayerItems = this.getPlayerList();
        if (null != musicPlayerItems) {
            return musicPlayerItems.size();
        }
        return 0;
    }

    protected void onVisibilityChanged(View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        switch (visibility) {
            case 0: {
                PlayerUtils.dismissNotification(this.mContext);
                this.log("onVisibilityChanged,VISIBLE");
                this.mAreadyInitVisible = true;
                break;
            }
            case 4: {
                this.log("onVisibilityChanged,INVISIBLE");
                if (!this.mAreadyInitVisible) break;
                PlayerUtils.showNotification(this.mContext);
                break;
            }
            default: {
                this.log("onVisibilityChanged,DEFAULT");
            }
        }
    }

    private void updateTotalTime(MusicPlayerItem item) {
        int playzongtime1 = -1;
        playzongtime1 = null != item ? item.getTime() : this.getCurrentPlayingTotalTime();
        String timeString = PlayerUtils.getTimeReadable(playzongtime1);
        this.mPlayzongTimeTv.setText((CharSequence)timeString);
        this.mSeekBar.setMax(playzongtime1);
        this.log("updateTotalTime,total=" + playzongtime1);
    }

    private void updatePlayingChapterName(MusicPlayerItem item, int itemIndex) {
        int playerListCount = this.getPlayerListCount();
        if (null != item) {
            this.log("updatePlayingChapterName,item=" + item);
            ToastUtil.showToast(this.getContext(), item.getName());
            this.updateTotalTime(item);
        }
    }

    private void updatePlayingProgress(int current) {
        int totalTime = this.getCurrentPlayingTotalTime();
        String timeString = PlayerUtils.getTimeReadable(current);
        if (totalTime > 0) {
            this.mSeekBar.setProgress(current);
        }
        if (!this.mIsInSeekMode) {
            this.mPlayingTimeTv.setText((CharSequence)timeString);
        }
    }

    private void updatePlayingProgressTime(int current) {
        this.log("updatePlayingProgressTime,current=" + current);
        String timeString = PlayerUtils.getTimeReadable(current);
        this.mPlayingTimeTv.setText((CharSequence)timeString);
    }

    public void updateBufferProgress(int bufferPercent) {
        this.log("updateBufferProgress,bufferPercent=" + bufferPercent + ",Indeterminate=");
        int bufferPosition = bufferPercent * this.getCurrentPlayingTotalTime() / 100;
        this.mSeekBar.setSecondaryProgress(bufferPosition);
    }

    private int getCurrentPlayingTotalTime() {
        if (null != this.mIMusicPlayerService) {
            try {
                return this.mIMusicPlayerService.getCurrentPlayingTotalTime();
            }
            catch (RemoteException e) {
                e.printStackTrace();
                return -1;
            }
        }
        return -1;
    }

    public void updatePlayingStatus(int status) {
        switch (status) {
            case 40: {
                this.mPlayorpauseIv.setImageResource(R.drawable.musicplayer_pause);
                this.initAnimation(true);
                break;
            }
            case 41: {
                this.mPlayorpauseIv.setImageResource(R.drawable.musicplayer_play);
                this.initAnimation(false);
                break;
            }
            case 43: {
                this.mSeekBar.setProgress(0);
                this.mPlayingTimeTv.setText((CharSequence)"00:00");
                this.mPlayorpauseIv.setImageResource(R.drawable.musicplayer_play);
                this.initAnimation(false);
                break;
            }
        }
    }

    private void updateOrderView(boolean isNeedOrder) {
    }

    private void showToast(String message) {
        ToastUtil.showToast(this.mContext, message);
    }

    private void onAutoPlayingStatusInterrupted() {
    }

    public void setMusicList(MusicAlbumObject musicAlbumObject) {
        this.musicAlbumObject = musicAlbumObject;
    }

    public void setMusicList(ArrayList<MusicPlayerItem> musicList) {
        this.musicList = musicList;
    }
}

