/*
 * Decompiled with CFR 0.152.
 */
package me.pjq.musicplayer;

import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.Process;
import android.os.RemoteException;
import android.os.Vibrator;
import android.telephony.PhoneStateListener;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Log;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import me.pjq.musicplayer.AudioFocusHelper;
import me.pjq.musicplayer.IMusicPlayerListener;
import me.pjq.musicplayer.IMusicPlayerService;
import me.pjq.musicplayer.MusicAlbumObject;
import me.pjq.musicplayer.MusicPlayerConfig;
import me.pjq.musicplayer.MusicPlayerItem;
import me.pjq.musicplayer.MusicPlayerListeners;
import me.pjq.musicplayer.R;
import me.pjq.musicplayer.ShakeEventManager;
import me.pjq.musicplayer.StepCountEventManager;
import me.pjq.musicplayer.utils.NotificationUtil;
import me.pjq.musicplayer.utils.PlayerUtils;
import me.pjq.musicplayer.utils.StatUtil;
import me.pjq.musicplayer.utils.Utils;

public class MusicPlayerService
extends Service
implements MediaPlayer.OnBufferingUpdateListener,
MediaPlayer.OnErrorListener,
MediaPlayer.OnPreparedListener,
MediaPlayer.OnCompletionListener,
MediaPlayer.OnInfoListener,
MediaPlayer.OnSeekCompleteListener,
MediaPlayer.OnVideoSizeChangedListener {
    private static String TAG = MusicPlayerService.class.getSimpleName();
    private static final boolean DEBUG_LOG = true;
    private MediaPlayer mCloudaryMediaPlayer;
    private Context mContext;
    private Vibrator vibrator;
    private ShakeEventManager shakeEventManager;
    private StepCountEventManager stepCountEventManager;
    private int stepInitCount = -1;
    private int stepCount = -1;
    private int stepPrevCount = -1;
    private HashMap<Long, Float> freqMap = new HashMap();
    private int mMediaPlayerPreparingStatus = 47;
    private int mMediaPlayerPlayingStatus = 36;
    private Vector<MusicPlayerItem> mPlayList;
    private MusicPlayerItem mCurrentPlayingItem;
    private int mCurrentPlayingIndex = 0;
    private BroadcastReceiver mAudioBecomingNoisyReceiver;
    private BroadcastReceiver mNetWorkChangeReceiver;
    private int mNotificationControllerReferenceCount = 0;
    private MusicPlayerListeners mPlayerListener;
    private MusicPlayerConfig mMusicPlayerConfig;
    private int mAutoPlayChapterCount = 0;
    private int mAutoPlayTime = 0;
    private MusicAlbumObject musicAlbumObject;
    private int mStartPlayerSourceFrom = 0;
    private int mCommand;
    private boolean mInSeekMode = false;
    private int mSeekPosition = 0;
    private int mBeforeSeekPostion = 0;
    private long mSeekTimestamp = 0L;
    private int mPreviewPlayingProgress = 0;
    private Handler mUpdatePlayingProgressHandler = new Handler(){

        public void dispatchMessage(Message msg) {
            int what = msg.what;
            if (28 == what) {
                MusicPlayerService.this.keepAutoPlayStaus(MusicPlayerService.this.mAutoPlayChapterCount, MusicPlayerService.this.mAutoPlayTime + 1);
                int autoStopTime = MusicPlayerService.this.getPlayerConfig().getAutoStopTime();
                if (autoStopTime > 0 && MusicPlayerService.this.mAutoPlayTime >= autoStopTime) {
                    MusicPlayerService.this.pausePlayer();
                    MusicPlayerService.this.log("mAutoPlayTime=" + MusicPlayerService.this.mAutoPlayTime + ",goto sleep mode,pausePlayer");
                    MusicPlayerService.this.keepAutoPlayStaus(0, 0);
                    return;
                }
                if (null != MusicPlayerService.this.mPlayerListener && null != MusicPlayerService.this.mCloudaryMediaPlayer) {
                    int position = MusicPlayerService.this.getCurrentPositionImpl();
                    MusicPlayerService.this.keepCurrentPosition(position);
                    if (position >= 1 && !MusicPlayerService.this.mInSeekMode && this.checkNeedUpdatePlayingProgress(position)) {
                        MusicPlayerService.this.mPlayerListener.onUpdatePlayingProgress(MusicPlayerService.this.getCurrentPlayingItemImpl(), MusicPlayerService.this.mCurrentPlayingIndex, position);
                    }
                    if (position >= MusicPlayerService.this.mCurrentPlayingItem.getTime()) {
                        MusicPlayerService.this.stopPlayer();
                        MusicPlayerService.this.onCompletion(MusicPlayerService.this.mCloudaryMediaPlayer);
                    }
                    MusicPlayerService.this.mPreviewPlayingProgress = position;
                }
            } else if (29 == what) {
                float freq = MusicPlayerService.this.stepCount - MusicPlayerService.this.stepPrevCount;
                MusicPlayerService.this.freqMap.put(System.currentTimeMillis(), Float.valueOf(freq /= 0.083333336f));
                Iterator iterator = MusicPlayerService.this.freqMap.entrySet().iterator();
                float sum = 0.0f;
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    float f = ((Float)entry.getValue()).floatValue();
                    sum += f;
                }
                float avgFreq = sum / (float)MusicPlayerService.this.freqMap.size();
                MusicPlayerService.this.mPlayerListener.onUpdateStepFreq(freq, avgFreq);
                MusicPlayerService.this.stepPrevCount = MusicPlayerService.this.stepCount;
            }
        }

        private boolean checkNeedUpdatePlayingProgress(int currentPosition) {
            long current = System.currentTimeMillis();
            long duration = current - MusicPlayerService.this.mSeekTimestamp;
            MusicPlayerService.this.log("duration=" + duration);
            if (duration > 0L && duration < 3000L) {
                int skipDuration = Math.abs(currentPosition - MusicPlayerService.this.mSeekPosition);
                MusicPlayerService.this.log("skipDuration=" + skipDuration);
                if (skipDuration > 5) {
                    return false;
                }
            }
            MusicPlayerService.this.log("mPreviewPlayingProgress=" + MusicPlayerService.this.mPreviewPlayingProgress + ",position=" + currentPosition);
            return MusicPlayerService.this.mPreviewPlayingProgress == 0 || MusicPlayerService.this.mPreviewPlayingProgress != currentPosition;
        }
    };
    private boolean mPlayingProgressUpdateThreadFlag = true;
    private Thread mUpdatePlayingProgressThread = new Thread(new Runnable(){

        @Override
        public void run() {
            while (MusicPlayerService.this.mPlayingProgressUpdateThreadFlag) {
                if (null != MusicPlayerService.this.mCloudaryMediaPlayer && MusicPlayerService.this.isPlayerPreparedImpl() && MusicPlayerService.this.isPlaying()) {
                    MusicPlayerService.this.mUpdatePlayingProgressHandler.sendEmptyMessage(28);
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    });
    private boolean mStepFrequencyUpdateThreadFlag = true;
    private Thread mStepFrequencyUpdateThread = new Thread(new Runnable(){

        @Override
        public void run() {
            while (MusicPlayerService.this.mStepFrequencyUpdateThreadFlag) {
                MusicPlayerService.this.mUpdatePlayingProgressHandler.sendEmptyMessage(29);
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    });
    IMusicPlayerService.Stub mServiceBinder = new IMusicPlayerService.Stub(){

        @Override
        public boolean setPlayerListener(IMusicPlayerListener listener) {
            return MusicPlayerService.this.mPlayerListener.setPlayerListener(listener);
        }

        @Override
        public boolean unSetPlayerListener(IMusicPlayerListener listener) {
            return MusicPlayerService.this.mPlayerListener.unSetPlayerListener(listener);
        }

        @Override
        public boolean playNextItem() {
            return MusicPlayerService.this.playNext();
        }

        @Override
        public boolean playPrevItem() {
            return MusicPlayerService.this.playPrev();
        }

        public Vector<MusicPlayerItem> getPlayerList() {
            return MusicPlayerService.this.mPlayList;
        }

        @Override
        public MusicPlayerItem getCurrentPlayingItem() {
            return MusicPlayerService.this.getCurrentPlayingItemImpl();
        }

        @Override
        public int getCurrentPlayingIndex() {
            return MusicPlayerService.this.mCurrentPlayingIndex;
        }

        @Override
        public int getCurrentPlayingTotalTime() {
            int total = MusicPlayerService.this.getCurrentPlayingTotalTimeImpl();
            return total;
        }

        @Override
        public boolean isPlayerPrepared() {
            return MusicPlayerService.this.isPlayerPreparedImpl();
        }

        @Override
        public int getPlayerPlayingStatus() {
            return MusicPlayerService.this.mMediaPlayerPlayingStatus;
        }

        @Override
        public boolean start() {
            MusicPlayerService.this.log("mServiceBinder,start()");
            return MusicPlayerService.this.startPlayer();
        }

        @Override
        public boolean pause() {
            MusicPlayerService.this.log("mServiceBinder,pausePlayer()");
            return MusicPlayerService.this.pausePlayer();
        }

        @Override
        public boolean stop() {
            return MusicPlayerService.this.stopPlayer();
        }

        @Override
        public boolean isPlaying() {
            if (null != MusicPlayerService.this.mCloudaryMediaPlayer) {
                return 40 == MusicPlayerService.this.mMediaPlayerPlayingStatus;
            }
            return false;
        }

        @Override
        public boolean canForward() {
            return MusicPlayerService.this.canForwardImpl();
        }

        @Override
        public boolean canGoBack() {
            return MusicPlayerService.this.canGoBackImpl();
        }

        @Override
        public boolean isMediaPlayerStatusInvalid() throws RemoteException {
            return 36 == MusicPlayerService.this.mMediaPlayerPlayingStatus || null == MusicPlayerService.this.mCloudaryMediaPlayer;
        }

        @Override
        public void clearPlayList() throws RemoteException {
            MusicPlayerService.this.clearPlayListImpl();
        }

        @Override
        public void seekTo(int position) throws RemoteException {
            MusicPlayerService.this.seekToImpl(position);
        }

        @Override
        public int getPlayerListCount() throws RemoteException {
            return MusicPlayerService.this.mPlayList.size();
        }

        @Override
        public void savePlayingStatus() throws RemoteException {
            MusicPlayerService.this.savePlayingStatus();
        }
    };
    private PhoneStateListener mPhoneStateListener = new PhoneStateListener(){
        private boolean mConsumed = true;

        private void log(String tag, String msg) {
            Utils.i(tag, msg);
        }

        public void onCallStateChanged(int state, String incomingNumber) {
            this.log(TAG, "onCallStateChanged,state=" + state + ",incomingNumber=" + incomingNumber);
            switch (state) {
                case 0: {
                    this.log(TAG, "CALL_STATE_IDLE");
                    if (this.mConsumed) break;
                    MusicPlayerService.this.startPlayer();
                    this.mConsumed = true;
                    break;
                }
                case 1: {
                    this.log(TAG, "CALL_STATE_RINGING");
                    if (!MusicPlayerService.this.isPlaying()) break;
                    this.mConsumed = false;
                    MusicPlayerService.this.pausePlayer();
                    break;
                }
            }
            super.onCallStateChanged(state, incomingNumber);
        }
    };
    OnAudioFocusChangeListener mOnAudioFocusChangeListener = new OnAudioFocusChangeListener(){

        @Override
        public void onAudioFocusChange(int focusChange) {
            switch (focusChange) {
                case 1: {
                    MusicPlayerService.this.log("AUDIOFOCUS_GAIN,startPlayer()");
                    MusicPlayerService.this.startPlayer();
                    if (null == MusicPlayerService.this.mCloudaryMediaPlayer) break;
                    MusicPlayerService.this.mCloudaryMediaPlayer.setVolume(1.0f, 1.0f);
                    break;
                }
                case -1: {
                    MusicPlayerService.this.log("AUDIOFOCUS_LOSS,pausePlayer()");
                    MusicPlayerService.this.pausePlayer();
                    break;
                }
                case -2: {
                    MusicPlayerService.this.log("AUDIOFOCUS_LOSS_TRANSIENT,pausePlayer()");
                    MusicPlayerService.this.pausePlayer();
                    break;
                }
                case -3: {
                    MusicPlayerService.this.log("AUDIOFOCUS_LOSS_TRANSIENT_CAN_DUCK");
                    if (null != MusicPlayerService.this.mCloudaryMediaPlayer && !MusicPlayerService.this.isPlaying()) break;
                }
            }
        }
    };
    AudioFocusHelper mAudioFocusHelper;
    private static boolean isPlayerListComplete = false;

    private void log(String message) {
        if (null != message) {
            Log.i((String)TAG, (String)message);
        }
    }

    public void onCreate() {
        super.onCreate();
        this.log("onCreate");
        this.mContext = this.getApplicationContext();
        this.mPlayList = new Vector();
        this.mPlayerListener = new MusicPlayerListeners();
        this.mAudioBecomingNoisyReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                MusicPlayerService.this.log("AUDIO_BECOMING_NOISY,pausePlayer()");
                MusicPlayerService.this.pausePlayer();
            }
        };
        IntentFilter intentFilter = new IntentFilter("android.media.AUDIO_BECOMING_NOISY");
        this.registerReceiver(this.mAudioBecomingNoisyReceiver, intentFilter);
        this.mNetWorkChangeReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                if (MusicPlayerService.this.isNeedStopPlayerWhenNotWifi()) {
                    MusicPlayerService.this.log("isNeedStopPlayerWhenNotWifi,stopPlayer");
                    MusicPlayerService.this.stopPlayer();
                }
            }
        };
        this.registerReceiver(this.mNetWorkChangeReceiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
        TelephonyManager tm = (TelephonyManager)this.getSystemService("phone");
        tm.listen(this.mPhoneStateListener, 32);
        this.mUpdatePlayingProgressThread.start();
        this.vibrator = (Vibrator)this.getSystemService("vibrator");
        this.shakeEventManager = new ShakeEventManager();
        this.shakeEventManager.setListener(new ShakeEventManager.ShakeListener(){

            @Override
            public void onShake() {
                boolean isShakeToNext = MusicPlayerService.this.getPlayerConfig().isShakeToNext();
                if (isShakeToNext) {
                    MusicPlayerService.this.playNext();
                }
            }

            @Override
            public void onFlipBack() {
                boolean isQuickStopEnable = MusicPlayerService.this.getPlayerConfig().isQuickStop();
                if (isQuickStopEnable) {
                    MusicPlayerService.this.log("back the phone,pausePlayer()");
                    MusicPlayerService.this.pausePlayer();
                }
            }
        });
        this.shakeEventManager.init((Context)this);
        this.stepCountEventManager = new StepCountEventManager();
        this.stepCountEventManager.setListener(new StepCountEventManager.StepCountListener(){

            @Override
            public void onStepCount(int count) {
                int totalCount;
                MusicPlayerService.this.stepCount = count;
                if (-1 == MusicPlayerService.this.stepPrevCount) {
                    MusicPlayerService.this.stepPrevCount = count;
                }
                if (-1 == MusicPlayerService.this.stepInitCount) {
                    MusicPlayerService.this.stepInitCount = count;
                }
                if ((totalCount = count - MusicPlayerService.this.stepInitCount) > 0) {
                    MusicPlayerService.this.mPlayerListener.onUpdateStepCount(totalCount);
                }
            }

            @Override
            public void onNotSupportStepSensor() {
            }
        });
        this.stepCountEventManager.init((Context)this);
        this.mStepFrequencyUpdateThread.start();
    }

    private void requestAudioFocus() {
        if (Build.VERSION.SDK_INT < 8) {
            this.mAudioFocusHelper = null;
        } else {
            if (null == this.mAudioFocusHelper) {
                this.mAudioFocusHelper = new AudioFocusHelper(this.getApplicationContext(), this.mOnAudioFocusChangeListener);
            }
            this.mAudioFocusHelper.requestFocus();
        }
    }

    private void removeAudioFocus() {
        if (Build.VERSION.SDK_INT >= 8 && null != this.mAudioFocusHelper) {
            this.mAudioFocusHelper.abandonFocus();
        }
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        int command;
        this.log("onStartCommand,intent=" + intent + ",flags=" + flags + ",startId=" + startId);
        this.mCommand = command = this.getPlayerCommand(intent);
        if (-1 != command) {
            switch (command) {
                case 3: {
                    this.log("onStartCommand,pausePlayer()");
                    PlayerUtils.printTime("COMMAND_PLAYER_PAUSE");
                    this.pausePlayer();
                    break;
                }
                case 1: {
                    PlayerUtils.printTime("COMMAND_PLAYER_START");
                    Bundle bundle = intent.getExtras();
                    if (null != bundle) {
                        MusicPlayerItem item = (MusicPlayerItem)bundle.getParcelable("player_item");
                        if (null != item) {
                            this.insertItemToPlayList(item);
                            this.playItem(item);
                            break;
                        }
                        this.startPlayer();
                        break;
                    }
                    this.startPlayer();
                    break;
                }
                case 2: {
                    PlayerUtils.printTime("COMMAND_PLAYER_STOP");
                    this.stopPlayer();
                    break;
                }
                case 4: {
                    PlayerUtils.printTime("COMMAND_PLAYER_SEEK");
                    Bundle bundle = intent.getExtras();
                    if (null == bundle) break;
                    int position = bundle.getInt("position");
                    this.seekToImpl(position);
                    break;
                }
                case 14: {
                    PlayerUtils.printTime("COMMAND_DESTROY_SERVICE");
                    this.log("COMMAND_DESTROY_SERVICE");
                    this.stopPlayer();
                    this.stopSelf();
                    break;
                }
                case 24: {
                    PlayerUtils.printTime("COMMAND_STOP_SERVICE_WITHOUT_SAVE");
                    this.log("COMMAND_STOP_SERVICE_WITHOUT_SAVE");
                    this.stopPlayer();
                    this.stopSelf();
                    break;
                }
                case 5: {
                    PlayerUtils.printTime("COMMAND_PLAYER_NEXT");
                    this.playNext();
                    break;
                }
                case 6: {
                    PlayerUtils.printTime("COMMAND_PLAYER_PREV");
                    this.playPrev();
                    break;
                }
                case 7: {
                    PlayerUtils.printTime("COMMAND_APPEND_ITEM");
                    Bundle bundle = intent.getExtras();
                    if (null == bundle) break;
                    MusicPlayerItem item = (MusicPlayerItem)bundle.getParcelable("player_item");
                    this.appendItemToPlayList(item);
                    break;
                }
                case 8: {
                    PlayerUtils.printTime("COMMAND_APPEND_LIST");
                    Bundle bundle = intent.getExtras();
                    if (null == bundle) break;
                    ArrayList list = bundle.getParcelableArrayList("list");
                    this.appendListToPlayList(list);
                    break;
                }
                case 10: {
                    Bundle bundle = intent.getExtras();
                    if (null != bundle) {
                        this.musicAlbumObject = (MusicAlbumObject)bundle.getSerializable("book");
                    }
                    PlayerUtils.printTime("COMMAND_UPDATE_BOOK,mBook=" + this.musicAlbumObject);
                    break;
                }
                case 11: {
                    PlayerUtils.printTime("COMMAND_UPDATE_AUTHED_LIST");
                    Bundle bundle = intent.getExtras();
                    if (null == bundle) break;
                    ArrayList list = bundle.getParcelableArrayList("list");
                    this.updateAuthedListToPlayList(list);
                    break;
                }
                case 12: {
                    PlayerUtils.printTime("COMMAND_UPDATE_AUTHED_LIST_AND_START_PLAYER");
                    Bundle bundle = intent.getExtras();
                    if (null == bundle) break;
                    ArrayList list = bundle.getParcelableArrayList("list");
                    this.updateAuthedListToPlayList(list);
                    this.startPlayer();
                    break;
                }
                case 13: {
                    PlayerUtils.printTime("COMMAND_DELETE_ITEM");
                    Bundle bundle = intent.getExtras();
                    if (null == bundle) break;
                    MusicPlayerItem item = (MusicPlayerItem)bundle.getParcelable("player_item");
                    this.deleteItemFromPlayList(item);
                    break;
                }
                case 15: {
                    ++this.mNotificationControllerReferenceCount;
                    this.showNotification(false);
                    break;
                }
                case 16: {
                    --this.mNotificationControllerReferenceCount;
                    break;
                }
                case 17: {
                    this.showNotification(true);
                    break;
                }
                case 18: {
                    this.dismissNotification();
                    break;
                }
                case 19: {
                    PlayerUtils.printTime("COMMAND_CLEAR_PLAYLIST");
                    this.clearPlayListImpl();
                    break;
                }
                case 20: {
                    PlayerUtils.printTime("COMMAND_JUMP_TO_ITEM");
                    Bundle bundle = intent.getExtras();
                    if (null == bundle) break;
                    MusicPlayerItem item = (MusicPlayerItem)bundle.getParcelable("player_item");
                    this.jumpToItem(item);
                    break;
                }
                case 21: {
                    PlayerUtils.printTime("COMMAND_UPDATE_TO_ITEM");
                    Bundle bundle = intent.getExtras();
                    if (null == bundle) break;
                    MusicPlayerItem item = (MusicPlayerItem)bundle.getParcelable("player_item");
                    this.updateToItem(item);
                    break;
                }
                case 22: {
                    PlayerUtils.printTime("COMMAND_JUMP_TO_INDEX");
                    Bundle bundle = intent.getExtras();
                    if (null == bundle) break;
                    int index = bundle.getInt("index");
                    MusicPlayerItem item = this.getPlayerItem(index);
                    this.jumpToItem(item);
                    break;
                }
                case 23: {
                    PlayerUtils.printTime("COMMAND_UPDATE_POSITION_TO_ITEM");
                    Bundle bundle = intent.getExtras();
                    if (null == bundle) break;
                    MusicPlayerItem item = (MusicPlayerItem)bundle.getParcelable("player_item");
                    this.updateItemPositionToPlayerList(item);
                    break;
                }
                case 25: {
                    this.log("COMMAND_AUTO_PLAYING_STATUS_INTERRUPTED");
                    isPlayerListComplete = false;
                    break;
                }
                case 26: {
                    this.log("COMMAND_RESET_STEP_COUNT");
                    this.resetStepCount();
                    this.mUpdatePlayingProgressHandler.sendEmptyMessage(29);
                    break;
                }
                case 27: {
                    Bundle bundle = intent.getExtras();
                    if (null != bundle) {
                        this.mStartPlayerSourceFrom = bundle.getInt("start_source_from");
                    }
                    PlayerUtils.printTime("COMMAND_UPDATE_START_PLAYER_SOURCE,mStartPlayerSourceFrom=" + this.mStartPlayerSourceFrom);
                    break;
                }
            }
        }
        return super.onStartCommand(intent, flags, startId);
    }

    private int getPlayerCommand(Intent intent) {
        if (null == intent) {
            return -1;
        }
        Bundle extra = intent.getExtras();
        if (null == extra) {
            return -1;
        }
        return extra.getInt("player_command");
    }

    private void resetStepCount() {
        this.freqMap.clear();
        this.stepCount = -1;
        this.stepInitCount = -1;
        this.stepPrevCount = -1;
    }

    public void onDestroy() {
        super.onDestroy();
        this.log("onDestroy");
        if (24 == this.mCommand) {
            this.log("onDestroy,COMMAND_STOP_SERVICE_WITHOUT_SAVE");
        } else if (this.isPlayerPreparedImpl()) {
            this.keepCurrentPosition(null);
            this.savePlayingStatus();
        }
        this.removeAudioFocus();
        NotificationUtil.dismissNotification(this.mContext);
        this.keepCurrentPosition(null);
        this.setCurrentPlayerItem(null);
        this.releaseMediaPlayer();
        this.mPlayList.clear();
        this.mPlayList = null;
        this.mPlayerListener.clear();
        this.mPlayerListener = null;
        this.musicAlbumObject = null;
        this.mPlayingProgressUpdateThreadFlag = false;
        this.mStepFrequencyUpdateThreadFlag = false;
        if (null != this.mAudioBecomingNoisyReceiver) {
            this.unregisterReceiver(this.mAudioBecomingNoisyReceiver);
            this.mAudioBecomingNoisyReceiver = null;
        }
        if (null != this.mNetWorkChangeReceiver) {
            this.unregisterReceiver(this.mNetWorkChangeReceiver);
            this.mNetWorkChangeReceiver = null;
        }
        this.shakeEventManager.deregister();
        this.stepCountEventManager.deregister();
        this.removeAudioFocus();
        this.resetStepCount();
        TelephonyManager tm = (TelephonyManager)this.getSystemService("phone");
        tm.listen(this.mPhoneStateListener, 0);
        Process.killProcess((int)Process.myPid());
    }

    public void onRebind(Intent intent) {
        super.onRebind(intent);
        this.log("onRebind");
    }

    public boolean onUnbind(Intent intent) {
        this.log("onUnbind,intent=" + intent);
        return super.onUnbind(intent);
    }

    private boolean isNotificationControlledByService() {
        this.log("isNotificationControlledByService,mNotificationControllerReferenceCount=" + this.mNotificationControllerReferenceCount);
        return 0 == this.mNotificationControllerReferenceCount;
    }

    private void showNotification() {
        this.showNotification(false);
    }

    private void showNotification(boolean force) {
        this.log("showNotification,force=" + force + ",mNotificationControllerReferenceCount=" + this.mNotificationControllerReferenceCount);
        if (!force && !this.isNotificationControlledByService()) {
            NotificationUtil.dismissNotification(this.mContext);
            return;
        }
        String prefixMessage = "";
        switch (this.mMediaPlayerPlayingStatus) {
            case 43: {
                prefixMessage = this.getString(R.string.it_is_stop_now) + " " + this.getString(R.string.click_to_see_detail);
                break;
            }
            case 41: {
                prefixMessage = this.getString(R.string.it_is_pause_now) + " " + this.getString(R.string.click_to_see_detail);
                break;
            }
            case 40: {
                prefixMessage = this.getString(R.string.it_is_playing_now);
                break;
            }
            case 38: {
                prefixMessage = this.getString(R.string.it_is_preparing_now);
                break;
            }
            default: {
                prefixMessage = this.getString(R.string.it_is_invalid_now) + " " + this.getString(R.string.click_to_see_detail);
            }
        }
        if (null != this.mCurrentPlayingItem) {
            String message = prefixMessage + " " + this.mCurrentPlayingItem.getName();
            if (null == this.musicAlbumObject) {
                // empty if block
            }
            NotificationUtil.showNotification(this.getApplicationContext(), message, this.musicAlbumObject);
        }
    }

    private void dismissNotification() {
        if (this.isNotificationControlledByService()) {
            return;
        }
        NotificationUtil.dismissNotification(this.getApplicationContext());
    }

    public IBinder onBind(Intent intent) {
        this.log("onBind,intent=" + intent);
        return this.mServiceBinder;
    }

    private MediaPlayer createMediaPlayer() {
        this.log("createMediaPlayer");
        MediaPlayer player = null;
        if (null != this.mCloudaryMediaPlayer) {
            player = this.mCloudaryMediaPlayer;
            this.releaseMediaPlayer();
            player = new MediaPlayer();
            player = this.setMediaPlayerListener(player);
            player.setScreenOnWhilePlaying(false);
        } else {
            player = new MediaPlayer();
            player = this.setMediaPlayerListener(player);
            player.setScreenOnWhilePlaying(false);
        }
        this.setPlayerPlayingStatus(37);
        return player;
    }

    private MediaPlayer createMediaPlayerAsync(String url) {
        this.log("createMediaPlayerAsync");
        MediaPlayer player = this.createMediaPlayer();
        try {
            this.mInSeekMode = false;
            player.setDataSource(this.getApplicationContext(), Uri.parse((String)url));
            player.prepareAsync();
            this.setPlayerPlayingStatus(38);
            this.setPrepareStatus(47);
            this.showNotification(false);
            if (null != this.mServiceBinder && null != this.mPlayerListener) {
                this.log("createMediaPlayer,onPrePlaying");
                try {
                    this.mPlayerListener.onPrePlaying(this.getCurrentPlayingItemImpl(), this.mCurrentPlayingIndex);
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
            }
            this.showNotification();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            this.setPlayerPlayingStatus(36);
        }
        catch (SecurityException e) {
            e.printStackTrace();
            this.setPlayerPlayingStatus(36);
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
            this.setPlayerPlayingStatus(36);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.setPlayerPlayingStatus(36);
        }
        this.log("createMediaPlayer,done,player=" + player);
        return player;
    }

    private MediaPlayer setMediaPlayerListener(MediaPlayer player) {
        if (null == player) {
            return player;
        }
        player.setAudioStreamType(3);
        player.setOnBufferingUpdateListener((MediaPlayer.OnBufferingUpdateListener)this);
        player.setOnCompletionListener((MediaPlayer.OnCompletionListener)this);
        player.setOnErrorListener((MediaPlayer.OnErrorListener)this);
        player.setOnInfoListener((MediaPlayer.OnInfoListener)this);
        player.setOnPreparedListener((MediaPlayer.OnPreparedListener)this);
        player.setOnSeekCompleteListener((MediaPlayer.OnSeekCompleteListener)this);
        player.setOnVideoSizeChangedListener((MediaPlayer.OnVideoSizeChangedListener)this);
        return player;
    }

    private void releaseMediaPlayer() {
        this.log("releaseMediaPlayer");
        if (null != this.mCloudaryMediaPlayer) {
            this.mCloudaryMediaPlayer.release();
            this.mCloudaryMediaPlayer = null;
        }
    }

    public void onVideoSizeChanged(MediaPlayer mp, int width, int height) {
        this.log("onVideoSizeChanged,mp=" + mp + ",width=" + width + ",height=" + height);
        if (null != this.mServiceBinder && null != this.mPlayerListener) {
            try {
                this.mPlayerListener.onVideoSizeChanged(width, height);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
    }

    public void onSeekComplete(MediaPlayer mp) {
        this.log("onSeekComplete,mp=" + mp);
        this.mInSeekMode = false;
        if (null != this.mServiceBinder && null != this.mPlayerListener) {
            try {
                this.mPlayerListener.onSeekComplete();
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean onInfo(MediaPlayer mp, int what, int extra) {
        this.log("onInfo,mp=" + mp + ",what=" + what + ",extra=" + extra);
        if (null != this.mServiceBinder && null != this.mPlayerListener) {
            try {
                return this.mPlayerListener.onInfo(what, extra);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public void onCompletion(MediaPlayer mp) {
        this.log("onCompletion,mp=" + mp);
        this.keepAutoPlayStaus(this.mAutoPlayChapterCount + 1, this.mAutoPlayTime);
        this.setPlayerPlayingStatus(42);
        if (null != this.mServiceBinder && null != this.mPlayerListener) {
            try {
                this.mPlayerListener.onCompletion();
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        this.keepCurrentPosition(0);
        this.log("mCurrentPlayingIndex=" + this.mCurrentPlayingIndex + ",list count=" + this.getPlayerListCount());
        if (this.mCurrentPlayingIndex + 1 == this.getPlayerListCount()) {
            isPlayerListComplete = true;
            this.onPlayerListComplete();
        } else {
            isPlayerListComplete = false;
        }
        if (!this.getPlayerConfig().isContinuePlay()) {
            this.log("is not continue play,pausePlayer");
            this.pausePlayer();
        } else if (this.getPlayerConfig().getAutoStopChapterCount() > 0) {
            if (this.mAutoPlayChapterCount >= this.getPlayerConfig().getAutoStopChapterCount()) {
                this.pausePlayer();
                this.keepAutoPlayStaus(0, 0);
                this.log("mAutoPlayChapterCount=" + this.mAutoPlayChapterCount + ",goto sleep mode,pausePlayer");
            } else {
                this.playNext(true);
            }
        } else {
            this.playNext(true);
        }
    }

    private void onPlayerListComplete() {
        if (this.mCurrentPlayingIndex + 1 == this.getPlayerListCount() && null != this.mPlayerListener) {
            this.mPlayerListener.savePlayingStatus(this.mContext, this.getCurrentPlayingItemImpl(), this.musicAlbumObject, 0, 1);
        }
    }

    public void onPrepared(MediaPlayer mp) {
        this.log("onPrepared,mp=" + mp);
        this.setPlayerPlayingStatus(39);
        this.setPrepareStatus(48);
        if (null != this.mServiceBinder && null != this.mPlayerListener) {
            try {
                this.mPlayerListener.onPrepared();
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        if (null != this.mCurrentPlayingItem) {
            this.mCurrentPlayingItem.setTime(this.getCurrentPlayingTotalTimeImpl());
            if (this.mCurrentPlayingItem.isLocalFileType()) {
                this.seekToImpl(this.mCurrentPlayingItem.getPosition());
            } else if (this.mCurrentPlayingItem.isUrlType()) {
                this.seekToImpl(this.mCurrentPlayingItem.getPosition());
            }
        }
        this.startPlayer();
    }

    public boolean onError(MediaPlayer mp, int what, int extra) {
        this.log("onError,mp=" + mp + ",what=" + what + ",extra=" + extra);
        if (null != this.mCurrentPlayingItem) {
            StatUtil.onTingshuPlayError(this.mCurrentPlayingItem, "what=" + what + ",extra=" + extra);
        }
        if (null != this.mServiceBinder && null != this.mPlayerListener) {
            try {
                this.mPlayerListener.onError(what, extra);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        if (what == 1 && extra == -1004) {
            this.stopPlayer();
            this.setPlayerPlayingStatus(36);
        } else if (what == 1 && extra == Integer.MIN_VALUE) {
            this.stopPlayer();
            this.setPlayerPlayingStatus(36);
        }
        return true;
    }

    public void onBufferingUpdate(MediaPlayer mp, int percent) {
        this.log("onBufferingUpdate,mp=" + mp + ",percent=" + percent);
        if (null != this.mServiceBinder && null != this.mPlayerListener) {
            try {
                this.mPlayerListener.onBufferingUpdate(percent);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
    }

    private boolean stopPlayer() {
        this.keepAutoPlayStaus(0, 0);
        this.keepCurrentPosition(null);
        this.savePlayingStatus();
        if (null != this.mCloudaryMediaPlayer) {
            try {
                this.removeAudioFocus();
                this.releaseMediaPlayer();
                this.setPlayerPlayingStatus(43);
                this.showNotification(false);
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
            if (null != this.mServiceBinder && null != this.mPlayerListener) {
                try {
                    this.mPlayerListener.onStop();
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
            }
            return true;
        }
        if (null == this.mCloudaryMediaPlayer) {
            if (null != this.mServiceBinder && null != this.mPlayerListener) {
                try {
                    this.mPlayerListener.onStop();
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
            }
            return true;
        }
        return false;
    }

    private void setPlayerPlayingStatus(int status) {
        this.mMediaPlayerPlayingStatus = status;
    }

    private boolean canPausePlayer() {
        return 40 == this.mMediaPlayerPlayingStatus || 41 == this.mMediaPlayerPlayingStatus;
    }

    private boolean pausePlayer() {
        if (null != this.mCloudaryMediaPlayer && this.canPausePlayer()) {
            this.keepCurrentPosition(null);
            this.savePlayingStatus();
            try {
                this.removeAudioFocus();
                this.mCloudaryMediaPlayer.pause();
                this.setPlayerPlayingStatus(41);
                this.showNotification(false);
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
            if (null != this.mServiceBinder && null != this.mPlayerListener) {
                try {
                    this.mPlayerListener.onPause();
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
            }
            return true;
        }
        return false;
    }

    private boolean canStartPlayer() {
        return 39 == this.mMediaPlayerPlayingStatus || 40 == this.mMediaPlayerPlayingStatus || 41 == this.mMediaPlayerPlayingStatus || 42 == this.mMediaPlayerPlayingStatus;
    }

    private synchronized boolean startPlayer() {
        if (null != this.mCloudaryMediaPlayer && this.canStartPlayer()) {
            try {
                this.requestAudioFocus();
                this.mCloudaryMediaPlayer.start();
                this.setPlayerPlayingStatus(40);
                this.showNotification(false);
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
            if (null != this.mServiceBinder) {
                if (null != this.mPlayerListener) {
                    try {
                        this.mPlayerListener.onStart();
                    }
                    catch (RemoteException e) {
                        e.printStackTrace();
                    }
                }
                if (null != this.mPlayerListener) {
                    try {
                        this.mPlayerListener.onStartPlaying(this.getCurrentPlayingItemImpl());
                    }
                    catch (RemoteException e) {
                        e.printStackTrace();
                    }
                }
            }
            return true;
        }
        return this.startPlayer(this.mCurrentPlayingItem);
    }

    private boolean startPlayer(MusicPlayerItem item) {
        this.log("*********");
        this.log("startPlayer:");
        this.log("" + item);
        this.log("*********");
        if (null != item) {
            StatUtil.onTingshuBehavior(item.getMusicAlbumId(), "" + item.getMusicId(), "" + this.mStartPlayerSourceFrom);
        }
        if (null == item || TextUtils.isEmpty((CharSequence)item.getUrl())) {
            if (null != this.mPlayerListener) {
                try {
                    this.stopPlayer();
                    this.mPlayerListener.onShowMessage(this.getCurrentPlayingItemImpl(), 34, "uri is empty");
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
            }
            return false;
        }
        if (item.isLocalFileType() && !PlayerUtils.isFileExist(item)) {
            if (null != this.mPlayerListener) {
                try {
                    this.mPlayerListener.onShowMessage(this.getCurrentPlayingItemImpl(), 33, "file not exist.");
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
            }
            return false;
        }
        String url = item.getUrl();
        try {
            this.mCloudaryMediaPlayer = this.createMediaPlayerAsync(url);
            if (null == this.mCloudaryMediaPlayer) {
                return false;
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            return false;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            return false;
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private boolean canSeekTo() {
        return 39 == this.mMediaPlayerPlayingStatus || 40 == this.mMediaPlayerPlayingStatus || 41 == this.mMediaPlayerPlayingStatus || 42 == this.mMediaPlayerPlayingStatus;
    }

    private boolean seekToImpl(int position) {
        if (position < 0) {
            return false;
        }
        this.log("seekTo,position=" + position + ",total=" + this.getCurrentPlayingTotalTimeImpl());
        if (null != this.mCloudaryMediaPlayer && this.canSeekTo()) {
            try {
                if (!this.mCurrentPlayingItem.isNeedOrder()) {
                    this.mInSeekMode = true;
                    this.mBeforeSeekPostion = this.getCurrentPositionImpl();
                    this.mSeekPosition = position;
                    this.mSeekTimestamp = System.currentTimeMillis();
                    this.mCloudaryMediaPlayer.seekTo(position * 1000);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
            if (null != this.mServiceBinder && null != this.mPlayerListener) {
                try {
                    this.mPlayerListener.onSeekTo(position);
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
            }
            return true;
        }
        return false;
    }

    private MusicPlayerItem getPlayerItem(int index) {
        int size = this.mPlayList.size();
        if (size == 0) {
            return null;
        }
        if (index >= size) {
            return this.mPlayList.get(size - 1);
        }
        if (index < 0) {
            return this.mPlayList.get(0);
        }
        MusicPlayerItem item = this.mPlayList.get(index);
        return item;
    }

    private MusicPlayerItem getPlayerItem(MusicPlayerItem item) {
        int size = this.mPlayList.size();
        if (size == 0) {
            return null;
        }
        for (int i = 0; i < size; ++i) {
            MusicPlayerItem musicPlayerItem = this.mPlayList.get(i);
            if (!item.equals(musicPlayerItem)) continue;
            return musicPlayerItem;
        }
        return null;
    }

    private int getPlayerListSize() {
        int size = this.mPlayList.size();
        return size;
    }

    private boolean playNext() {
        this.keepAutoPlayStaus(0, 0);
        return this.playNext(false);
    }

    private boolean playNext(boolean clearCurrentPosition) {
        this.log("playNext");
        ++this.mCurrentPlayingIndex;
        if (clearCurrentPosition) {
            this.keepCurrentPosition(0);
        } else {
            this.keepCurrentPosition(null);
        }
        if (this.getPlayerListSize() == this.mCurrentPlayingIndex) {
            this.mCurrentPlayingIndex = this.getPlayerListSize() - 1;
            return false;
        }
        MusicPlayerItem nextItem = this.getPlayerItem(this.mCurrentPlayingIndex);
        if (null == nextItem) {
            this.mCurrentPlayingIndex = this.getPlayerListSize() - 1;
        }
        boolean handled = this.playItemPreHandle(nextItem);
        if (null != nextItem) {
            nextItem.position = 0;
        }
        if (null != this.mServiceBinder && null != this.mPlayerListener) {
            try {
                this.mPlayerListener.onNext(nextItem, this.mCurrentPlayingIndex);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        if (handled) {
            this.setCurrentPlayerItem(nextItem);
            return false;
        }
        return this.playItem(nextItem);
    }

    private boolean playItemPreHandle(MusicPlayerItem item) {
        if (item.isNeedOrder()) {
            this.stopPlayer();
            if (null != this.mServiceBinder && null != this.mPlayerListener) {
                try {
                    this.mPlayerListener.onShowMessage(item, 35, "This chapter need order,please order first,thanks.");
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
            }
            return true;
        }
        if (this.isNetworkUnAvailableAndUrlPlay(item)) {
            this.stopPlayer();
            if (null != this.mServiceBinder && null != this.mPlayerListener) {
                try {
                    this.mPlayerListener.onShowMessage(item, 32, "It is no network available");
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
            }
            return true;
        }
        if (!this.isWifiAndUrlAndAutoPlay(item)) {
            this.stopPlayer();
            if (null != this.mServiceBinder && null != this.mPlayerListener) {
                try {
                    this.mPlayerListener.onShowMessage(item, 31, "It is not wifi,it will auto stop the player to protect your network data usage.");
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
            }
            return true;
        }
        if (this.isPlayingLocalFile(item) && !PlayerUtils.isFileExist(item)) {
            this.stopPlayer();
            if (null != this.mServiceBinder && null != this.mPlayerListener) {
                try {
                    this.mPlayerListener.onShowMessage(item, 33, "file not exist.");
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
            }
            return true;
        }
        if (this.isPlayingUrl(item) && TextUtils.isEmpty((CharSequence)item.getUrl())) {
            this.stopPlayer();
            if (null != this.mServiceBinder && null != this.mPlayerListener) {
                try {
                    this.mPlayerListener.onShowMessage(item, 34, "url is empty");
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
            }
            return true;
        }
        return false;
    }

    private boolean isWifiAndUrlAndAutoPlay(MusicPlayerItem item) {
        boolean isWifi = PlayerUtils.isWifiActive(this.getApplicationContext());
        boolean isUrl = this.isPlayingUrl(item);
        if (!isWifi && isUrl) {
            return !this.getPlayerConfig().isDataProtect();
        }
        return true;
    }

    private boolean isNetworkUnAvailableAndUrlPlay(MusicPlayerItem item) {
        boolean isNetworkAvaiable = PlayerUtils.isNetworkAvailable(this.mContext);
        boolean isUrl = this.isPlayingUrl(item);
        return !isNetworkAvaiable && isUrl;
    }

    private boolean playPrev() {
        this.log("playPrev");
        this.mAutoPlayChapterCount = 0;
        this.mAutoPlayTime = 0;
        --this.mCurrentPlayingIndex;
        this.keepCurrentPosition(null);
        if (this.mCurrentPlayingIndex < 0) {
            this.mCurrentPlayingIndex = 0;
            return false;
        }
        MusicPlayerItem prevItem = this.getPlayerItem(this.mCurrentPlayingIndex);
        if (null == prevItem) {
            this.mCurrentPlayingIndex = 0;
        }
        boolean handled = this.playItemPreHandle(prevItem);
        if (null != prevItem) {
            prevItem.position = 0;
        }
        if (null != this.mServiceBinder && null != this.mPlayerListener) {
            try {
                this.mPlayerListener.onPrev(prevItem, this.mCurrentPlayingIndex);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        if (handled) {
            this.setCurrentPlayerItem(prevItem);
            return false;
        }
        return this.playItem(prevItem);
    }

    private boolean playItem(MusicPlayerItem item) {
        this.setCurrentPlayerItem(item);
        this.setPlayerPlayingStatus(36);
        if (null == item) {
            return false;
        }
        return this.startPlayer(item);
    }

    private void appendItemToPlayList(MusicPlayerItem item) {
        if (null == item) {
            return;
        }
        if (null == this.mCurrentPlayingItem) {
            this.setCurrentPlayerItem(item);
        }
        this.mPlayList.add(item);
        if (null != this.mPlayerListener) {
            this.mPlayerListener.onPlayerListChange();
        }
    }

    private void appendListToPlayList(ArrayList<MusicPlayerItem> list) {
        if (null == list || 0 == list.size()) {
            return;
        }
        if (null == this.mCurrentPlayingItem) {
            this.log("appendListToPlayList,setCurrentPlayerItem=" + list.get(0));
            this.setCurrentPlayerItem(list.get(0));
            this.mCurrentPlayingIndex = 0;
        }
        this.mPlayList.addAll(list);
        if (null != this.mPlayerListener) {
            this.mPlayerListener.onPlayerListChange();
        }
    }

    private void updateAuthedListToPlayList(ArrayList<MusicPlayerItem> updateAuthedList) {
        if (null == updateAuthedList || 0 == updateAuthedList.size()) {
            return;
        }
        int size = this.getPlayerListSize();
        for (int i = 0; i < size; ++i) {
            MusicPlayerItem item = this.mPlayList.get(i);
            this.updateAuthedItem(item, updateAuthedList);
        }
        if (null != this.mPlayerListener) {
            this.mPlayerListener.onPlayerListChange();
        }
    }

    private void updateAuthedItem(MusicPlayerItem item, ArrayList<MusicPlayerItem> updateAuthedList) {
        if (null == item || null == updateAuthedList || updateAuthedList.size() == 0) {
            return;
        }
        int size = updateAuthedList.size();
        for (int i = 0; i < size; ++i) {
            MusicPlayerItem authedplayerItemMusic = updateAuthedList.get(i);
            if (item.equals(authedplayerItemMusic)) {
                this.log("updateAuthedItem,before,item=" + item);
                this.log("updateAuthedItem,before,authedplayerItem=" + authedplayerItemMusic);
                item.setIsNeedOrder(authedplayerItemMusic.isNeedOrder());
                if (!item.isLocalFileType() || !PlayerUtils.isFileExist(item)) {
                    if (item.isLocalFileType() && !PlayerUtils.isFileExist(item)) {
                        item.setUrl(authedplayerItemMusic.getUrl());
                        item.setFileType(PlayerUtils.getFileType(authedplayerItemMusic.getUrl()));
                    } else if (authedplayerItemMusic.isLocalFileType() && !PlayerUtils.isFileExist(authedplayerItemMusic)) {
                        this.log("updateAuthedItem,is local file,but not exist,do nothing");
                    } else {
                        item.setUrl(authedplayerItemMusic.getUrl());
                        item.setFileType(PlayerUtils.getFileType(authedplayerItemMusic.getUrl()));
                    }
                }
                this.log("updateAuthedItem,after,item=" + item);
            }
            if (!authedplayerItemMusic.equals(this.mCurrentPlayingItem)) continue;
        }
    }

    private void insertItemToPlayList(MusicPlayerItem item) {
        if (null == item) {
            return;
        }
        if (null == this.mCurrentPlayingItem) {
            this.setCurrentPlayerItem(item);
        }
        if (this.mCurrentPlayingIndex - 1 > this.getPlayerListSize()) {
            this.mPlayList.insertElementAt(item, this.getPlayerListSize() - 1);
        } else {
            this.mPlayList.insertElementAt(item, this.mCurrentPlayingIndex);
        }
        if (null != this.mPlayerListener) {
            this.mPlayerListener.onPlayerListChange();
        }
    }

    private void deleteItemFromPlayList(MusicPlayerItem item) {
        if (item.equals(this.mCurrentPlayingItem)) {
            this.mPlayList.remove(this.mCurrentPlayingIndex);
            this.stopPlayer();
            this.playNext();
            if (null != this.mPlayerListener) {
                this.mPlayerListener.onPlayerListChange();
            }
            return;
        }
        int size = this.mPlayList.size();
        for (int i = 0; i < size; ++i) {
            MusicPlayerItem item2 = this.mPlayList.get(i);
            if (!item2.equals(item)) continue;
            this.mPlayList.remove(i);
            if (null != this.mPlayerListener) {
                this.mPlayerListener.onPlayerListChange();
            }
            return;
        }
    }

    private void clearPlayListImpl() {
        this.log("clearPlayListImpl");
        this.stopPlayer();
        this.mPlayList.clear();
        this.mCurrentPlayingIndex = 0;
        this.setCurrentPlayerItem(null);
        if (null != this.mPlayerListener) {
            this.mPlayerListener.onPlayerListChange();
        }
        this.dismissNotification();
    }

    private int isInPlayList(MusicPlayerItem item) {
        if (null == item) {
            return -1;
        }
        int size = this.mPlayList.size();
        for (int i = 0; i < size; ++i) {
            MusicPlayerItem object = this.mPlayList.get(i);
            if (!item.equals(object)) continue;
            return i;
        }
        return -1;
    }

    private void jumpToItem(MusicPlayerItem item) {
        this.log("jumpToItem,item=" + item);
        if (!item.equals(this.mCurrentPlayingItem)) {
            this.keepCurrentPosition(this.getCurrentPositionImpl());
        }
        int index = this.isInPlayList(item);
        this.log("jumpToItem,isInPlayList,index=" + index);
        if (-1 == index) {
            this.insertItemToPlayList(item);
            this.playItem(item);
        } else if (item.equals(this.mCurrentPlayingItem)) {
            if (!this.isPlaying()) {
                this.startPlayer();
            }
        } else {
            this.mCurrentPlayingIndex = index;
            this.playItem(this.getPlayerItem(index));
        }
        if (null != this.mPlayerListener) {
            this.mPlayerListener.onPlayerListChange();
        }
    }

    private void updateToItem(MusicPlayerItem item) {
        int index;
        this.log("updateToItem,item=" + item);
        this.log("updateToItem,mCurrentPlayingItem=" + this.mCurrentPlayingItem);
        if (!item.equals(this.mCurrentPlayingItem)) {
            this.keepCurrentPosition(this.getCurrentPositionImpl());
        }
        if (-1 == (index = this.isInPlayList(item))) {
            this.insertItemToPlayList(item);
        } else if (item.equals(this.mCurrentPlayingItem)) {
            if (!this.isPlaying()) {
                // empty if block
            }
        } else {
            this.mCurrentPlayingIndex = index;
            this.setCurrentPlayerItem(this.getPlayerItem(item));
        }
        if (null != this.mPlayerListener) {
            this.mPlayerListener.onPlayerListChange();
        }
    }

    private void updateItemPositionToPlayerList(MusicPlayerItem item) {
        if (null == item) {
            return;
        }
        int size = this.mPlayList.size();
        for (int i = 0; i < size; ++i) {
            MusicPlayerItem object = this.mPlayList.get(i);
            if (!item.equals(object)) continue;
            object.setPosition(item.getPosition());
        }
    }

    private void keepCurrentPosition(MediaPlayer mediaPlayer) {
        int position = this.getCurrentPositionImpl();
        this.keepCurrentPosition(position);
    }

    private void keepCurrentPosition(int position) {
        if (this.getCurrentPlayingTotalTimeImpl() == position) {
            position = 0;
        }
        if (null != this.mCurrentPlayingItem) {
            this.log("keepCurrentPosition,musicId=" + this.mCurrentPlayingItem.musicId + ".position=" + position + ",total=" + this.getCurrentPlayingTotalTimeImpl());
            if (this.canGetDuration() && !this.mCurrentPlayingItem.isNeedOrder()) {
                this.mCurrentPlayingItem.setPosition(position);
            } else if (this.mCurrentPlayingItem.isNeedOrder()) {
                this.mCurrentPlayingItem.setPosition(0);
            } else {
                this.mCurrentPlayingItem.setPosition(position);
            }
        }
    }

    private void keepAutoPlayStaus(int chapterCount, int time) {
        this.mAutoPlayChapterCount = chapterCount;
        this.mAutoPlayTime = time;
    }

    private boolean canGetDuration() {
        return 39 == this.mMediaPlayerPlayingStatus || 40 == this.mMediaPlayerPlayingStatus || 41 == this.mMediaPlayerPlayingStatus || 43 == this.mMediaPlayerPlayingStatus || 42 == this.mMediaPlayerPlayingStatus;
    }

    public int getCurrentPlayingTotalTimeImpl() {
        if (null != this.mCloudaryMediaPlayer && null != this.mCurrentPlayingItem && this.canGetDuration() && this.mCurrentPlayingItem.isLocalFileType()) {
            return this.mCloudaryMediaPlayer.getDuration() / 1000;
        }
        if (null != this.mCurrentPlayingItem && this.mCurrentPlayingItem.isUrlType()) {
            return this.mCurrentPlayingItem.getTime();
        }
        return -1;
    }

    private boolean canGetCurrentPosition() {
        return 39 == this.mMediaPlayerPlayingStatus || 37 == this.mMediaPlayerPlayingStatus || 38 == this.mMediaPlayerPlayingStatus || 40 == this.mMediaPlayerPlayingStatus || 41 == this.mMediaPlayerPlayingStatus || 43 == this.mMediaPlayerPlayingStatus || 42 == this.mMediaPlayerPlayingStatus;
    }

    public int getCurrentPositionImpl() {
        try {
            if (null != this.mCloudaryMediaPlayer && this.canGetCurrentPosition()) {
                return this.mCloudaryMediaPlayer.getCurrentPosition() / 1000;
            }
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public int getPlayerListCount() {
        if (null == this.mPlayList) {
            return 0;
        }
        return this.mPlayList.size();
    }

    private void setPrepareStatus(int prepareStatus) {
        this.mMediaPlayerPreparingStatus = prepareStatus;
    }

    private boolean isPlayerPreparedImpl() {
        return 48 == this.mMediaPlayerPreparingStatus && 43 != this.mMediaPlayerPlayingStatus;
    }

    private boolean isPlaying() {
        return 40 == this.mMediaPlayerPlayingStatus;
    }

    private boolean isPlayingUrl() {
        return null != this.mCurrentPlayingItem && this.mCurrentPlayingItem.isUrlType();
    }

    private boolean isPlayingUrl(MusicPlayerItem item) {
        return item.isUrlType();
    }

    private boolean isPlayingLocalFile(MusicPlayerItem item) {
        return !item.isUrlType();
    }

    private boolean canForwardImpl() {
        return this.mCurrentPlayingIndex + 1 < this.getPlayerListSize();
    }

    private boolean canGoBackImpl() {
        return this.mCurrentPlayingIndex - 1 >= 0;
    }

    private MusicPlayerConfig getPlayerConfig() {
        MusicPlayerConfig config = null;
        if (null != this.mPlayerListener) {
            config = this.mPlayerListener.getPlayerConfig();
            if (null == config) {
                config = this.mMusicPlayerConfig;
            } else {
                this.mMusicPlayerConfig = config;
            }
        }
        if (null == config) {
            config = new MusicPlayerConfig();
        }
        return config;
    }

    private MusicPlayerItem getCurrentPlayingItemImpl() {
        if (null != this.mCurrentPlayingItem) {
            this.mCurrentPlayingItem.setPlayingStatus(this.mMediaPlayerPlayingStatus);
            return this.mCurrentPlayingItem;
        }
        return null;
    }

    private boolean isNeedStopPlayerWhenNotWifi() {
        boolean isWifiActive = PlayerUtils.isWifiActive(this.getApplicationContext());
        boolean isUrlType = this.isPlayingUrl();
        return PlayerUtils.isNetworkAvailable(this.mContext) && !isWifiActive && isUrlType;
    }

    private void setCurrentPlayerItem(MusicPlayerItem item) {
        this.log("setCurrentPlayerItem,item=" + item);
        this.mCurrentPlayingItem = item;
        if (null != item) {
            this.savePlayingStatus();
        }
    }

    private void savePlayingStatus() {
        if (null != this.mPlayerListener) {
            if (isPlayerListComplete) {
                this.onPlayerListComplete();
            } else {
                this.mPlayerListener.savePlayingStatus(this.getApplicationContext(), this.mCurrentPlayingItem, this.musicAlbumObject, this.getPlayerListCount(), this.mCurrentPlayingIndex);
            }
        }
    }

    public static interface OnAudioFocusChangeListener {
        public void onAudioFocusChange(int var1);
    }
}

