/*
 * Decompiled with CFR 0.152.
 */
package me.pjq.musicplayer;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.util.Log;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class ShakeEventManager
implements SensorEventListener {
    private static final String TAG = ShakeEventManager.class.getSimpleName();
    private SensorManager sManager;
    private Sensor s;
    private ShakeListener listener;
    FileWriter fileWriter;
    RotateSession rotateSession = new RotateSession(new OnTriggerListener(){

        @Override
        public void onTrigger() {
            ShakeEventManager.this.listener.onShake();
            try {
                ShakeEventManager.this.fileWriter.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    });
    ShakeSession shakeSession = new ShakeSession(new OnTriggerListener(){

        @Override
        public void onTrigger() {
            ShakeEventManager.this.listener.onShake();
            try {
                ShakeEventManager.this.fileWriter.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    });

    public void setListener(ShakeListener listener) {
        this.listener = listener;
    }

    public void init(Context ctx) {
        this.sManager = (SensorManager)ctx.getSystemService("sensor");
        this.s = this.sManager.getDefaultSensor(1);
        this.register();
        try {
            this.fileWriter = new FileWriter(new File("/sdcard/sensor.log"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void register() {
        this.sManager.registerListener((SensorEventListener)this, this.s, 3);
    }

    public void onSensorChanged(SensorEvent sensorEvent) {
        float x = sensorEvent.values[0];
        float y = sensorEvent.values[1];
        float z = sensorEvent.values[2];
        this.shakeHandler(sensorEvent);
        this.writeFile(sensorEvent);
    }

    private void writeFile(SensorEvent sensorEvent) {
        float x = sensorEvent.values[0];
        float y = sensorEvent.values[1];
        float z = sensorEvent.values[2];
        String value = System.currentTimeMillis() + ", onSensorChanged,x=" + x + ",y=" + y + ",z=" + z;
        try {
            this.fileWriter.append(value + '\n');
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void rotateHandler(SensorEvent e) {
        this.rotateSession.addEvent(e);
        this.rotateSession.process();
    }

    private void shakeHandler(SensorEvent sensorEvent) {
        this.shakeSession.addEvent(sensorEvent);
        this.shakeSession.process();
    }

    public void onAccuracyChanged(Sensor sensor, int i) {
    }

    public void deregister() {
        this.sManager.unregisterListener((SensorEventListener)this);
    }

    private void flipBackHandler(SensorEvent e) {
        float x = e.values[0];
        float y = e.values[1];
        float z = e.values[2];
        boolean isStop = false;
        int zMinValue = -8;
        if (x < 1.0f && x > -1.0f && y < 1.0f && y > -1.0f) {
            if (z <= (float)zMinValue) {
                isStop = true;
            }
        } else if (z <= (float)zMinValue) {
            isStop = true;
        }
        if (isStop) {
            this.listener.onShake();
        }
    }

    private void onLeftHandShake(SensorEvent e) {
        float x = e.values[0];
        float y = e.values[1];
        float z = e.values[2];
        boolean isStop = false;
        int zMinValue = -8;
        if (x < 1.0f && x > -1.0f && y < 1.0f && y > -1.0f) {
            if (z <= (float)zMinValue) {
                isStop = true;
            }
        } else if (z <= (float)zMinValue) {
            isStop = true;
        }
        if (isStop) {
            this.listener.onShake();
        }
    }

    private static class RotateSession
    extends BaseSession {
        private boolean value7_8 = false;
        private boolean value4_5 = false;
        private boolean value0_1 = false;
        private boolean value_1_0 = false;
        private boolean value_5_4 = false;
        private boolean value_8_7 = false;

        public RotateSession(OnTriggerListener listener) {
            super(listener);
        }

        @Override
        public void addEvent(SensorEvent e) {
            float x = e.values[0];
            float y = e.values[1];
            float z = e.values[2];
            float val = z;
            if (2.0f <= val && val <= 7.0f) {
                this.value7_8 = true;
            }
            if (this.value7_8 && 1.0f <= val && val <= 5.0f) {
                this.value4_5 = true;
            }
            if (0.0f <= val && val <= 5.0f) {
                this.value0_1 = true;
            }
            if (this.value7_8 && -5.0f <= val && val <= 0.0f) {
                this.value_1_0 = true;
            }
            if (-7.0f <= val && val <= -2.0f) {
                this.value_5_4 = true;
            }
            if (this.value_1_0 && -10.0f <= val && (double)val <= -5.5) {
                this.value_8_7 = true;
            }
        }

        @Override
        protected float SHAKE_WINDOW_TIME_INTERVAL() {
            return 3000.0f;
        }

        @Override
        protected int MOV_COUNTS_TRIGGER() {
            return 2;
        }

        @Override
        protected boolean isTriggered() {
            return this.isSessionFinished();
        }

        public boolean isSessionFinished() {
            if (this.value7_8 && this.value4_5 && this.value0_1 && this.value_1_0 && this.value_5_4 && this.value_8_7) {
                Log.i((String)TAG, (String)"isSessionFinished = true");
                this.resetData();
                return true;
            }
            return false;
        }

        public void resetData() {
            this.value7_8 = false;
            this.value0_1 = false;
            this.value_1_0 = false;
            this.value_5_4 = false;
            this.value_8_7 = false;
        }
    }

    private static class ShakeSession
    extends BaseSession {
        private static final int MOV_THRESHOLD = 17;
        private static final float ALPHA = 0.8f;
        float maxAcc;
        private float[] gravity = new float[3];

        public ShakeSession(OnTriggerListener listener) {
            super(listener);
        }

        @Override
        public void addEvent(SensorEvent e) {
            this.maxAcc = this.calcMaxAcceleration(e);
        }

        @Override
        protected float SHAKE_WINDOW_TIME_INTERVAL() {
            return 400.0f;
        }

        @Override
        protected boolean isTriggered() {
            return this.maxAcc >= 17.0f;
        }

        @Override
        protected void reset() {
            super.reset();
        }

        private float calcMaxAcceleration(SensorEvent event) {
            this.gravity[0] = this.calcGravityForce(event.values[0], 0);
            this.gravity[1] = this.calcGravityForce(event.values[1], 1);
            this.gravity[2] = this.calcGravityForce(event.values[2], 2);
            float accX = event.values[0] - this.gravity[0];
            float accY = event.values[1] - this.gravity[1];
            float accZ = event.values[2] - this.gravity[2];
            float max1 = Math.max(accX, accY);
            return Math.max(max1, accZ);
        }

        private float calcGravityForce(float currentVal, int index) {
            return 0.8f * this.gravity[index] + 0.19999999f * currentVal;
        }
    }

    public static abstract class BaseSession {
        protected int counter = 0;
        protected long firstMovTime;
        protected OnTriggerListener listener;

        public BaseSession(OnTriggerListener listener) {
            this.listener = listener;
        }

        protected void reset() {
            this.counter = 0;
            this.firstMovTime = System.currentTimeMillis();
        }

        public abstract void addEvent(SensorEvent var1);

        protected float SHAKE_WINDOW_TIME_INTERVAL() {
            return 400.0f;
        }

        protected int MOV_COUNTS_TRIGGER() {
            return 4;
        }

        public void process() {
            if (this.isTriggered()) {
                if (this.counter == 0) {
                    ++this.counter;
                    this.firstMovTime = System.currentTimeMillis();
                    Log.d((String)TAG, (String)"First mov..");
                } else {
                    long now = System.currentTimeMillis();
                    if ((float)(now - this.firstMovTime) < this.SHAKE_WINDOW_TIME_INTERVAL()) {
                        ++this.counter;
                    } else {
                        this.reset();
                        ++this.counter;
                        return;
                    }
                    Log.d((String)TAG, (String)("Mov counter [" + this.counter + "]" + this.MOV_COUNTS_TRIGGER()));
                    if (this.counter >= this.MOV_COUNTS_TRIGGER()) {
                        if (this.listener != null) {
                            this.listener.onTrigger();
                        }
                        Log.d((String)TAG, (String)"onTrigger");
                    }
                }
            }
        }

        protected abstract boolean isTriggered();
    }

    public static interface OnTriggerListener {
        public void onTrigger();
    }

    public static interface ShakeListener {
        public void onShake();

        public void onFlipBack();
    }
}

