/*
 * Decompiled with CFR 0.152.
 */
package me.pjq.musicplayer.utils;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v4.app.NotificationCompat;
import java.io.Serializable;
import me.pjq.musicplayer.MusicAlbumObject;
import me.pjq.musicplayer.MusicNotificationClassProvider;
import me.pjq.musicplayer.R;
import me.pjq.musicplayer.utils.Utils;

public class NotificationUtil {
    private static final String TAG = NotificationUtil.class.getSimpleName();
    private static MusicNotificationClassProvider notificationClassProvider;
    public static final int NOTIFICATION_ID = 1000;

    public static void setNotificationClassProvider(MusicNotificationClassProvider provider) {
        notificationClassProvider = provider;
    }

    public static PendingIntent createPendingIntent(Context context, MusicAlbumObject musicList) {
        PendingIntent pendingIntent = null;
        Intent intent = new Intent();
        Bundle bundle = new Bundle();
        bundle.putSerializable("book", (Serializable)musicList);
        intent.putExtras(bundle);
        intent.setFlags(0x4000000);
        if (null != notificationClassProvider) {
            intent.setClass(context, notificationClassProvider.getNotificationClass());
        }
        pendingIntent = PendingIntent.getActivity((Context)context, (int)1000, (Intent)intent, (int)0x8000000);
        return pendingIntent;
    }

    public static void showNotification(Context context, String message, MusicAlbumObject musicList) {
        Utils.i(TAG, "showNotification,context=" + context + ",message=" + message + ",book=" + musicList);
        if (null == context || null == musicList) {
            return;
        }
        NotificationCompat.Builder builder = new NotificationCompat.Builder(context);
        builder.setAutoCancel(false);
        PendingIntent pi = NotificationUtil.createPendingIntent(context, musicList);
        builder.setContentIntent(pi);
        builder.setContentTitle((CharSequence)(context.getString(R.string.app_name) + "(" + musicList.getListName() + ")"));
        builder.setContentText((CharSequence)message);
        builder.setTicker((CharSequence)context.getString(R.string.app_name));
        builder.setSmallIcon(notificationClassProvider.getSmallIcon());
        builder.setWhen(System.currentTimeMillis());
        NotificationManager nm = (NotificationManager)context.getSystemService("notification");
        Notification notification = builder.getNotification();
        notification.flags |= 0x20;
        nm.notify(1000, notification);
    }

    public static void dismissNotification(Context context) {
        NotificationManager nm = (NotificationManager)context.getSystemService("notification");
        nm.cancel(1000);
    }
}

