/*
 * Decompiled with CFR 0.152.
 */
package me.pjq.musicplayer.utils;

import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import java.io.File;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import me.pjq.musicplayer.MusicAlbumObject;
import me.pjq.musicplayer.MusicNotificationClassProvider;
import me.pjq.musicplayer.MusicPlayerItem;
import me.pjq.musicplayer.R;
import me.pjq.musicplayer.utils.NotificationUtil;
import me.pjq.musicplayer.utils.Utils;

public class PlayerUtils {
    private static final String TAG = PlayerUtils.class.getSimpleName();
    public static final String TEST_URL = "http://listen.tingbook.com/Android/AndroidPlayerUrl.aspx?bookid=3793&volumenum=1";
    public static final String LOCAL_FILE_TYPE = "file:///mnt/sdcard/mp3/1.mp3";
    public static final int TOTAL_TIME = 92000;
    private static final boolean controlled = true;
    private static final SimpleDateFormat sDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public static void playTest(Context context) {
        PlayerUtils.getMusicListByDirectory(context, "/sdcard/netease/cloudmusic/Music");
    }

    public static ArrayList<MusicPlayerItem> playByDirectory(Context context) {
        ArrayList<MusicPlayerItem> list = PlayerUtils.getMusicListByDirectory(context, "/sdcard/netease/cloudmusic/Music");
        return list;
    }

    public static ArrayList<MusicPlayerItem> getMusicListByDirectory(Context context, String path) {
        ArrayList<MusicPlayerItem> list = new ArrayList<MusicPlayerItem>();
        File file = new File(path);
        if (file.exists() && file.isDirectory()) {
            File[] files;
            for (File item : files = file.listFiles()) {
                if (item.isDirectory()) {
                    File[] files2;
                    for (File item2 : files2 = item.listFiles()) {
                        MusicPlayerItem musicPlayerItem = PlayerUtils.fileToPlayerItem(context, item2);
                        if (null != musicPlayerItem) {
                            list.add(musicPlayerItem);
                        }
                        MusicPlayerItem urlItem = new MusicPlayerItem();
                        urlItem.setUrl(TEST_URL);
                        urlItem.setDescription("unknown description");
                        urlItem.setName("Sunshine girl");
                        urlItem.setTime(92000);
                        urlItem.setFileType(45);
                    }
                    continue;
                }
                MusicPlayerItem musicPlayerItem = PlayerUtils.fileToPlayerItem(context, item);
                if (null == musicPlayerItem) continue;
                list.add(musicPlayerItem);
            }
        }
        return list;
    }

    public static void play(Context context, String url) {
        PlayerUtils.play(context, Uri.parse((String)url));
    }

    public static void play(Context context, Uri uri) {
        if (null == uri) {
            return;
        }
        Intent intent = new Intent();
        intent.setAction("me.pjq.musicplayer.MusicPlayerService");
        Bundle bundle = new Bundle();
        bundle.putInt("player_command", 1);
        MusicPlayerItem item = new MusicPlayerItem();
        item.setUrl(uri.toString());
        item.setDescription(uri.toString());
        item.setName(uri.toString());
        if (uri.getScheme().equalsIgnoreCase("file")) {
            item.setFileType(46);
        } else if (uri.getScheme().equalsIgnoreCase("http")) {
            item.setFileType(45);
        }
        bundle.putParcelable("player_item", (Parcelable)item);
        intent.putExtras(bundle);
        context.startService(intent);
    }

    public static void play(Context context, MusicPlayerItem item) {
        PlayerUtils.printTime("play");
        Intent intent = new Intent();
        intent.setAction("me.pjq.musicplayer.MusicPlayerService");
        Bundle bundle = new Bundle();
        bundle.putInt("player_command", 1);
        bundle.putParcelable("player_item", (Parcelable)item);
        intent.putExtras(bundle);
        context.startService(intent);
    }

    public static void play(Context context) {
        PlayerUtils.printTime("play");
        Intent intent = new Intent();
        intent.setAction("me.pjq.musicplayer.MusicPlayerService");
        Bundle bundle = new Bundle();
        bundle.putInt("player_command", 1);
        intent.putExtras(bundle);
        context.startService(intent);
    }

    public static void stop(Context context) {
        PlayerUtils.printTime("stop");
        Intent intent = new Intent();
        intent.setAction("me.pjq.musicplayer.MusicPlayerService");
        Bundle bundle = new Bundle();
        bundle.putInt("player_command", 2);
        intent.putExtras(bundle);
        context.startService(intent);
    }

    public static void pause(Context context) {
        PlayerUtils.printTime("pause");
        Intent intent = new Intent();
        intent.setAction("me.pjq.musicplayer.MusicPlayerService");
        Bundle bundle = new Bundle();
        bundle.putInt("player_command", 3);
        intent.putExtras(bundle);
        context.startService(intent);
    }

    public static void playSeekTo(Context context, int position) {
        PlayerUtils.printTime("playSeekTo");
        Intent intent = new Intent();
        intent.setAction("me.pjq.musicplayer.MusicPlayerService");
        Bundle bundle = new Bundle();
        bundle.putInt("player_command", 4);
        bundle.putInt("position", position);
        intent.putExtras(bundle);
        context.startService(intent);
    }

    public static void appendItem(Context context, MusicPlayerItem item) {
        PlayerUtils.printTime("appendItem");
        Intent intent = new Intent();
        intent.setAction("me.pjq.musicplayer.MusicPlayerService");
        Bundle bundle = new Bundle();
        bundle.putInt("player_command", 7);
        bundle.putParcelable("player_item", (Parcelable)item);
        intent.putExtras(bundle);
        context.startService(intent);
    }

    public static void appendList(Context context, ArrayList<MusicPlayerItem> list) {
        if (null == list || 0 == list.size()) {
            return;
        }
        PlayerUtils.printTime("appendList");
        Intent intent = new Intent();
        intent.setAction("me.pjq.musicplayer.MusicPlayerService");
        Bundle bundle = new Bundle();
        bundle.putInt("player_command", 8);
        bundle.putParcelableArrayList("list", list);
        intent.putExtras(bundle);
        context.startService(intent);
    }

    public static void appendList2(Context context, ArrayList<MusicPlayerItem> list) {
        if (null == list || 0 == list.size()) {
            return;
        }
        PlayerUtils.printTime("appendList");
        Intent intent = new Intent();
        intent.setAction("me.pjq.musicplayer.MusicPlayerService");
        Bundle bundle = new Bundle();
        bundle.putInt("player_command", 8);
        bundle.putParcelableArrayList("list", list);
        intent.putExtras(bundle);
        context.startService(intent);
    }

    public static void updateList(Context context, ArrayList<MusicPlayerItem> list) {
        if (null == list || 0 == list.size()) {
            return;
        }
        PlayerUtils.printTime("appendList");
        Intent intent = new Intent();
        intent.setAction("me.pjq.musicplayer.MusicPlayerService");
        Bundle bundle = new Bundle();
        bundle.putInt("player_command", 9);
        bundle.putParcelableArrayList("list", list);
        intent.putExtras(bundle);
        context.startService(intent);
    }

    private static MusicPlayerItem fileToPlayerItem(Context context, File file) {
        if (!file.getName().endsWith("mp3")) {
            return null;
        }
        MusicPlayerItem item = new MusicPlayerItem();
        item.setDescription(file.getName());
        item.setUrl("file://" + file.getAbsolutePath());
        item.setName(file.getName());
        item.setFileType(46);
        return item;
    }

    public static void appendItem(Context context, File file) {
        if (null == file) {
            return;
        }
        if (!file.getName().endsWith("mp3")) {
            return;
        }
        MusicPlayerItem item = new MusicPlayerItem();
        item.setDescription(file.getName());
        item.setUrl("file://" + file.getAbsolutePath());
        item.setName(file.getName());
        item.setFileType(46);
        Intent intent = new Intent();
        intent.setAction("me.pjq.musicplayer.MusicPlayerService");
        Bundle bundle = new Bundle();
        bundle.putInt("player_command", 7);
        bundle.putParcelable("player_item", (Parcelable)item);
        intent.putExtras(bundle);
        context.startService(intent);
    }

    public static void deleteItem(Context context, MusicPlayerItem item) {
        PlayerUtils.printTime("deleteItem");
        Intent intent = new Intent();
        intent.setAction("me.pjq.musicplayer.MusicPlayerService");
        Bundle bundle = new Bundle();
        bundle.putInt("player_command", 13);
        bundle.putParcelable("player_item", (Parcelable)item);
        intent.putExtras(bundle);
        context.startService(intent);
    }

    public static void clearPlayList(Context context) {
        PlayerUtils.printTime("clearPlayList");
        Intent intent = new Intent();
        intent.setAction("me.pjq.musicplayer.MusicPlayerService");
        Bundle bundle = new Bundle();
        bundle.putInt("player_command", 19);
        intent.putExtras(bundle);
        context.startService(intent);
    }

    public static void playNext(Context context) {
        PlayerUtils.printTime("playNext");
        Intent intent = new Intent();
        intent.setAction("me.pjq.musicplayer.MusicPlayerService");
        Bundle bundle = new Bundle();
        bundle.putInt("player_command", 5);
        intent.putExtras(bundle);
        context.startService(intent);
    }

    public static void playPrev(Context context) {
        PlayerUtils.printTime("playPrev");
        Intent intent = new Intent();
        intent.setAction("me.pjq.musicplayer.MusicPlayerService");
        Bundle bundle = new Bundle();
        bundle.putInt("player_command", 6);
        intent.putExtras(bundle);
        context.startService(intent);
    }

    public static void stopService(Context context) {
        PlayerUtils.printTime("stopService");
        Intent intent = new Intent();
        intent.setAction("me.pjq.musicplayer.MusicPlayerService");
        context.stopService(intent);
    }

    public static void stopServiceWithouSave(Context context) {
        Intent intent = new Intent();
        intent.setAction("me.pjq.musicplayer.MusicPlayerService");
        Bundle bundle = new Bundle();
        bundle.putInt("player_command", 24);
        intent.putExtras(bundle);
        context.startService(intent);
    }

    public static void requireNotificationController(Context context) {
    }

    public static void returnNotificationController(Context context) {
    }

    public static void initNotification(MusicNotificationClassProvider provider) {
        NotificationUtil.setNotificationClassProvider(provider);
    }

    public static void showNotification(Context context) {
        Intent intent = new Intent();
        intent.setAction("me.pjq.musicplayer.MusicPlayerService");
        Bundle bundle = new Bundle();
        bundle.putInt("player_command", 17);
        intent.putExtras(bundle);
        context.startService(intent);
    }

    public static void dismissNotification(Context context) {
        Intent intent = new Intent();
        intent.setAction("me.pjq.musicplayer.MusicPlayerService");
        Bundle bundle = new Bundle();
        bundle.putInt("player_command", 18);
        intent.putExtras(bundle);
        context.startService(intent);
    }

    public static void jumpToItem(Context context, MusicPlayerItem item) {
        Intent intent = new Intent();
        intent.setAction("me.pjq.musicplayer.MusicPlayerService");
        Bundle bundle = new Bundle();
        bundle.putInt("player_command", 20);
        bundle.putParcelable("player_item", (Parcelable)item);
        intent.putExtras(bundle);
        context.startService(intent);
    }

    public static void updateToItem(Context context, MusicPlayerItem item) {
        Intent intent = new Intent();
        intent.setAction("me.pjq.musicplayer.MusicPlayerService");
        Bundle bundle = new Bundle();
        bundle.putInt("player_command", 21);
        bundle.putParcelable("player_item", (Parcelable)item);
        intent.putExtras(bundle);
        context.startService(intent);
    }

    public static void jumpToItem(Context context, String url) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            return;
        }
        Uri uri = Uri.parse((String)url);
        MusicPlayerItem item = new MusicPlayerItem();
        item.setUrl(uri.toString());
        item.setDescription(uri.toString());
        item.setName(uri.getPath());
        if (uri.getScheme().equalsIgnoreCase("file")) {
            item.setFileType(46);
        } else if (uri.getScheme().equalsIgnoreCase("http")) {
            item.setFileType(45);
        }
        PlayerUtils.jumpToItem(context, item);
    }

    public static void jumpToItem(Context context, int index) {
        Intent intent = new Intent();
        intent.setAction("me.pjq.musicplayer.MusicPlayerService");
        Bundle bundle = new Bundle();
        bundle.putInt("player_command", 22);
        bundle.putInt("index", index);
        intent.putExtras(bundle);
        context.startService(intent);
    }

    public static void resetStepCount(Context context) {
        Intent intent = new Intent();
        intent.setAction("me.pjq.musicplayer.MusicPlayerService");
        Bundle bundle = new Bundle();
        bundle.putInt("player_command", 26);
        intent.putExtras(bundle);
        context.startService(intent);
    }

    public static void updatePlayingPostionToItem(Context context, MusicPlayerItem item) {
        Intent intent = new Intent();
        intent.setAction("me.pjq.musicplayer.MusicPlayerService");
        Bundle bundle = new Bundle();
        bundle.putInt("player_command", 23);
        bundle.putParcelable("player_item", (Parcelable)item);
        intent.putExtras(bundle);
        context.startService(intent);
    }

    public static void updateMusicListObject(Context context, MusicAlbumObject musicAlbumObject) {
        Intent intent = new Intent();
        intent.setAction("me.pjq.musicplayer.MusicPlayerService");
        Bundle bundle = new Bundle();
        bundle.putInt("player_command", 10);
        bundle.putSerializable("book", (Serializable)musicAlbumObject);
        intent.putExtras(bundle);
        context.startService(intent);
    }

    public static void updateStartPlayerSource(Context context, int startSourceFrom) {
        Intent intent = new Intent();
        intent.setAction("me.pjq.musicplayer.MusicPlayerService");
        Bundle bundle = new Bundle();
        bundle.putInt("player_command", 27);
        bundle.putInt("start_source_from", startSourceFrom);
        intent.putExtras(bundle);
        context.startService(intent);
    }

    public static boolean isNetworkAvailable(Context context) {
        ConnectivityManager connectivity = (ConnectivityManager)context.getSystemService("connectivity");
        if (connectivity == null) {
            return false;
        }
        NetworkInfo[] info = connectivity.getAllNetworkInfo();
        if (info != null) {
            for (int i = 0; i < info.length; ++i) {
                if (!info[i].isConnected()) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isWifiActive(Context icontext) {
        NetworkInfo[] info;
        Context context = icontext.getApplicationContext();
        ConnectivityManager connectivity = (ConnectivityManager)context.getSystemService("connectivity");
        if (connectivity != null && (info = connectivity.getAllNetworkInfo()) != null) {
            for (int i = 0; i < info.length; ++i) {
                if (!info[i].getTypeName().equalsIgnoreCase("WIFI") && !info[i].getTypeName().equalsIgnoreCase("WI FI") || !info[i].isConnected()) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isFileExist(MusicPlayerItem item) {
        if (null == item) {
            return false;
        }
        if (item.isLocalFileType()) {
            String path = item.getUrl();
            Uri uri = Uri.parse((String)path);
            path = uri.getPath();
            File file = new File(path = path.replace("file://", ""));
            return file.exists();
        }
        return false;
    }

    public static MusicAlbumObject getBookFromBundle(Bundle bundle) {
        MusicAlbumObject musicList = null;
        if (null != bundle) {
            musicList = (MusicAlbumObject)bundle.getSerializable("book");
        }
        return musicList;
    }

    public static int getStartTingshuSourceFromBundle(Bundle bundle) {
        int startSourceFrom = -1;
        if (null != bundle) {
            startSourceFrom = bundle.getInt("start_source_from");
        }
        return startSourceFrom;
    }

    public static int getFileType(String uri) {
        if (TextUtils.isEmpty((CharSequence)uri)) {
            return 45;
        }
        if (uri.startsWith("http")) {
            return 45;
        }
        return 46;
    }

    public static String getFileSizeReadableString(long fileSize) {
        float sizeK = (float)fileSize / 1024.0f;
        String string2 = "";
        if (sizeK < 1024.0f) {
            string2 = PlayerUtils.floatAccurate(sizeK, 2) + "K";
            return string2;
        }
        float sizeM = sizeK / 1024.0f;
        if (sizeM < 1024.0f) {
            string2 = PlayerUtils.floatAccurate(sizeM, 2) + "M";
            return string2;
        }
        float sizeG = sizeM / 1024.0f;
        string2 = PlayerUtils.floatAccurate(sizeG, 2) + "G";
        return string2;
    }

    public static String floatAccurate(float value, int accurate) {
        int allLength;
        String string2 = "" + value;
        int dotIndex = string2.indexOf(".");
        int end = dotIndex + accurate + 1;
        if (end > (allLength = string2.length())) {
            end = allLength;
        }
        string2 = string2.substring(0, end);
        return string2;
    }

    public static String getTimeReadable(int durationSecond) {
        int ss = durationSecond;
        int hour = durationSecond / 3600;
        String hourString = "";
        if (hour > 0) {
            ss = durationSecond % 3600;
            hourString = hour < 10 ? "0" + hour : "" + hour;
        }
        int minute = ss / 60;
        int second = ss % 60;
        String minuteString = "";
        String sencodString = "";
        minuteString = minute < 10 ? "0" + minute : "" + minute;
        sencodString = second < 10 ? "0" + second : "" + second;
        String readableTime = minuteString + ":" + sencodString;
        if (hour > 0) {
            readableTime = hourString + ":" + readableTime;
        }
        return readableTime;
    }

    public static String getTimeReadableString(Context context, long durationSecond) {
        long ss = durationSecond;
        long hour = durationSecond / 3600L;
        String hourString = "";
        if (hour > 0L) {
            ss = durationSecond % 3600L;
            hourString = hour < 10L ? "0" + hour : "" + hour;
        }
        long minute = ss / 60L;
        long second = ss % 60L;
        String minuteString = "";
        String sencodString = "";
        minuteString = minute < 10L ? "0" + minute : "" + minute;
        sencodString = second < 10L ? "0" + second : "" + second;
        String readableTime = "";
        String hString = context.getString(R.string.hour);
        String mString = context.getString(R.string.minute);
        String sString = context.getString(R.string.second);
        if (hour > 0L) {
            readableTime = hourString + hString;
        }
        if (minute > 0L) {
            readableTime = readableTime + minuteString + mString;
        }
        if (second > 0L) {
            readableTime = readableTime + sencodString + sString;
        }
        return readableTime;
    }

    public static void printTime(String message) {
        long currentTime = System.currentTimeMillis();
        Utils.i(TAG, message + ":" + currentTime + " ms");
    }

    private static long dateConvert(String time) {
        if (TextUtils.isEmpty((CharSequence)time)) {
            return 0L;
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            return format.parse(time).getTime();
        }
        catch (ParseException e) {
            e.printStackTrace();
            return 0L;
        }
    }

    private static long dateConvertForYuncheng(String time) {
        if (TextUtils.isEmpty((CharSequence)time)) {
            return 0L;
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHH");
        try {
            return format.parse(time).getTime();
        }
        catch (ParseException e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public static boolean isTimeValid(String start, String end, long nowTime) {
        try {
            if (TextUtils.isEmpty((CharSequence)start) || TextUtils.isEmpty((CharSequence)end)) {
                return false;
            }
            long startTime = PlayerUtils.dateConvert(start);
            long endTime = PlayerUtils.dateConvert(end);
            return nowTime >= startTime && nowTime <= endTime;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isTimeValidForYuncheng(String end, long nowTime) {
        try {
            if (TextUtils.isEmpty((CharSequence)end)) {
                return false;
            }
            long endTime = PlayerUtils.dateConvertForYuncheng(end);
            return nowTime <= endTime;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static void download(String rpidBookid, int chapterId, String url, long fileSize) {
    }
}

