/*
 * Decompiled with CFR 0.152.
 */
package me.pjq.musicplayer.utils;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;

public class Utils {
    public static void unBindDrawables(View view) {
        if (view != null) {
            if (view.getBackground() != null) {
                view.getBackground().setCallback(null);
            }
            if (view instanceof ViewGroup && !(view instanceof AdapterView)) {
                for (int i = 0; i < ((ViewGroup)view).getChildCount(); ++i) {
                    Utils.unBindDrawables(((ViewGroup)view).getChildAt(i));
                }
                ((ViewGroup)view).removeAllViews();
            }
        }
    }

    public static boolean isNetworkAvailable(Context context) {
        ConnectivityManager connectivity = (ConnectivityManager)context.getSystemService("connectivity");
        if (connectivity == null) {
            return false;
        }
        NetworkInfo[] info = connectivity.getAllNetworkInfo();
        if (info != null) {
            for (int i = 0; i < info.length; ++i) {
                if (!info[i].isConnected()) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isWifiActive(Context context) {
        NetworkInfo[] info;
        ConnectivityManager connectivity = (ConnectivityManager)context.getSystemService("connectivity");
        if (connectivity != null && (info = connectivity.getAllNetworkInfo()) != null) {
            for (int i = 0; i < info.length; ++i) {
                if (!info[i].getTypeName().equalsIgnoreCase("WIFI") && !info[i].getTypeName().equalsIgnoreCase("WI FI") || !info[i].isConnected()) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isNetworkAvailableAndNotWifi(Context context) {
        return Utils.isNetworkAvailable(context) && !Utils.isWifiActive(context);
    }

    public static String getTimeReadable(int durationSecond) {
        int ss = durationSecond;
        int hour = durationSecond / 3600;
        String hourString = "";
        if (hour > 0) {
            ss = durationSecond % 3600;
            hourString = hour < 10 ? "0" + hour : "" + hour;
        }
        int minute = ss / 60;
        int second = ss % 60;
        String minuteString = "";
        String sencodString = "";
        minuteString = minute < 10 ? "0" + minute : "" + minute;
        sencodString = second < 10 ? "0" + second : "" + second;
        String readableTime = minuteString + ":" + sencodString;
        if (hour > 0) {
            readableTime = hourString + ":" + readableTime;
        }
        return readableTime;
    }

    public static void i(String tag, String msg) {
        Log.i((String)tag, (String)msg);
    }
}

