/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mqtt;

import com.ibm.mqtt.MQeTrace;
import com.ibm.mqtt.MqttAdapter;
import com.ibm.mqtt.MqttConnack;
import com.ibm.mqtt.MqttConnect;
import com.ibm.mqtt.MqttDisconnect;
import com.ibm.mqtt.MqttException;
import com.ibm.mqtt.MqttNotConnectedException;
import com.ibm.mqtt.MqttPacket;
import com.ibm.mqtt.MqttPingreq;
import com.ibm.mqtt.MqttPingresp;
import com.ibm.mqtt.MqttProcessor;
import com.ibm.mqtt.MqttPuback;
import com.ibm.mqtt.MqttPubcomp;
import com.ibm.mqtt.MqttPublish;
import com.ibm.mqtt.MqttPubrec;
import com.ibm.mqtt.MqttPubrel;
import com.ibm.mqtt.MqttSuback;
import com.ibm.mqtt.MqttSubscribe;
import com.ibm.mqtt.MqttUnsuback;
import com.ibm.mqtt.MqttUnsubscribe;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Mqtt
implements MqttProcessor {
    private Class socketClass = null;
    private MqttAdapter socket = null;
    private DataInputStream stream_in = null;
    private DataOutputStream stream_out = null;
    private boolean haveWill = false;
    private boolean isSocketConnected = false;
    private boolean connected = false;
    private boolean connectionLost = false;
    private Object streamReadLock = new Object();
    private Object streamWriteLock = new Object();
    private int curMsgId = 0;
    private int keepAlivePeriod;
    private boolean topicNameCompression = false;
    private Hashtable outMsgIdsAllocated = new Hashtable();
    protected String connection;
    public static final short CONNECT = 1;
    public static final short CONNACK = 2;
    public static final short PUBLISH = 3;
    public static final short PUBACK = 4;
    public static final short PUBREC = 5;
    public static final short PUBREL = 6;
    public static final short PUBCOMP = 7;
    public static final short SUBSCRIBE = 8;
    public static final short SUBACK = 9;
    public static final short UNSUBSCRIBE = 10;
    public static final short UNSUBACK = 11;
    public static final short PINGREQ = 12;
    public static final short PINGRESP = 13;
    public static final short DISCONNECT = 14;
    public static final String[] msgTypes = new String[]{null, "CONNECT", "CONNACK", "PUBLISH", "PUBACK", "PUBREC", "PUBREL", "PUBCOMP", "SUBSCRIBE", "SUBACK", "UNSUBSCRIBE", "UNSUBACK", "PINGREQ", "PINGRESP", "DISCONNECT"};
    protected MqttException registeredException = null;

    protected Mqtt() {
    }

    protected void initialise(String string, Class clazz) {
        this.connection = string;
        this.socketClass = clazz;
    }

    private MqttPacket decodePacket(byte[] byArray, int n, short s) throws MqttException {
        MqttPacket mqttPacket = null;
        if (this.isSocketConnected()) {
            switch (s) {
                case 12: {
                    mqttPacket = new MqttPingreq(byArray, n);
                    break;
                }
                case 13: {
                    mqttPacket = new MqttPingresp(byArray, n);
                    break;
                }
                case 3: {
                    mqttPacket = new MqttPublish(byArray, n);
                    break;
                }
                case 4: {
                    mqttPacket = new MqttPuback(byArray, n);
                    break;
                }
                case 5: {
                    mqttPacket = new MqttPubrec(byArray, n);
                    break;
                }
                case 6: {
                    mqttPacket = new MqttPubrel(byArray, n);
                    break;
                }
                case 7: {
                    mqttPacket = new MqttPubcomp(byArray, n);
                    break;
                }
                case 8: {
                    mqttPacket = new MqttSubscribe(byArray, n);
                    break;
                }
                case 9: {
                    mqttPacket = new MqttSuback(byArray, n);
                    break;
                }
                case 10: {
                    mqttPacket = new MqttUnsubscribe(byArray, n);
                    break;
                }
                case 11: {
                    mqttPacket = new MqttUnsuback(byArray, n);
                    break;
                }
                case 14: {
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    mqttPacket = new MqttConnack(byArray, n);
                    break;
                }
                default: {
                    throw new MqttException("Mqtt: Unknown message type: " + s);
                }
            }
        }
        return mqttPacket;
    }

    protected int getKeepAlivePeriod() {
        return this.keepAlivePeriod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isSocketConnected() {
        Object object = this.streamWriteLock;
        synchronized (object) {
            return this.isSocketConnected;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSocketState(boolean bl) {
        Object object = this.streamWriteLock;
        synchronized (object) {
            this.isSocketConnected = bl;
        }
    }

    protected boolean hasKeepAlive() {
        return this.keepAlivePeriod > 0;
    }

    protected boolean hasWill() {
        return this.haveWill;
    }

    protected void initialiseOutMsgIds(Vector vector) {
        this.outMsgIdsAllocated.clear();
        this.curMsgId = 1;
        if (vector != null) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Integer n = (Integer)enumeration.nextElement();
                this.outMsgIdsAllocated.put(n, n);
            }
        }
    }

    protected int nextMsgId() throws MqttException {
        if (this.outMsgIdsAllocated.size() == 65535) {
            throw new MqttException("All available msgIds in use:65535");
        }
        boolean bl = false;
        while (!bl) {
            this.curMsgId = this.curMsgId < 65535 ? ++this.curMsgId : 1;
            Integer n = new Integer(this.curMsgId);
            if (this.outMsgIdsAllocated.contains(n)) continue;
            this.outMsgIdsAllocated.put(n, n);
            bl = true;
        }
        return this.curMsgId;
    }

    protected void releaseMsgId(int n) {
        this.outMsgIdsAllocated.remove(new Integer(n));
    }

    public synchronized boolean isConnected() {
        return this.connected;
    }

    public boolean supportTopicNameCompression() {
        return this.topicNameCompression;
    }

    protected void pingOut() throws MqttException {
        MqttPingreq mqttPingreq = new MqttPingreq();
        this.writePacket(mqttPingreq);
    }

    protected void process() throws Exception {
        MqttPacket mqttPacket = this.readPacket();
        if (mqttPacket != null) {
            mqttPacket.process(this);
        } else {
            System.out.println("Mqtt: Read a null packet from the socket");
        }
    }

    public void process(MqttConnack mqttConnack) {
        if (mqttConnack.returnCode == 0) {
            this.topicNameCompression = mqttConnack.topicNameCompression;
            this.setConnectionState(true);
        } else if (mqttConnack.returnCode == 1) {
            this.setConnectionState(false);
        } else if (mqttConnack.returnCode == 2) {
            this.setConnectionState(false);
        } else if (mqttConnack.returnCode == 3) {
            this.setConnectionState(false);
        }
        if (mqttConnack.returnCode != 0) {
            this.tcpipDisconnect(false);
        }
    }

    public void process(MqttPingreq mqttPingreq) {
        try {
            this.writePacket(new MqttPingresp());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void process(MqttConnect mqttConnect) {
    }

    public void process(MqttDisconnect mqttDisconnect) {
    }

    public void process(MqttSubscribe mqttSubscribe) {
    }

    public void process(MqttUnsubscribe mqttUnsubscribe) {
    }

    public void process(MqttPingresp mqttPingresp) {
    }

    public void process(MqttPublish mqttPublish) {
    }

    public void process(MqttPuback mqttPuback) {
    }

    public void process(MqttPubrec mqttPubrec) {
    }

    public void process(MqttPubrel mqttPubrel) {
    }

    public void process(MqttPubcomp mqttPubcomp) {
    }

    public void process(MqttSuback mqttSuback) {
    }

    public void process(MqttUnsuback mqttUnsuback) {
    }

    protected final MqttPublish genPublishPacket(int n, int n2, String string, byte[] byArray, boolean bl, boolean bl2) {
        MqttPublish mqttPublish = new MqttPublish();
        mqttPublish.setMsgId(n);
        mqttPublish.setQos(n2);
        mqttPublish.topicName = string;
        mqttPublish.setPayload(byArray);
        mqttPublish.setDup(bl2);
        mqttPublish.setRetain(bl);
        if (this.topicNameCompression) {
            mqttPublish.compressTopic();
        }
        return mqttPublish;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final MqttPacket readPacket() throws MqttException, InterruptedIOException, IOException {
        byte[] byArray = new byte[5];
        byte[] byArray2 = null;
        int n = 0;
        int n2 = 1;
        int n3 = 1;
        short s = 0;
        Object object = this.streamReadLock;
        synchronized (object) {
            byte by;
            try {
                n = this.stream_in.read(byArray, 0, 1);
            }
            catch (IOException iOException) {
                MQeTrace.trace(this, (short)-30033, 0x200000L, iOException.getMessage());
                throw iOException;
            }
            if (n < 0) {
                throw new EOFException("DataInputStream.read returned -1");
            }
            int n4 = 0;
            do {
                byArray[n3] = by = (byte)this.stream_in.read();
                n4 += (by & 0x7F) * n2;
                n2 *= 128;
                ++n3;
            } while ((by & 0x80) != 0);
            byArray2 = new byte[n4 + n3];
            for (int i = 0; i < n3; ++i) {
                byArray2[i] = byArray[i];
            }
            MQeTrace.trace(this, (short)-30035, 0x200000L, Integer.toString(n3), Integer.toString(n4));
            if (n4 > 0) {
                this.stream_in.readFully(byArray2, n3, n4);
            }
            s = (short)(byArray2[0] >>> 4 & 0xF);
        }
        return this.decodePacket(byArray2, n3, s);
    }

    protected synchronized void setConnectionState(boolean bl) {
        this.connected = bl;
    }

    protected void setKeepAlive(int n) {
        this.keepAlivePeriod = n;
    }

    protected void subscribeOut(int n, String[] stringArray, byte[] byArray, boolean bl) throws Exception {
    }

    protected void unsubscribeOut(int n, String[] stringArray, boolean bl) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tcpipConnect(MqttConnect mqttConnect) throws IOException, Exception {
        Object object = this.streamWriteLock;
        synchronized (object) {
            this.tcpipDisconnect(true);
            try {
                this.socket = (MqttAdapter)this.socketClass.newInstance();
                this.socket.setConnection(this.connection, mqttConnect.KeepAlive);
                this.setSocketState(true);
            }
            catch (IOException iOException) {
                this.tcpipDisconnect(true);
                throw iOException;
            }
            catch (Exception exception) {
                this.tcpipDisconnect(true);
                throw exception;
            }
            this.stream_in = new DataInputStream(this.socket.getInputStream());
            this.stream_out = new DataOutputStream(this.socket.getOutputStream());
            this.writePacket(mqttConnect);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tcpipDisconnect(boolean bl) {
        Object object = this.streamWriteLock;
        synchronized (object) {
            if (this.stream_out != null) {
                try {
                    this.socket.closeOutputStream();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.stream_out = null;
            }
            if (bl) {
                this.setSocketState(false);
                if (this.stream_in != null) {
                    try {
                        this.socket.closeInputStream();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    this.stream_in = null;
                }
                if (this.socket != null) {
                    try {
                        this.socket.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    this.socket = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void writePacket(MqttPacket mqttPacket) throws MqttException {
        Object object = this.streamWriteLock;
        synchronized (object) {
            if (this.stream_out != null) {
                try {
                    byte[] byArray = mqttPacket.getPayload();
                    byte[] byArray2 = mqttPacket.toBytes();
                    mqttPacket.setDup(true);
                    this.stream_out.write(byArray2);
                    if (byArray != null) {
                        this.stream_out.write(byArray);
                    }
                    this.stream_out.flush();
                    byArray = null;
                }
                catch (IOException iOException) {
                    MQeTrace.trace(this, (short)-30034, 0x200000L, iOException.getMessage());
                    this.tcpipDisconnect(true);
                    throw new MqttException(iOException);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    this.tcpipDisconnect(true);
                    throw new MqttException(exception);
                }
            } else {
                throw new MqttNotConnectedException();
            }
        }
    }

    protected synchronized boolean isConnectionLost() {
        return this.connectionLost;
    }

    protected synchronized void setConnectionLost(boolean bl) {
        this.connectionLost = bl;
    }

    protected void setRegisteredThrowable(Throwable throwable) {
        this.registeredException = throwable == null || throwable instanceof MqttException ? (MqttException)throwable : new MqttException(throwable);
        this.setConnectionState(false);
        this.tcpipDisconnect(true);
        this.setConnectionLost(true);
    }
}

