/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mqtt;

import com.ibm.mqtt.MqttEnumList;
import com.ibm.mqtt.MqttListItem;
import java.util.Enumeration;

public class MqttHashTable {
    private static final int INITIAL_CAPACITY = 101;
    private static final int LOAD_FACTOR_NUMERATOR = 3;
    private static final int LOAD_FACTOR_DENOMINATOR = 4;
    private static int m_init_capacity;
    public int m_capacity;
    private int m_ceiling;
    private int size = 0;
    public MqttListItem[] hashTable;
    private MqttListItem recycle_bin;
    private int recycle_length = 0;

    public MqttHashTable() {
        this(101);
    }

    public MqttHashTable(int n) {
        m_init_capacity = this.m_capacity = this.findPower(n);
        this.m_ceiling = this.m_capacity * 3 / 4;
        this.hashTable = new MqttListItem[this.m_capacity];
    }

    public void clear() {
        for (int i = 0; i < this.m_capacity; ++i) {
            this.hashTable[i] = null;
        }
        this.size = 0;
    }

    public boolean contains(Object object) {
        for (int i = 0; i < this.m_capacity; ++i) {
            MqttListItem mqttListItem;
            MqttListItem mqttListItem2 = mqttListItem = this.hashTable[i];
            while (mqttListItem2 != null) {
                if (mqttListItem2.data.equals(object)) {
                    return true;
                }
                mqttListItem2 = mqttListItem2.next;
            }
        }
        return false;
    }

    public boolean containsKey(long l) {
        return this.get(l) != null;
    }

    public Enumeration elements() {
        return new MqttEnumList(this, false);
    }

    private int findPower(int n) {
        int n2 = 2;
        while ((n2 *= 2) < n) {
        }
        return n2;
    }

    public Object get(long l) {
        int n = (int)((l >>> 32 ^ l) & (long)(this.m_capacity - 1));
        MqttListItem mqttListItem = this.hashTable[n];
        mqttListItem = this.hashTable[n];
        while (mqttListItem != null) {
            if (mqttListItem.keysMatch(l)) {
                return mqttListItem.data;
            }
            mqttListItem = mqttListItem.next;
        }
        return null;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public Enumeration keys() {
        return new MqttEnumList(this, true);
    }

    public Object put(long l, Object object) {
        if (this.size > this.m_ceiling) {
            int n = this.m_capacity;
            this.m_capacity <<= 1;
            this.m_ceiling = this.m_capacity * 3 / 4;
            this.rehash(n);
            return this.put(l, object);
        }
        int n = (int)((l >>> 32 ^ l) & (long)(this.m_capacity - 1));
        MqttListItem mqttListItem = this.hashTable[n];
        if (mqttListItem == null) {
            this.hashTable[n] = this.recycleCreate(l, null, object);
            ++this.size;
            return null;
        }
        MqttListItem mqttListItem2 = mqttListItem;
        while (mqttListItem2 != null) {
            if (mqttListItem2.keysMatch(l)) {
                Object object2 = mqttListItem2.data;
                mqttListItem2.data = object;
                return object2;
            }
            mqttListItem2 = mqttListItem2.next;
        }
        this.hashTable[n] = this.recycleCreate(l, mqttListItem, object);
        ++this.size;
        return null;
    }

    private MqttListItem recycleCreate(long l, MqttListItem mqttListItem, Object object) {
        if (this.recycle_bin != null) {
            MqttListItem mqttListItem2 = this.recycle_bin;
            this.recycle_bin = this.recycle_bin.next;
            --this.recycle_length;
            mqttListItem2.key = l;
            mqttListItem2.next = mqttListItem;
            mqttListItem2.data = object;
            return mqttListItem2;
        }
        return new MqttListItem(l, mqttListItem, object);
    }

    private void rehash(int n) {
        MqttListItem[] mqttListItemArray = this.hashTable;
        MqttListItem[] mqttListItemArray2 = new MqttListItem[this.m_capacity];
        this.hashTable = mqttListItemArray2;
        for (int i = 0; i < n; ++i) {
            MqttListItem mqttListItem = mqttListItemArray[i];
            while (mqttListItem != null) {
                MqttListItem mqttListItem2 = mqttListItem;
                mqttListItem = mqttListItem.next;
                long l = mqttListItem2.key;
                int n2 = (int)((l >>> 32 ^ l) & (long)(this.m_capacity - 1));
                mqttListItem2.next = mqttListItemArray2[n2];
                mqttListItemArray2[n2] = mqttListItem2;
            }
        }
    }

    public Object remove(long l) {
        if (this.size < this.m_ceiling / 4 && this.size >= m_init_capacity << 1) {
            int n = this.m_capacity;
            this.m_capacity >>= 1;
            this.m_ceiling = this.m_capacity * 3 / 4;
            this.rehash(n);
            return this.remove(l);
        }
        int n = (int)((l >>> 32 ^ l) & (long)(this.m_capacity - 1));
        MqttListItem mqttListItem = null;
        MqttListItem mqttListItem2 = this.hashTable[n];
        while (mqttListItem2 != null) {
            if (mqttListItem2.keysMatch(l)) {
                if (mqttListItem == null) {
                    this.hashTable[n] = mqttListItem2.next;
                } else {
                    mqttListItem.next = mqttListItem2.next;
                }
                --this.size;
                if (this.recycle_length < this.size / 8) {
                    mqttListItem2.next = this.recycle_bin;
                    this.recycle_bin = mqttListItem2;
                    ++this.recycle_length;
                }
                return mqttListItem2.data;
            }
            mqttListItem = mqttListItem2;
            mqttListItem2 = mqttListItem2.next;
        }
        return null;
    }

    public int size() {
        return this.size;
    }

    public final void view() {
        for (int i = 0; i < this.m_capacity; ++i) {
            System.out.print("\nBucket " + i + ":");
            MqttListItem mqttListItem = this.hashTable[i];
            while (mqttListItem != null) {
                System.out.print(" " + mqttListItem.data.toString());
                mqttListItem = mqttListItem.next;
            }
        }
        System.out.println("\nSize = " + this.size + "\n");
    }
}

