/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mqtt;

import com.ibm.mqtt.MqttPacket;
import com.ibm.mqtt.MqttProcessor;
import com.ibm.mqtt.MqttUtils;
import java.util.Vector;

public class MqttSubscribe
extends MqttPacket {
    public String[] topics;
    public byte[] topicsQoS;

    public MqttSubscribe() {
        this.setMsgType((short)8);
    }

    public MqttSubscribe(byte[] byArray, int n) {
        super(byArray);
        this.setMsgType((short)8);
        this.setMsgId(MqttUtils.toShort(byArray, n));
        Vector vector = MqttUtils.getTopicsWithQoS(MqttUtils.SliceByteArray(byArray, n + 2, byArray.length - (n + 2)));
        int n2 = vector.size();
        this.topicsQoS = new byte[n2];
        this.topics = new String[n2];
        for (int i = 0; i < n2; ++i) {
            String string = vector.elementAt(i).toString();
            this.topics[i] = string.substring(0, string.length() - 1);
            char c = string.charAt(string.length() - 1);
            this.topicsQoS[i] = (byte)Character.digit(c, 10);
        }
    }

    public void compressTopic() {
    }

    public void process(MqttProcessor mqttProcessor) {
        mqttProcessor.process(this);
    }

    public byte[] toBytes() {
        this.message = new byte[3];
        this.message[0] = super.toBytes()[0];
        int n = this.getMsgId();
        this.message[1] = (byte)(n / 256);
        this.message[2] = (byte)(n % 256);
        int n2 = 3;
        for (int i = 0; i < this.topics.length; ++i) {
            byte[] byArray = MqttUtils.StringToUTF(this.topics[i]);
            this.message = MqttUtils.concatArray(MqttUtils.concatArray(this.message, byArray), 0, this.message.length + byArray.length, this.topicsQoS, i, 1);
        }
        this.createMsgLength();
        return this.message;
    }

    private void uncompressTopic() {
    }
}

