/*
 * Decompiled with CFR 0.152.
 */
package me.pushy.sdk;

import android.content.Context;
import android.content.SharedPreferences;
import me.pushy.sdk.exceptions.PushyException;
import me.pushy.sdk.exceptions.PushyJsonParseException;
import me.pushy.sdk.exceptions.PushyRegistrationException;
import me.pushy.sdk.format.PushyStringUtils;
import me.pushy.sdk.json.PushyRegistrationRequest;
import me.pushy.sdk.json.PushyRegistrationResponse;
import me.pushy.sdk.json.PushySingleton;
import me.pushy.sdk.manager.PushyServiceManager;
import me.pushy.sdk.networking.PushyHTTP;
import me.pushy.sdk.permissions.PushyPermissionVerification;
import me.pushy.sdk.persistence.PushyPersistence;

public class Pushy {
    public static void listen(Context context) {
        PushyServiceManager.startSocketService(context);
    }

    public static void togglePermissionVerification(boolean value, Context context) {
        SharedPreferences preferences = PushySingleton.getSettings(context);
        SharedPreferences.Editor editor = preferences.edit();
        editor.putBoolean("pushyPermissionVerification", value);
        editor.commit();
    }

    public static void setHeartbeatInterval(long interval, Context context) {
        SharedPreferences preferences = PushySingleton.getSettings(context);
        SharedPreferences.Editor editor = preferences.edit();
        editor.putLong("pushyHeartbeatInterval", interval);
        editor.commit();
    }

    public static boolean isRegistered(Context context) {
        return PushyPersistence.getToken(context) != null;
    }

    public static String register(Context context) throws PushyException {
        PushyRegistrationResponse response;
        String json;
        Object register;
        PushyPermissionVerification.verifyManifestPermissions(context);
        String previousToken = PushyPersistence.getToken(context);
        if (previousToken != null) {
            Pushy.listen(context);
            PushyPersistence.saveToken(previousToken, context);
            return previousToken;
        }
        try {
            register = new PushyRegistrationRequest();
            ((PushyRegistrationRequest)register).app = context.getPackageName();
            json = PushySingleton.getJackson().writeValueAsString(register);
        }
        catch (Exception exc) {
            throw new PushyJsonParseException(exc.getMessage());
        }
        register = PushyHTTP.post("https://api.pushy.me/register", json);
        try {
            response = (PushyRegistrationResponse)PushySingleton.getJackson().readValue((String)register, PushyRegistrationResponse.class);
        }
        catch (Exception exc) {
            throw new PushyJsonParseException(exc.getMessage());
        }
        if (!PushyStringUtils.stringIsNullOrEmpty(response.error)) {
            throw new PushyRegistrationException("Registration failed: " + response.error);
        }
        if (response.token == null) {
            throw new PushyRegistrationException("Registration failed, please try again later.");
        }
        PushyPersistence.saveToken(response.token, context);
        Pushy.listen(context);
        return response.token;
    }
}

