/*
 * Decompiled with CFR 0.152.
 */
package me.pushy.sdk.permissions;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Log;
import me.pushy.sdk.config.PushyPermissions;
import me.pushy.sdk.exceptions.PushyException;
import me.pushy.sdk.exceptions.PushyPermissionException;
import me.pushy.sdk.json.PushySingleton;

public class PushyPermissionVerification {
    public static void verifyManifestPermissions(Context context) throws PushyException {
        SharedPreferences preferences = PushySingleton.getSettings(context);
        boolean permissionEnforcement = preferences.getBoolean("pushyPermissionVerification", true);
        if (!permissionEnforcement) {
            Log.d((String)"Pushy", (String)"Warning: AndroidManifest permission verification disabled by developer");
        }
        for (String permission : PushyPermissions.REQUIRED_MANIFEST_PERMISSIONS) {
            if (context.checkCallingOrSelfPermission(permission) == 0) continue;
            String message = "Error: " + permission + " is missing from your AndroidManifest.xml.";
            if (permissionEnforcement) {
                throw new PushyPermissionException(message);
            }
            Log.e((String)"Pushy", (String)message);
        }
    }
}

