/*
 * Decompiled with CFR 0.152.
 */
package me.pushy.sdk.persistence;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Log;
import me.pushy.sdk.config.PushyStorage;
import me.pushy.sdk.io.PushyIO;
import me.pushy.sdk.json.PushySingleton;

public class PushyPersistence {
    public static String getToken(Context context) {
        String token = PushyPersistence.getTokenFromSharedPreferences(context);
        if (token == null) {
            try {
                if (PushyPersistence.isTokenPersistedInExternalStorage(context) && (token = PushyPersistence.getTokenFromExternalStorage(context)) != null) {
                    PushyPersistence.saveTokenInSharedPreferences(token, context);
                }
            }
            catch (Exception exc) {
                Log.d((String)"Pushy", (String)("Get token from external storage failed: " + exc.getMessage()), (Throwable)exc);
            }
        } else if (!PushyPersistence.isTokenPersistedInExternalStorage(context)) {
            try {
                PushyPersistence.saveTokenInExternalStorage(token, context);
            }
            catch (Exception exc) {
                Log.d((String)"Pushy", (String)("Persisting the token to external storage failed: " + exc.getMessage()), (Throwable)exc);
            }
        }
        return token;
    }

    public static void saveToken(String token, Context context) {
        PushyPersistence.saveTokenInSharedPreferences(token, context);
        try {
            PushyPersistence.saveTokenInExternalStorage(token, context);
        }
        catch (Exception exc) {
            Log.d((String)"Pushy", (String)("Saving token to external storage failed: " + exc.getMessage()), (Throwable)exc);
        }
    }

    private static String getTokenFromExternalStorage(Context context) throws Exception {
        String path = PushyPersistence.getTokenExternalStoragePath(context);
        return PushyIO.readFromFile(path);
    }

    public static boolean isTokenPersistedInExternalStorage(Context context) {
        String path = PushyPersistence.getTokenExternalStoragePath(context);
        return PushyIO.fileExists(path);
    }

    public static String getTokenExternalStoragePath(Context context) {
        return PushyStorage.EXTERNAL_STORAGE_DIRECTORY + context.getPackageName() + "/" + "registration.id";
    }

    public static String getTokenFromSharedPreferences(Context context) {
        SharedPreferences preferences = PushySingleton.getSettings(context);
        return preferences.getString("pushyToken", null);
    }

    public static void saveTokenInSharedPreferences(String token, Context context) {
        SharedPreferences preferences = PushySingleton.getSettings(context);
        SharedPreferences.Editor editor = preferences.edit();
        editor.putString("pushyToken", token);
        editor.commit();
    }

    public static void saveTokenInExternalStorage(String token, Context context) throws Exception {
        String path = PushyPersistence.getTokenExternalStoragePath(context);
        PushyIO.writeToFile(path, token);
    }
}

