/*
 * Decompiled with CFR 0.152.
 */
package me.pushy.sdk.services;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiManager;
import android.os.AsyncTask;
import android.os.Binder;
import android.os.IBinder;
import android.os.SystemClock;
import android.util.Log;
import com.ibm.mqtt.IMqttClient;
import com.ibm.mqtt.MqttClient;
import com.ibm.mqtt.MqttException;
import com.ibm.mqtt.MqttPersistence;
import com.ibm.mqtt.MqttPersistenceException;
import com.ibm.mqtt.MqttSimpleCallback;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import me.pushy.sdk.format.PushyStringUtils;
import me.pushy.sdk.json.PushySingleton;
import me.pushy.sdk.networking.PushyHTTP;
import me.pushy.sdk.persistence.PushyPersistence;

public class PushySocketService
extends Service {
    public static final String ACTION_START = "Pushy.START";
    public static final String ACTION_RECONNECT = "Pushy.RECONNECT";
    public static final String ACTION_KEEP_ALIVE = "Pushy.KEEP_ALIVE";
    public static final String ACTION_BACKGROUND = "Pushy.BACKGROUND";
    private static final long INITIAL_RETRY_INTERVAL = 500L;
    private static final long MAXIMUM_RETRY_INTERVAL = 60000L;
    private static MqttPersistence MQTT_PERSISTENCE = null;
    private static boolean MQTT_CLEAN_START = true;
    private static short MQTT_KEEP_ALIVE = (short)301;
    private static int MQTT_QUALITY_OF_SERVICE = 1;
    private static boolean MQTT_RETAINED_PUBLISH = false;
    private final IBinder mBinder = new LocalBinder();
    private WifiManager mWifiManager;
    private AlarmManager mAlarmManager;
    private ConnectivityManager mConnectivityManager;
    private WifiManager.WifiLock mWifiWakeLock;
    private MqttPushConnection mConnection;
    private long mRetryInterval = 500L;
    private BroadcastReceiver mConnectivityListener = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            boolean isNetworkAvailable = PushySocketService.this.isNetworkAvailable();
            Log.d((String)"Pushy", (String)("Internet connected: " + isNetworkAvailable));
            if (isNetworkAvailable) {
                if (PushySocketService.this.getConnectedNetwork() == 1 && PushySocketService.this.mConnection.isConnected() && !PushySocketService.this.mConnection.isConnecting() && PushySocketService.this.mConnection.getNetwork() == 0) {
                    Log.d((String)"Pushy", (String)"Reconnecting via wifi");
                    new ConnectAsync().execute(new Integer[0]);
                    return;
                }
                PushySocketService.this.attemptReconnect();
            } else {
                PushySocketService.this.cancelReconnect();
            }
        }
    };

    public static void performAction(Context context, String action) {
        Intent actionIntent = new Intent(context, PushySocketService.class);
        actionIntent.setAction(action);
        context.startService(actionIntent);
    }

    public void onCreate() {
        super.onCreate();
        Log.d((String)"Pushy", (String)"Creating service");
        this.mWifiManager = (WifiManager)this.getSystemService("wifi");
        this.mAlarmManager = (AlarmManager)this.getSystemService("alarm");
        this.mConnectivityManager = (ConnectivityManager)this.getSystemService("connectivity");
        this.mConnection = new MqttPushConnection();
        this.handleCrashedService();
        this.start();
        this.registerReceiver(this.mConnectivityListener, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
    }

    public void onTaskRemoved(Intent rootIntent) {
        Log.d((String)"Pushy", (String)"Task removed, attempting restart in 3 seconds");
        Intent restartService = new Intent(this.getApplicationContext(), ((Object)((Object)this)).getClass());
        restartService.setPackage(this.getPackageName());
        PendingIntent restartServiceIntent = PendingIntent.getService((Context)this.getApplicationContext(), (int)1, (Intent)restartService, (int)0x40000000);
        this.mAlarmManager.set(3, SystemClock.elapsedRealtime() + 3000L, restartServiceIntent);
    }

    private void handleCrashedService() {
        this.stopKeepAliveTimerAndWifiLock();
        this.cancelReconnect();
    }

    public void onDestroy() {
        Log.d((String)"Pushy", (String)"Service destroyed");
        this.stop();
        super.onDestroy();
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        Log.d((String)"Pushy", (String)("Service started with intent: " + intent));
        if (intent == null || intent.getAction() == null) {
            this.start();
        } else if (intent.getAction().equals(ACTION_START)) {
            this.start();
        } else if (intent.getAction().equals(ACTION_KEEP_ALIVE)) {
            this.sendKeepAlive();
        } else if (intent.getAction().equals(ACTION_RECONNECT)) {
            this.attemptReconnect();
        } else if (intent.getAction().equals(ACTION_BACKGROUND)) {
            this.stopForeground();
        }
        return 1;
    }

    public IBinder onBind(Intent intent) {
        return this.mBinder;
    }

    private void start() {
        if (!this.isNetworkAvailable()) {
            return;
        }
        if (this.mConnection.isConnecting() || this.mConnection.isConnected()) {
            Log.d((String)"Pushy", (String)"Attempt to start connection that is already active");
            return;
        }
        new ConnectAsync().execute(new Integer[0]);
    }

    void stopForeground() {
        this.stopForeground(true);
    }

    private void stop() {
        this.stopForeground();
        this.cancelReconnect();
        this.stopKeepAliveTimerAndWifiLock();
        this.unregisterReceiver(this.mConnectivityListener);
    }

    private String getClientID() {
        return PushyPersistence.getToken((Context)this);
    }

    private void sendKeepAlive() {
        if (this.mConnection.isConnected()) {
            new SendKeepAliveAsync().execute(new Integer[0]);
        }
    }

    private void startKeepAliveTimerAndWifiLock() {
        long interval = MQTT_KEEP_ALIVE * 1000;
        PendingIntent pendingIntent = this.getAlarmPendingIntent(ACTION_KEEP_ALIVE);
        this.mAlarmManager.setRepeating(0, System.currentTimeMillis() + interval, interval, pendingIntent);
        this.acquireWifiLock();
    }

    PendingIntent getAlarmPendingIntent(String action) {
        Intent keepAliveIntent = new Intent();
        keepAliveIntent.setClass((Context)this, PushySocketService.class);
        keepAliveIntent.setAction(action);
        return PendingIntent.getService((Context)this, (int)0, (Intent)keepAliveIntent, (int)0);
    }

    private void stopKeepAliveTimerAndWifiLock() {
        PendingIntent keepAliveIntent = this.getAlarmPendingIntent(ACTION_KEEP_ALIVE);
        this.mAlarmManager.cancel(keepAliveIntent);
        this.releaseWifiLock();
    }

    public void scheduleReconnect() {
        long now = System.currentTimeMillis();
        if (this.mRetryInterval >= 60000L) {
            this.mRetryInterval = 500L;
        }
        this.mRetryInterval = Math.min(this.mRetryInterval * 2L, 60000L);
        Log.d((String)"Pushy", (String)("Reconnecting in " + this.mRetryInterval + "ms."));
        PendingIntent keepAliveIntent = this.getAlarmPendingIntent(ACTION_RECONNECT);
        this.mAlarmManager.set(0, now + this.mRetryInterval, keepAliveIntent);
    }

    public void cancelReconnect() {
        PendingIntent reconnectIntent = this.getAlarmPendingIntent(ACTION_RECONNECT);
        this.mAlarmManager.cancel(reconnectIntent);
    }

    private void attemptReconnect() {
        if (!this.isNetworkAvailable()) {
            return;
        }
        if (this.mConnection.isConnected() || this.mConnection.isConnecting()) {
            return;
        }
        Log.d((String)"Pushy", (String)"Reconnecting...");
        new ConnectAsync().execute(new Integer[0]);
    }

    private void releaseWifiLock() {
        if (this.mWifiWakeLock == null) {
            return;
        }
        try {
            this.mWifiWakeLock.release();
        }
        catch (Exception exc) {
            Log.d((String)"Pushy", (String)"Wifi lock release failed");
        }
        this.mWifiWakeLock = null;
        Log.d((String)"Pushy", (String)"Wifi lock released");
    }

    private void acquireWifiLock() {
        if (this.mWifiWakeLock != null) {
            return;
        }
        this.mWifiWakeLock = this.mWifiManager.createWifiLock(1, "Pushy");
        this.mWifiWakeLock.acquire();
        Log.d((String)"Pushy", (String)"WifiLock acquired");
    }

    private boolean isNetworkAvailable() {
        NetworkInfo activeNetworkInfo = this.mConnectivityManager.getActiveNetworkInfo();
        return activeNetworkInfo != null && activeNetworkInfo.isAvailable() && activeNetworkInfo.isConnected();
    }

    private int getConnectedNetwork() {
        NetworkInfo wifi = this.mConnectivityManager.getNetworkInfo(1);
        NetworkInfo mobile = this.mConnectivityManager.getNetworkInfo(0);
        if (wifi != null && wifi.isConnected()) {
            return 1;
        }
        if (mobile != null && mobile.isConnected()) {
            return 0;
        }
        return -1;
    }

    public class LocalBinder
    extends Binder {
        public PushySocketService getService() {
            return PushySocketService.this;
        }
    }

    private class MqttPushConnection
    implements MqttSimpleCallback {
        int mNetwork;
        boolean mIsConnecting;
        IMqttClient mClient;

        public MqttPushConnection() {
            try {
                this.mClient = MqttClient.createMqttClient("tcp://https://mqtt.pushy.me@1883", MQTT_PERSISTENCE);
            }
            catch (Exception exc) {
                Log.d((String)"Pushy", (String)("Connection initialization error: " + exc.toString()));
            }
        }

        public void disconnectExistingClient() {
            if (this.mClient != null && this.mClient.isConnected()) {
                try {
                    this.mClient.disconnect();
                }
                catch (MqttPersistenceException mqttPersistenceException) {
                    // empty catch block
                }
            }
        }

        public void connect() throws Exception {
            this.disconnectExistingClient();
            String ip = "https://mqtt.pushy.me";
            if (ip.startsWith("http")) {
                ip = PushyHTTP.get(ip + "/ip");
            }
            if (PushyStringUtils.stringIsNullOrEmpty(ip)) {
                throw new MqttException("Failed to retrieve MQTT broker IP.");
            }
            Log.d((String)"Pushy", (String)("Broker IP: " + ip));
            this.mClient = MqttClient.createMqttClient("tcp://" + ip + "@" + 1883, MQTT_PERSISTENCE);
            this.mClient.registerSimpleHandler(this);
            this.mNetwork = PushySocketService.this.getConnectedNetwork();
            this.mClient.connect(PushySocketService.this.getClientID(), MQTT_CLEAN_START, MQTT_KEEP_ALIVE);
            Log.d((String)"Pushy", (String)("Connected (client ID: " + PushySocketService.this.getClientID() + ")"));
            PushySocketService.this.startKeepAliveTimerAndWifiLock();
            PushySocketService.this.mRetryInterval = 500L;
        }

        private void publish(String topic, String payload) throws Exception {
            if (this.mClient == null || !this.mClient.isConnected()) {
                throw new Exception("Publish failed: not connected");
            }
            this.mClient.publish(topic, payload.getBytes(), MQTT_QUALITY_OF_SERVICE, MQTT_RETAINED_PUBLISH);
        }

        public void sendKeepAlive() throws Exception {
            this.publish("keepalive", "");
        }

        public boolean isConnected() {
            return this.mClient.isConnected();
        }

        public int getNetwork() {
            return this.mNetwork;
        }

        public boolean isConnecting() {
            return this.mIsConnecting;
        }

        public void setConnecting(boolean value) {
            this.mIsConnecting = value;
        }

        @Override
        public void connectionLost() throws Exception {
            Log.d((String)"Pushy", (String)"Connection lost");
            PushySocketService.this.stopKeepAliveTimerAndWifiLock();
            PushySocketService.this.attemptReconnect();
        }

        void parsePayload(byte[] payload, Intent intent) {
            try {
                String data = new String(payload);
                Map map = (Map)PushySingleton.getJackson().readValue(data, Map.class);
                for (Map.Entry entry : map.entrySet()) {
                    if (entry.getValue() == null) continue;
                    if (entry.getValue().getClass() == String.class) {
                        intent.putExtra((String)entry.getKey(), (String)entry.getValue());
                    }
                    if (entry.getValue().getClass() == Boolean.class) {
                        intent.putExtra((String)entry.getKey(), (Serializable)((Boolean)entry.getValue()));
                    }
                    if (entry.getValue().getClass() == Integer.class) {
                        intent.putExtra((String)entry.getKey(), (Serializable)((Integer)entry.getValue()));
                    }
                    if (entry.getValue().getClass() == Long.class) {
                        intent.putExtra((String)entry.getKey(), (Serializable)((Long)entry.getValue()));
                    }
                    if (entry.getValue().getClass() == Double.class || entry.getValue().getClass() == Float.class) {
                        intent.putExtra((String)entry.getKey(), (Serializable)((Double)entry.getValue()));
                    }
                    if (entry.getValue().getClass() != ArrayList.class) continue;
                    intent.putExtra((String)entry.getKey(), (Serializable)((ArrayList)entry.getValue()).toArray());
                }
            }
            catch (Exception exc) {
                Log.e((String)"Pushy", (String)exc.getMessage(), (Throwable)exc);
            }
        }

        @Override
        public void publishArrived(String topic, byte[] payload, int qos, boolean retained) {
            Log.d((String)"Pushy", (String)("Received push for package " + topic));
            Intent pushBroadcast = new Intent();
            this.parsePayload(payload, pushBroadcast);
            pushBroadcast.setPackage(topic);
            pushBroadcast.setAction("pushy.me");
            PushySocketService.this.sendBroadcast(pushBroadcast);
        }
    }

    public class SendKeepAliveAsync
    extends AsyncTask<Integer, String, Integer> {
        protected Integer doInBackground(Integer ... parameter) {
            if (!PushySocketService.this.mConnection.isConnected()) {
                return 0;
            }
            Log.d((String)"Pushy", (String)"Sending keep alive");
            try {
                PushySocketService.this.mConnection.sendKeepAlive();
            }
            catch (Exception e) {
                Log.d((String)"Pushy", (String)("Keep alive error: " + e.toString()), (Throwable)e);
            }
            return 0;
        }
    }

    public class ConnectAsync
    extends AsyncTask<Integer, String, Integer> {
        public ConnectAsync() {
            PushySocketService.this.mConnection.setConnecting(true);
        }

        protected Integer doInBackground(Integer ... parameter) {
            block2: {
                Log.d((String)"Pushy", (String)"Connecting...");
                try {
                    PushySocketService.this.mConnection.connect();
                }
                catch (Exception e) {
                    Log.d((String)"Pushy", (String)("Connect exception: " + e.toString()));
                    if (!PushySocketService.this.isNetworkAvailable()) break block2;
                    PushySocketService.this.scheduleReconnect();
                }
            }
            PushySocketService.this.mConnection.setConnecting(false);
            return 0;
        }
    }
}

