/*
 * Decompiled with CFR 0.152.
 */
package me.pushy.sdk.util;

import android.content.Context;
import java.io.IOException;
import me.pushy.sdk.lib.jackson.core.JsonProcessingException;
import me.pushy.sdk.model.PushyDeviceCredentials;
import me.pushy.sdk.model.api.PushyAuthRequest;
import me.pushy.sdk.model.api.PushyAuthResponse;
import me.pushy.sdk.util.PushyEndpoints;
import me.pushy.sdk.util.PushyFirebase;
import me.pushy.sdk.util.PushyHTTP;
import me.pushy.sdk.util.PushyIO;
import me.pushy.sdk.util.PushyLogger;
import me.pushy.sdk.util.PushyPersistence;
import me.pushy.sdk.util.PushyPreferences;
import me.pushy.sdk.util.PushySingleton;
import me.pushy.sdk.util.PushyStringUtils;
import me.pushy.sdk.util.exceptions.PushyException;
import me.pushy.sdk.util.exceptions.PushyJsonParseException;

public class PushyAuthentication {
    public static PushyDeviceCredentials getDeviceCredentials(Context context) {
        PushyDeviceCredentials credentials = new PushyDeviceCredentials();
        credentials.token = PushyPreferences.getString(PushyPersistence.getEnvironmentPreferenceKey("pushyToken", context), null, context);
        credentials.authKey = PushyPreferences.getString(PushyPersistence.getEnvironmentPreferenceKey("pushyAuthKey", context), null, context);
        String tokenPath = PushyPersistence.getEnvironmentExternalStoragePath("registration.id", context);
        String authKeyPath = PushyPersistence.getEnvironmentExternalStoragePath("registration.key", context);
        if (credentials.token == null || credentials.authKey == null) {
            try {
                if (PushyIO.fileExists(tokenPath)) {
                    credentials.token = PushyIO.readFromFile(tokenPath, context);
                }
                if (PushyIO.fileExists(authKeyPath)) {
                    credentials.authKey = PushyIO.readFromFile(authKeyPath, context);
                }
                if (!PushyStringUtils.stringIsNullOrEmpty(credentials.token) && !PushyStringUtils.stringIsNullOrEmpty(credentials.authKey)) {
                    PushyAuthentication.saveDeviceCredentials(credentials, context);
                    if (PushyPreferences.getBoolean("pushyFCMEnabled", false, context)) {
                        PushyFirebase.register(context);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (credentials.token == null || credentials.authKey == null) {
            return null;
        }
        return credentials;
    }

    public static void clearDeviceCredentials(Context context) {
        PushyPreferences.remove(PushyPersistence.getEnvironmentPreferenceKey("pushyToken", context), context);
        PushyPreferences.remove(PushyPersistence.getEnvironmentPreferenceKey("pushyAuthKey", context), context);
    }

    public static void saveDeviceCredentials(PushyDeviceCredentials credentials, Context context) {
        PushyPreferences.saveString(PushyPersistence.getEnvironmentPreferenceKey("pushyToken", context), credentials.token, context);
        PushyPreferences.saveString(PushyPersistence.getEnvironmentPreferenceKey("pushyAuthKey", context), credentials.authKey, context);
    }

    public static boolean validateCredentials(PushyDeviceCredentials credentials, Context context) throws PushyException {
        PushyAuthResponse response;
        String json;
        if (credentials == null) {
            return false;
        }
        try {
            String appId = PushyPreferences.getString("pushyAppId", null, context);
            json = PushySingleton.getJackson().writeValueAsString(new PushyAuthRequest(credentials, appId, PushyPersistence.getAndroidId(context)));
        }
        catch (JsonProcessingException exc) {
            throw new PushyJsonParseException(exc.getMessage());
        }
        String jsonResponse = PushyHTTP.post(PushyEndpoints.getAPIEndpoint(context) + "/devices/auth", json, context);
        try {
            response = PushySingleton.getJackson().readValue(jsonResponse, PushyAuthResponse.class);
        }
        catch (IOException exc) {
            throw new PushyJsonParseException(exc.getMessage());
        }
        if (!PushyStringUtils.stringIsNullOrEmpty(response.error)) {
            PushyLogger.e("Device auth validation failed: " + response.error);
            return false;
        }
        return response.success;
    }
}

