/*
 * Decompiled with CFR 0.152.
 */
package me.pushy.sdk.services;

import android.app.AlarmManager;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.wifi.WifiManager;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.SystemClock;
import androidx.core.app.NotificationCompat;
import me.pushy.sdk.lib.paho.MqttSecurityException;
import me.pushy.sdk.util.PushyAuthentication;
import me.pushy.sdk.util.PushyLogger;
import me.pushy.sdk.util.PushyMqttConnection;
import me.pushy.sdk.util.PushyNetworking;
import me.pushy.sdk.util.PushyPreferences;
import me.pushy.sdk.util.PushyResources;
import me.pushy.sdk.util.exceptions.PushyFatalException;

public class PushySocketService
extends Service {
    private WifiManager mWifiManager;
    private AlarmManager mAlarmManager;
    private ConnectivityManager mConnectivityManager;
    private boolean mIsDestroyed;
    private static PushyMqttConnection mSocket;
    private long mRetryInterval = 500L;
    private static boolean mForegroundServiceEnabled;
    private static Notification mCustomForegroundNotification;
    public static final String ACTION_START = "Pushy.START";
    public static final String ACTION_RECONNECT = "Pushy.RECONNECT";
    public static final String ACTION_KEEP_ALIVE = "Pushy.KEEP_ALIVE";
    private BroadcastReceiver mConnectivityListener = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            if (PushyNetworking.isNetworkAvailable(PushySocketService.this.mConnectivityManager)) {
                if (!mSocket.isConnected() && !mSocket.isConnecting()) {
                    PushySocketService.this.reconnectAsync();
                } else if (mSocket.isConnected() && !mSocket.isConnecting() && PushyNetworking.getConnectedNetwork(PushySocketService.this.mConnectivityManager) == 1 && mSocket.getNetwork() == 0) {
                    new ReconnectWifiAsync().execute(new Integer[0]);
                }
            } else {
                PushyLogger.d("Internet disconnected");
                PushySocketService.this.cancelReconnect();
            }
            PushySocketService.this.updateForegroundServiceNotification();
        }
    };

    public void onCreate() {
        super.onCreate();
        PushyLogger.d("Creating service");
        if (PushySocketService.isForegroundServiceEnabled()) {
            this.startForeground(58137, this.getForegroundNotification());
        }
        this.mWifiManager = (WifiManager)this.getApplicationContext().getSystemService("wifi");
        this.mAlarmManager = (AlarmManager)this.getApplicationContext().getSystemService("alarm");
        this.mConnectivityManager = (ConnectivityManager)this.getApplicationContext().getSystemService("connectivity");
        mSocket = new PushyMqttConnection((Context)this, this.mWifiManager, this.mConnectivityManager, new ConnectionLostRunnable());
        this.handleCrashedService();
        this.start();
        this.registerReceiver(this.mConnectivityListener, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
    }

    public static void setForegroundNotification(Notification notification) {
        mCustomForegroundNotification = notification;
        PushySocketService.toggleForegroundService(true);
    }

    Notification getForegroundNotification() {
        int icon;
        String text;
        if (mCustomForegroundNotification != null) {
            return mCustomForegroundNotification;
        }
        PendingIntent launcherIntent = null;
        try {
            launcherIntent = PendingIntent.getActivity((Context)this, (int)0, (Intent)this.getPackageManager().getLaunchIntentForPackage(this.getPackageName()), (int)0x4000000);
        }
        catch (Exception exc) {
            PushyLogger.d("Failed to query for launcher activity");
        }
        String appName = this.getPackageManager().getApplicationLabel(this.getApplicationInfo()).toString();
        String title = PushyResources.getOptionalStringResource("pushy_foreground_service_title", appName, (Context)this);
        if (PushySocketService.isConnected()) {
            text = PushyResources.getOptionalStringResource("pushy_foreground_service_connected", "Connected to the notification service", (Context)this);
            icon = PushyResources.getOptionalResourceById("ic_pushy_foreground_service_connected", "drawable", 17301628, (Context)this);
        } else if (PushySocketService.isConnecting()) {
            text = PushyResources.getOptionalStringResource("pushy_foreground_service_connecting", "Connecting...", (Context)this);
            icon = PushyResources.getOptionalResourceById("ic_pushy_foreground_service_connecting", "drawable", 17301599, (Context)this);
        } else {
            text = PushyResources.getOptionalStringResource("pushy_foreground_service_disconnected", "Not connected to the notification service", (Context)this);
            icon = PushyResources.getOptionalResourceById("ic_pushy_foreground_service_disconnected", "drawable", 17301624, (Context)this);
        }
        int color = PushyResources.getOptionalColorResource("pushy_foreground_service_color", 0, (Context)this);
        if (Build.VERSION.SDK_INT >= 26) {
            NotificationChannel channel = new NotificationChannel("pushy_foreground_service", (CharSequence)(appName + " Notification Service"), 1);
            NotificationManager notificationManager = (NotificationManager)this.getSystemService(NotificationManager.class);
            notificationManager.createNotificationChannel(channel);
        }
        NotificationCompat.Builder builder = new NotificationCompat.Builder((Context)this, "pushy_foreground_service").setGroup("pushy_foreground_service").setContentTitle((CharSequence)title).setContentText((CharSequence)text).setSmallIcon(icon).setColor(color).setPriority(-1);
        if (launcherIntent != null) {
            builder.setContentIntent(launcherIntent);
        }
        return builder.build();
    }

    public static boolean isConnected() {
        return mSocket != null && mSocket.isConnected();
    }

    public static boolean isConnecting() {
        return mSocket != null && mSocket.isConnecting();
    }

    public static void toggleForegroundService(boolean value) {
        mForegroundServiceEnabled = value;
    }

    public static boolean isForegroundServiceEnabled() {
        return mForegroundServiceEnabled;
    }

    public void onTaskRemoved(Intent rootIntent) {
        PushyLogger.d("Task removed, attempting restart in 3 seconds");
        Intent restartService = new Intent(this.getApplicationContext(), ((Object)((Object)this)).getClass());
        restartService.setPackage(this.getPackageName());
        PendingIntent restartServiceIntent = PendingIntent.getService((Context)this.getApplicationContext(), (int)1, (Intent)restartService, (int)0x44000000);
        this.mAlarmManager.set(3, SystemClock.elapsedRealtime() + 3000L, restartServiceIntent);
    }

    private void handleCrashedService() {
        this.stopKeepAliveTimerAndWifiLock();
        this.cancelReconnect();
    }

    public void onDestroy() {
        PushyLogger.d("Service destroyed");
        this.mIsDestroyed = true;
        this.stop();
        if (PushySocketService.isForegroundServiceEnabled()) {
            this.stopForeground(true);
        }
        super.onDestroy();
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        if (PushySocketService.isForegroundServiceEnabled()) {
            this.startForeground(58137, this.getForegroundNotification());
        }
        if (intent == null || intent.getAction() == null) {
            this.start();
        } else if (intent.getAction().equals(ACTION_START)) {
            this.start();
        } else if (intent.getAction().equals(ACTION_KEEP_ALIVE)) {
            this.sendKeepAlive();
        } else if (intent.getAction().equals(ACTION_RECONNECT)) {
            this.reconnectAsync();
        }
        return 1;
    }

    private void start() {
        if (!PushyNetworking.isNetworkAvailable(this.mConnectivityManager)) {
            return;
        }
        if (mSocket.isConnecting() || mSocket.isConnected()) {
            return;
        }
        new ConnectAsync().execute(new Integer[0]);
    }

    private void stop() {
        this.cancelReconnect();
        this.stopKeepAliveTimerAndWifiLock();
        this.unregisterReceiver(this.mConnectivityListener);
        mSocket.disconnectExistingClientAsync();
    }

    private void sendKeepAlive() {
        if (mSocket.isConnected()) {
            new SendKeepAliveAsync().execute(new Integer[0]);
        }
    }

    private void startKeepAliveTimerAndWifiLock() {
        long interval = PushyMqttConnection.getKeepAliveInterval((Context)this) * 1000;
        PendingIntent pendingIntent = this.getAlarmPendingIntent(ACTION_KEEP_ALIVE);
        this.mAlarmManager.setRepeating(0, System.currentTimeMillis() + interval, interval, pendingIntent);
        mSocket.acquireWifiLock();
    }

    PendingIntent getAlarmPendingIntent(String action) {
        Intent keepAliveIntent = new Intent();
        keepAliveIntent.setClass((Context)this, PushySocketService.class);
        keepAliveIntent.setAction(action);
        return PendingIntent.getService((Context)this, (int)0, (Intent)keepAliveIntent, (int)0x4000000);
    }

    private void stopKeepAliveTimerAndWifiLock() {
        PendingIntent keepAliveIntent = this.getAlarmPendingIntent(ACTION_KEEP_ALIVE);
        this.mAlarmManager.cancel(keepAliveIntent);
        mSocket.releaseWifiLock();
    }

    public void scheduleReconnect() {
        long now = System.currentTimeMillis();
        if (this.mRetryInterval < 60000L) {
            this.mRetryInterval = Math.min(this.mRetryInterval * 2L, 60000L);
        }
        PushyLogger.d("Reconnecting in " + this.mRetryInterval + "ms.");
        PendingIntent keepAliveIntent = this.getAlarmPendingIntent(ACTION_RECONNECT);
        this.mAlarmManager.set(0, now + this.mRetryInterval, keepAliveIntent);
    }

    public void cancelReconnect() {
        PendingIntent reconnectIntent = this.getAlarmPendingIntent(ACTION_RECONNECT);
        this.mAlarmManager.cancel(reconnectIntent);
    }

    private void reconnectAsync() {
        if (this.mIsDestroyed) {
            PushyLogger.d("Not reconnecting (service destroyed)");
            return;
        }
        if (!PushyNetworking.isNetworkAvailable(this.mConnectivityManager)) {
            PushyLogger.d("Not reconnecting (network not available)");
            return;
        }
        if (mSocket.isConnecting()) {
            PushyLogger.d("Already reconnecting");
            return;
        }
        mSocket.disconnectExistingClientAsync();
        this.stopKeepAliveTimerAndWifiLock();
        PushyLogger.d("Reconnecting...");
        new ConnectAsync().execute(new Integer[0]);
    }

    public IBinder onBind(Intent intent) {
        return null;
    }

    void updateForegroundServiceNotification() {
        if (!PushySocketService.isForegroundServiceEnabled()) {
            return;
        }
        NotificationManager notificationManager = (NotificationManager)this.getSystemService("notification");
        notificationManager.notify(58137, this.getForegroundNotification());
    }

    public class SendKeepAliveAsync
    extends AsyncTask<Integer, String, Integer> {
        protected Integer doInBackground(Integer ... parameter) {
            if (!mSocket.isConnected()) {
                return 0;
            }
            PushyLogger.d("Sending keep alive");
            try {
                mSocket.sendKeepAlive();
                mSocket;
                PushyMqttConnection.onKeepAliveSuccess((Context)PushySocketService.this);
            }
            catch (Exception e) {
                PushyLogger.d("Keep alive error: " + e.toString(), e);
                mSocket;
                PushyMqttConnection.onKeepAliveFailed((Context)PushySocketService.this);
                mSocket.setConnecting(false);
                mSocket.disconnectExistingClientSync();
                new Handler(Looper.getMainLooper()).postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        if (!mSocket.isConnected() && !mSocket.isConnecting()) {
                            PushySocketService.this.reconnectAsync();
                        }
                    }
                }, 5000L);
            }
            return 0;
        }
    }

    public class ConnectAsync
    extends AsyncTask<Integer, String, Integer> {
        public ConnectAsync() {
            mSocket.setConnecting(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Integer doInBackground(Integer ... parameter) {
            if (!PushyPreferences.getBoolean("pushyNotificationsEnabled", true, PushySocketService.this.getApplicationContext())) {
                PushyLogger.d("Notifications have been disabled by the app");
                PushySocketService.this.cancelReconnect();
                PushySocketService.this.stopSelf();
                return 0;
            }
            if (mSocket.isConnected()) {
                PushyLogger.e("Trying to re-connect an already connected socket which would have caused an infinite loop");
                return 0;
            }
            PushyLogger.d("Connecting...");
            PushySocketService.this.updateForegroundServiceNotification();
            try {
                mSocket.connect();
                if (PushySocketService.this.mIsDestroyed) {
                    mSocket.disconnectExistingClientSync();
                    PushyLogger.d("Service destroyed, aborting connection");
                    Integer n = 0;
                    return n;
                }
                PushySocketService.this.mRetryInterval = 500L;
                PushySocketService.this.startKeepAliveTimerAndWifiLock();
                PushyLogger.d("Connected successfully (sending keep alive every " + PushyMqttConnection.getKeepAliveInterval((Context)PushySocketService.this) + " seconds)");
            }
            catch (Exception e) {
                PushyLogger.d("Connect exception: " + e.toString(), e);
                mSocket.disconnectExistingClientSync();
                if (e.getClass() == PushyFatalException.class) {
                    PushyLogger.d("Fatal error encountered, stopping service");
                    PushySocketService.this.stopSelf();
                    Integer n = 0;
                    return n;
                }
                if (e.getClass() == MqttSecurityException.class && ((MqttSecurityException)e).getReasonCode() == 5) {
                    PushyLogger.d("MQTT connect returned error code 5, clearing the device credentials");
                    PushyAuthentication.clearDeviceCredentials((Context)PushySocketService.this);
                    PushySocketService.this.stopSelf();
                    Integer n = 0;
                    return n;
                }
                if (PushyNetworking.isNetworkAvailable(PushySocketService.this.mConnectivityManager)) {
                    PushySocketService.this.scheduleReconnect();
                }
            }
            finally {
                mSocket.setConnecting(false);
                PushySocketService.this.updateForegroundServiceNotification();
            }
            return 0;
        }
    }

    public class ReconnectWifiAsync
    extends AsyncTask<Integer, String, Integer> {
        protected Integer doInBackground(Integer ... parameter) {
            if (!mSocket.isConnected()) {
                return 0;
            }
            PushyLogger.d("Reconnecting due to connectivity switch to Wi-Fi from cellular");
            mSocket.disconnectExistingClientSync();
            new Handler(Looper.getMainLooper()).postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (!mSocket.isConnected() && !mSocket.isConnecting()) {
                        PushySocketService.this.reconnectAsync();
                    }
                }
            }, 5000L);
            return 0;
        }
    }

    public class ConnectionLostRunnable
    implements Runnable {
        @Override
        public void run() {
            PushySocketService.this.updateForegroundServiceNotification();
            PushySocketService.this.reconnectAsync();
        }
    }
}

