/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mqtt;

import com.ibm.mqtt.MQeTrace;

public class MQe {
    public static final String copyright = "Licensed Materials - Property of IBM\nProduct number: 5765-E63\nCopyright IBM Corp. 1999,2002 All Rights Reserved.\nUS Government Users Restriced Rights - use, duplication or\ndisclosure restriced by GSA ADP Schedule Contract with IBM Corp.";
    public static final String sccsid = "mqe_java/source/com/ibm/mqe/MQe.java, MQeBase, la000 1.111";
    public static short[] version = new short[]{2, 0, 0, 2};
    private MQeTrace traceService = new MQeTrace();
    public static final char[] Hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static byte[] asciiToByte(String string) {
        if (string == null) {
            return null;
        }
        byte[] byArray = new byte[string.length()];
        char[] cArray = new char[string.length()];
        string.getChars(0, string.length(), cArray, 0);
        for (int i = 0; i < cArray.length; ++i) {
            byArray[i] = (byte)cArray[i];
        }
        return byArray;
    }

    public static String byteToAscii(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        char[] cArray = new char[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            cArray[i] = (char)(byArray[i] & 0xFF);
        }
        return new String(cArray);
    }

    public static String byteToHex(byte[] byArray) {
        return MQe.byteToHex(byArray, 0, byArray.length);
    }

    public static String byteToHex(byte[] byArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer(128);
        if (byArray != null) {
            for (int i = n; i < n + n2; ++i) {
                stringBuffer.append(Hex[byArray[i] >> 4 & 0xF]);
                stringBuffer.append(Hex[byArray[i] & 0xF]);
            }
        }
        return stringBuffer.toString();
    }

    public static int byteToInt(byte[] byArray, int n) {
        int n2 = 0;
        for (int i = 0; i < 4; ++i) {
            n2 = (n2 << 8) + (byArray[n + i] & 0xFF);
        }
        return n2;
    }

    public static long byteToLong(byte[] byArray, int n) {
        long l = 0L;
        for (int i = 0; i < 8; ++i) {
            l = (l << 8) + (long)(byArray[n + i] & 0xFF);
        }
        return l;
    }

    public static short byteToShort(byte[] byArray, int n) {
        return (short)((((short)byArray[n + 0] & 0xFF) << 8) + ((short)byArray[n + 1] & 0xFF));
    }

    public static String byteToUnicode(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        char[] cArray = new char[byArray.length / 2];
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = (char)((byArray[i * 2] & 0xFF) << 8 | byArray[i * 2 + 1] & 0xFF);
        }
        return new String(cArray, 0, cArray.length);
    }

    public static byte[] intToByte(int n) {
        byte[] byArray = new byte[4];
        for (int i = 0; i < 4; ++i) {
            byArray[3 - i] = (byte)(n & 0xFF);
            n >>= 8;
        }
        return byArray;
    }

    public static byte[] longToByte(long l) {
        byte[] byArray = new byte[8];
        for (int i = 0; i < 8; ++i) {
            byArray[7 - i] = (byte)(l & 0xFFL);
            l >>= 8;
        }
        return byArray;
    }

    public static byte[] shortToByte(short s) {
        byte[] byArray = new byte[]{(byte)(s >> 8 & 0xFF), (byte)(s & 0xFF)};
        return byArray;
    }

    public static byte[] unicodeToByte(String string) {
        if (string == null) {
            return null;
        }
        char[] cArray = new char[string.length()];
        string.getChars(0, string.length(), cArray, 0);
        byte[] byArray = new byte[cArray.length * 2];
        for (int i = 0; i < cArray.length; ++i) {
            byArray[i * 2] = (byte)(cArray[i] >> 8 & 0xFF);
            byArray[i * 2 + 1] = (byte)(cArray[i] & 0xFF);
        }
        return byArray;
    }
}

