/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mqtt;

import com.ibm.mqtt.MqttException;
import com.ibm.mqtt.MqttPacket;
import com.ibm.mqtt.MqttProcessor;
import com.ibm.mqtt.MqttUtils;

public class MqttConnect
extends MqttPacket {
    public String ProtoName = "MQIsdp";
    public short ProtoVersion = (short)3;
    public boolean CleanStart;
    public boolean TopicNameCompression;
    public short KeepAlive;
    public boolean Will;
    public int WillQoS;
    public boolean WillRetain;
    public String WillTopic;
    public String WillMessage;
    protected String ClientId;

    public MqttConnect() {
        this.setMsgType((short)1);
    }

    public MqttConnect(byte[] byArray) {
        super(byArray);
        this.setMsgType((short)1);
    }

    public byte[] toBytes() {
        int n;
        int n2 = 0;
        this.message = new byte[42];
        this.message[n2++] = super.toBytes()[0];
        byte[] byArray = MqttUtils.StringToUTF(this.ProtoName);
        System.arraycopy(byArray, 0, this.message, n2, byArray.length);
        n2 += byArray.length;
        this.message[n2++] = (byte)this.ProtoVersion;
        int n3 = this.TopicNameCompression ? 1 : 0;
        int n4 = n = this.CleanStart ? 2 : 0;
        int n5 = this.Will ? (int)((this.WillRetain ? 32 : 0) | (byte)((this.WillQoS & 3) << 3) | 4) : 0;
        this.message[n2++] = (byte)(n3 | n | n5);
        this.message[n2++] = (byte)(this.KeepAlive / 256);
        this.message[n2++] = (byte)(this.KeepAlive % 256);
        byArray = MqttUtils.StringToUTF(this.ClientId);
        System.arraycopy(byArray, 0, this.message, n2, byArray.length);
        n2 += byArray.length;
        if (this.Will) {
            byte[] byArray2 = MqttUtils.StringToUTF(this.WillTopic);
            byte[] byArray3 = MqttUtils.StringToUTF(this.WillMessage);
            this.message = MqttUtils.concatArray(MqttUtils.concatArray(this.message, 0, n2, byArray2, 0, byArray2.length), byArray3);
            n2 += byArray2.length + byArray3.length;
        }
        this.message = MqttUtils.SliceByteArray(this.message, 0, n2);
        this.createMsgLength();
        return this.message;
    }

    public void process(MqttProcessor mqttProcessor) {
    }

    public String getClientId() {
        return this.ClientId;
    }

    public void setClientId(String string) throws MqttException {
        if (string.length() > 23) {
            throw new MqttException("MQIsdp ClientId > 23 bytes");
        }
        this.ClientId = string;
    }
}

