/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mqtt;

import com.ibm.mqtt.MqttProcessor;

public abstract class MqttPacket {
    protected byte[] message;
    private short msgType;
    private int msgLength;
    private int msgId = 0;
    private boolean retain;
    private boolean dup;
    private int qos;
    private byte[] payload = null;
    public static final int MAX_CLIENT_ID_LEN = 23;
    public static final int MAX_MSGID = 65535;

    public MqttPacket() {
    }

    public MqttPacket(byte[] byArray) {
        byte by = byArray[0];
        this.msgType = MqttPacket.getMsgType(by);
        this.retain = (by & 1) != 0;
        this.dup = (by >>> 3 & 1) != 0;
        this.qos = by >>> 1 & 3;
    }

    protected static short getMsgType(byte by) {
        return (short)(by >>> 4 & 0xF);
    }

    protected void createMsgLength() {
        int n = this.message.length + -1;
        if (this.payload != null) {
            n += this.payload.length;
        }
        this.msgLength = n;
        int n2 = 0;
        byte[] byArray = new byte[4];
        do {
            int n3 = n % 128;
            if ((n /= 128) > 0) {
                n3 |= 0x80;
            }
            byArray[n2++] = (byte)n3;
        } while (n > 0);
        byte[] byArray2 = new byte[this.message.length + n2];
        byArray2[0] = this.message[0];
        System.arraycopy(byArray, 0, byArray2, 1, n2);
        System.arraycopy(this.message, 1, byArray2, n2 + 1, this.message.length - 1);
        this.message = byArray2;
    }

    public abstract void process(MqttProcessor var1);

    public byte[] toBytes() {
        byte[] byArray = new byte[]{(byte)(this.msgType << 4 & 0xF0)};
        if (this.msgType == 8 | this.msgType == 9 | this.msgType == 10 | this.msgType == 11) {
            this.qos = 1;
        }
        byte by = (byte)((this.qos & 3) << 1);
        byte by2 = (byte)(this.dup ? 8 : 0);
        byte by3 = (byte)(this.retain ? 1 : 0);
        byArray[0] = (byte)(byArray[0] | by | by3 | by2);
        return byArray;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public void setPayload(byte[] byArray) {
        this.payload = byArray;
    }

    public boolean isDup() {
        return this.dup;
    }

    public void setDup(boolean bl) {
        this.dup = bl;
    }

    public byte[] getMessage() {
        return this.message;
    }

    public void setMessage(byte[] byArray) {
        this.message = byArray;
    }

    public int getMsgId() {
        return this.msgId;
    }

    public void setMsgId(int n) {
        this.msgId = n;
    }

    public int getMsgLength() {
        return this.msgLength;
    }

    public void setMsgLength(int n) {
        this.msgLength = n;
    }

    public short getMsgType() {
        return this.msgType;
    }

    public void setMsgType(short s) {
        this.msgType = s;
    }

    public int getQos() {
        return this.qos;
    }

    public void setQos(int n) {
        this.qos = n;
    }

    public boolean isRetain() {
        return this.retain;
    }

    public void setRetain(boolean bl) {
        this.retain = bl;
    }
}

