/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mqtt.trace;

import com.ibm.mqtt.MQe;
import com.ibm.mqtt.MQeTraceHandler;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public abstract class MQeTraceToBinary
implements MQeTraceHandler {
    public static short[] version = new short[]{2, 0, 0, 2};
    private static final boolean DEBUG = false;
    static final int V1_MAGIC = -17978438;
    static final short DATA_FORMAT_VERSION = 1;
    static String[] prefixes = new String[]{"com.ibm.mqe.adapters.MQe", "a:", "com.ibm.mqe.administration.MQe", "b:", "com.ibm.mqe.attributes.MQe", "c:", "com.ibm.mqe.bindings.MQe", "d:", "com.ibm.mqe.communications.MQe", "e:", "com.ibm.mqe.messagestore.MQe", "f:", "com.ibm.mqe.mqbridge.MQe", "g:", "com.ibm.mqe.registry.MQe", "h:", "com.ibm.mqe.server.MQe", "i:", "com.ibm.mqe.mqemqmessage.MQe", "j:", "com.ibm.mqe.trace.MQe", "k:", "com.ibm.mqe.validation.MQe", "l:", "com.ibm.mqe.MQe", "m:", "com.ibm.mqe.adapters.", "n:", "com.ibm.mqe.administration.", "o:", "com.ibm.mqe.attributes.", "p:", "com.ibm.mqe.bindings.", "q:", "com.ibm.mqe.communications.", "r:", "com.ibm.mqe.messagestore.", "s:", "com.ibm.mqe.mqbridge.", "t:", "com.ibm.mqe.registry.", "u:", "com.ibm.mqe.server.", "v:", "com.ibm.mqe.mqemqmessage.", "w:", "com.ibm.mqe.trace.", "x:", "com.ibm.mqe.validation.", "y:", "com.ibm.mqe.", "z:"};
    private long currentFilter = 0L;
    private boolean isOn = false;
    private int recordsOutput = 0;
    private static final int ASCII_CHARS_IN_MAX_LENGTH_STRING = 20480;
    public static final int UNICODE_CHARS_IN_MAX_LENGTH_STRING = 10240;

    private String shortenClassName(String string) {
        String string2 = string;
        if (null != string && string.startsWith("com.ibm.mqe.")) {
            boolean bl = false;
            for (int i = 0; !bl && i < prefixes.length; i += 2) {
                if (!string.startsWith(prefixes[i])) continue;
                string2 = prefixes[i + 1] + string.substring(prefixes[i].length());
                bl = true;
            }
        }
        return string2;
    }

    public void traceMessage(Object object, short s, long l) {
        this.traceFilteredMessage(object, s, l, new Object[0]);
    }

    public void traceMessage(Object object, short s, long l, Object object2) {
        this.traceFilteredMessage(object, s, l, new Object[]{object2});
    }

    public void traceMessage(Object object, short s, long l, Object object2, Object object3) {
        this.traceFilteredMessage(object, s, l, new Object[]{object2, object3});
    }

    public void traceMessage(Object object, short s, long l, Object object2, Object object3, Object object4) {
        this.traceFilteredMessage(object, s, l, new Object[]{object2, object3, object4});
    }

    public void traceMessage(Object object, short s, long l, Object object2, Object object3, Object object4, Object object5) {
        this.traceFilteredMessage(object, s, l, new Object[]{object2, object3, object4, object5});
    }

    public void setFilter(long l) {
        boolean bl;
        if (this.currentFilter == 0L) {
            if (l != 0L) {
                this.isOn = this.on();
            }
        } else if (l == 0L && (bl = this.off())) {
            this.isOn = false;
        }
        this.currentFilter = l;
    }

    private synchronized void traceFilteredMessage(Object object, short s, long l, Object[] objectArray) {
        if (this.isOn) {
            int n;
            String string;
            long l2 = System.currentTimeMillis();
            String string2 = Thread.currentThread().toString();
            int n2 = Thread.currentThread().hashCode();
            if (null == object) {
                string = "";
                n = 0;
            } else {
                string = this.shortenClassName(object.getClass().toString());
                n = object.hashCode();
            }
            String[] stringArray = this.convertInsertsToStrings(objectArray);
            byte[] byArray = this.constructRecord(l2, s, string2, n2, string, n, l, stringArray);
            this.writeRecord(byArray);
        }
    }

    byte[] constructRecord(long l, short s, String string, int n, String string2, int n2, long l2, String[] stringArray) {
        ++this.recordsOutput;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byte[] byArray = MQe.longToByte(l);
            byteArrayOutputStream.write(byArray);
            byte[] byArray2 = MQe.shortToByte(s);
            byteArrayOutputStream.write(byArray2);
            MQeTraceToBinary.encodeAsciiString(byteArrayOutputStream, string);
            byte[] byArray3 = MQe.intToByte(n);
            byteArrayOutputStream.write(byArray3);
            MQeTraceToBinary.encodeAsciiString(byteArrayOutputStream, string2);
            byte[] byArray4 = MQe.intToByte(n2);
            byteArrayOutputStream.write(byArray4);
            byte[] byArray5 = MQe.shortToByte((short)stringArray.length);
            byteArrayOutputStream.write(byArray5);
            for (int i = 0; i < stringArray.length; ++i) {
                MQeTraceToBinary.encodeUnicodeString(byteArrayOutputStream, stringArray[i]);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return byteArrayOutputStream.toByteArray();
    }

    String[] convertInsertsToStrings(Object[] objectArray) {
        Object object;
        int n = 0;
        n = objectArray == null ? 0 : objectArray.length;
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = null == objectArray[i] ? "" : objectArray[i].toString();
        }
        if (n > 0 && (object = objectArray[n - 1]) != null && object instanceof Throwable) {
            int n2 = n - 1;
            stringArray[n2] = stringArray[n2] + "\n" + this.throwableStackTrace((Throwable)object);
        }
        return stringArray;
    }

    abstract String throwableStackTrace(Throwable var1);

    MQeTraceToBinary() {
    }

    synchronized boolean on() {
        boolean bl = true;
        this.recordsOutput = 0;
        return bl;
    }

    private static void encodeAsciiString(ByteArrayOutputStream byteArrayOutputStream, String string) throws IOException {
        if (string.length() > 20480) {
            string = string.substring(0, 20479);
        }
        byte[] byArray = MQe.shortToByte((short)string.length());
        byteArrayOutputStream.write(byArray);
        byte[] byArray2 = MQe.asciiToByte(string);
        byteArrayOutputStream.write(byArray2);
    }

    private static void encodeUnicodeString(ByteArrayOutputStream byteArrayOutputStream, String string) throws IOException {
        if (string.length() > 10240) {
            string = string.substring(0, 10239);
        }
        byte[] byArray = MQe.shortToByte((short)string.length());
        byteArrayOutputStream.write(byArray);
        byte[] byArray2 = MQe.unicodeToByte(string);
        byteArrayOutputStream.write(byArray2);
    }

    byte[] getHeader() {
        byte[] byArray = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray2 = MQe.intToByte(-17978438);
            byteArrayOutputStream.write(byArray2);
            byte[] byArray3 = MQe.shortToByte((short)1);
            byteArrayOutputStream.write(byArray3);
            short[] sArray = MQe.version;
            byte[] byArray4 = MQe.shortToByte(sArray[0]);
            byteArrayOutputStream.write(byArray4);
            byte[] byArray5 = MQe.shortToByte(sArray[1]);
            byteArrayOutputStream.write(byArray5);
            byte[] byArray6 = MQe.shortToByte(sArray[2]);
            byteArrayOutputStream.write(byArray6);
            byte[] byArray7 = MQe.shortToByte((short)0);
            byteArrayOutputStream.write(byArray7);
            MQeTraceToBinary.encodeAsciiString(byteArrayOutputStream, "mqe_java/source/com/ibm/mqe/MQe.java, MQeBase, la000 1.111");
            byte[] byArray8 = MQe.longToByte(System.currentTimeMillis());
            byteArrayOutputStream.write(byArray8);
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return byArray;
    }

    synchronized boolean off() {
        boolean bl = true;
        return bl;
    }

    byte[] getFooter(short s) {
        byte[] byArray = this.constructRecord(System.currentTimeMillis(), s, Thread.currentThread().toString(), Thread.currentThread().hashCode(), this.getClass().toString(), this.hashCode(), 0L, new String[0]);
        return byArray;
    }

    abstract boolean writeRecord(byte[] var1);
}

