/*
 * Decompiled with CFR 0.152.
 */
package me.pushy.sdk.lib.paho.internal;

import android.net.TrafficStats;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import javax.net.SocketFactory;
import me.pushy.sdk.lib.paho.MqttException;
import me.pushy.sdk.lib.paho.internal.NetworkModule;
import me.pushy.sdk.lib.paho.logging.Logger;
import me.pushy.sdk.lib.paho.logging.LoggerFactory;

public class TCPNetworkModule
implements NetworkModule {
    private static final String CLASS_NAME = TCPNetworkModule.class.getName();
    private static final Logger log = LoggerFactory.getLogger("me.pushy.sdk.lib.paho.internal.nls.logcat", CLASS_NAME);
    protected Socket socket;
    private SocketFactory factory;
    private String host;
    private int port;
    private int conTimeout;

    public TCPNetworkModule(SocketFactory factory, String host, int port, String resourceContext) {
        log.setResourceName(resourceContext);
        this.factory = factory;
        this.host = host;
        this.port = port;
    }

    @Override
    public void start() throws IOException, MqttException {
        String methodName = "start";
        try {
            log.fine(CLASS_NAME, "start", "252", new Object[]{this.host, new Integer(this.port), new Long(this.conTimeout * 1000)});
            InetSocketAddress sockaddr = new InetSocketAddress(this.host, this.port);
            this.socket = this.factory.createSocket();
            TrafficStats.setThreadStatsTag((int)10000);
            this.socket.connect(sockaddr, this.conTimeout * 1000);
        }
        catch (ConnectException ex) {
            log.fine(CLASS_NAME, "start", "250", null, ex);
            throw new MqttException(32103, (Throwable)ex);
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.socket.getInputStream();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.socket.getOutputStream();
    }

    @Override
    public void stop() throws IOException {
        if (this.socket != null) {
            this.socket.close();
        }
    }

    public void setConnectTimeout(int timeout) {
        this.conTimeout = timeout;
    }

    @Override
    public String getServerURI() {
        return "tcp://" + this.host + ":" + this.port;
    }
}

