/*
 * Decompiled with CFR 0.152.
 */
package me.pushy.sdk.services;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.util.Log;
import com.google.firebase.messaging.FirebaseMessagingService;
import com.google.firebase.messaging.RemoteMessage;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import me.pushy.sdk.Pushy;
import me.pushy.sdk.model.PushyCachedService;
import me.pushy.sdk.util.PushyAPI;
import me.pushy.sdk.util.PushyBroadcastManager;
import me.pushy.sdk.util.PushyLogger;
import me.pushy.sdk.util.PushyPreferences;

public class PushyFirebaseService
extends FirebaseMessagingService {
    static List<PushyCachedService> mThirdPartyFCMServices;

    public void onMessageReceived(RemoteMessage remoteMessage) {
        this.onMessageReceivedExternal(remoteMessage);
        Map payload = remoteMessage.getData();
        if (payload == null || payload.size() == 0) {
            PushyLogger.e("Received empty push from FCM");
            return;
        }
        if (!Pushy.isRegistered((Context)this)) {
            PushyLogger.d("FCM onMessageReceived() called when device is not registered");
            return;
        }
        if (!PushyPreferences.getBoolean("pushyFCMEnabled", false, (Context)this)) {
            PushyLogger.d("FCM onMessageReceived() called when FCM fallback is not enabled, dropping notification");
            return;
        }
        if (!PushyPreferences.getBoolean("pushyNotificationsEnabled", true, (Context)this)) {
            PushyLogger.d("FCM onMessageReceived() called when notifications have been toggled off, dropping notification");
            return;
        }
        PushyLogger.d("Received push via FCM for package " + this.getPackageName() + "\n" + payload);
        try {
            PushyBroadcastManager.publishNotification((Context)this, Collections.unmodifiableMap(payload), null);
            PushyAPI.setPushDelivered(payload, (Context)this);
        }
        catch (Exception exc) {
            PushyLogger.e("Publishing notification failed: " + exc.getMessage(), exc);
        }
    }

    public void onNewToken(String token) {
        this.onNewTokenExternal(token);
        if (!Pushy.isRegistered((Context)this)) {
            PushyLogger.d("FCM onNewToken() called when device not yet registered");
            return;
        }
        if (!PushyPreferences.getBoolean("pushyFCMEnabled", false, (Context)this)) {
            PushyLogger.d("FCM onNewToken() called when FCM fallback is not enabled");
            return;
        }
        if (token.equals(PushyPreferences.getString("pushyFCMToken", "", (Context)this))) {
            PushyLogger.d("FCM onNewToken() called with old token");
            return;
        }
        PushyLogger.d("FCM device token refreshed: " + token);
        try {
            PushyAPI.setFCMToken(token, (Context)this);
        }
        catch (Exception e) {
            PushyLogger.e(e.getMessage(), e);
        }
    }

    private void onMessageReceivedExternal(RemoteMessage message) {
        if (mThirdPartyFCMServices == null) {
            this.cacheThirdPartyFCMServices();
        }
        for (PushyCachedService service : mThirdPartyFCMServices) {
            service.onMessageReceived(message);
        }
    }

    private void onNewTokenExternal(String token) {
        if (mThirdPartyFCMServices == null) {
            this.cacheThirdPartyFCMServices();
        }
        for (PushyCachedService service : mThirdPartyFCMServices) {
            service.onNewToken(token);
        }
    }

    private void cacheThirdPartyFCMServices() {
        mThirdPartyFCMServices = new ArrayList<PushyCachedService>();
        PackageManager pm = this.getPackageManager();
        Intent intent = new Intent("com.google.firebase.MESSAGING_EVENT");
        intent.setPackage(this.getPackageName());
        List matches = pm.queryIntentServices(intent, 0);
        if (matches.size() == 0) {
            return;
        }
        for (ResolveInfo resolveInfo : matches) {
            try {
                if (resolveInfo.serviceInfo.name.equals(((Object)((Object)this)).getClass().getCanonicalName()) || resolveInfo.serviceInfo.name.equals("com.google.firebase.messaging.FirebaseMessagingService")) continue;
                Class<?> serviceClass = Class.forName(resolveInfo.serviceInfo.name);
                FirebaseMessagingService service = (FirebaseMessagingService)serviceClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                Method attachMethod = Class.forName("android.content.ContextWrapper").getDeclaredMethod("attachBaseContext", Context.class);
                attachMethod.setAccessible(true);
                attachMethod.invoke((Object)service, this.getBaseContext());
                Method onNewTokenMethod = null;
                Method onMessageReceivedMethod = null;
                try {
                    onNewTokenMethod = service.getClass().getDeclaredMethod("onNewToken", String.class);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    onMessageReceivedMethod = service.getClass().getDeclaredMethod("onMessageReceived", RemoteMessage.class);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (onNewTokenMethod == null && onMessageReceivedMethod == null) continue;
                PushyCachedService cachedService = new PushyCachedService(service, onNewTokenMethod, onMessageReceivedMethod);
                mThirdPartyFCMServices.add(cachedService);
                Log.d((String)"Pushy", (String)("Cached third-party FCM service: " + resolveInfo.serviceInfo.name));
            }
            catch (Exception exc) {
                Log.e((String)"Pushy", (String)("Caching third-party FCM service " + resolveInfo.serviceInfo.name + " via reflection failed"), (Throwable)exc);
            }
        }
    }
}

