/*
 * Decompiled with CFR 0.152.
 */
package me.pushy.sdk.util;

import android.content.ContentResolver;
import android.content.Context;
import android.os.Build;
import android.provider.Settings;
import me.pushy.sdk.config.PushyStorage;
import me.pushy.sdk.util.PushyEnterprise;
import me.pushy.sdk.util.PushyPreferences;

public class PushyPersistence {
    public static String getAndroidId(Context context) {
        String deviceId = PushyPreferences.getString("pushyDeviceId", null, context);
        if (deviceId != null) {
            return deviceId;
        }
        if (Build.VERSION.SDK_INT < 21) {
            return null;
        }
        String androidId = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
        if (androidId == null) {
            return androidId;
        }
        androidId = androidId + "-" + Build.MANUFACTURER + "-" + Build.MODEL;
        androidId = androidId.replaceAll(" ", "-");
        return androidId;
    }

    public static String getEnvironmentPreferenceKey(String originalKey, Context context) {
        if (PushyEnterprise.isConfigured(context)) {
            return originalKey + "Enterprise";
        }
        return originalKey;
    }

    public static String getEnvironmentExternalStoragePath(String fileName, Context context) {
        if (PushyEnterprise.isConfigured(context)) {
            fileName = "enterprise." + fileName;
        }
        return PushyStorage.EXTERNAL_STORAGE_DIRECTORY + context.getPackageName() + "/" + fileName;
    }
}

