/*
 * Decompiled with CFR 0.152.
 */
package me.pushy.sdk.util;

import android.content.Context;
import java.util.Map;
import me.pushy.sdk.model.PushyDeviceCredentials;
import me.pushy.sdk.model.api.PushyPushDeliveryRequest;
import me.pushy.sdk.model.api.PushyPushDeliveryResponse;
import me.pushy.sdk.model.api.PushyUpdateTokenRequest;
import me.pushy.sdk.model.api.PushyUpdateTokenResponse;
import me.pushy.sdk.util.PushyAuthentication;
import me.pushy.sdk.util.PushyEndpoints;
import me.pushy.sdk.util.PushyHTTP;
import me.pushy.sdk.util.PushyLogger;
import me.pushy.sdk.util.PushyPreferences;
import me.pushy.sdk.util.PushySingleton;
import me.pushy.sdk.util.PushyStringUtils;
import me.pushy.sdk.util.exceptions.PushyException;

public class PushyAPI {
    public static boolean mIsUpdatingFcmToken = false;

    public static void setPushDelivered(Map<String, String> payload, Context context) throws Exception {
        PushyPushDeliveryResponse response;
        String json;
        String pushyId = payload.get("_pushyId");
        if (pushyId == null) {
            PushyLogger.e("Pushy ID missing from FCM payload");
            return;
        }
        PushyDeviceCredentials credentials = PushyAuthentication.getDeviceCredentials(context);
        if (credentials == null) {
            throw new PushyException("Updating push delivery failed: The device is not registered for push notifications.");
        }
        try {
            PushyPushDeliveryRequest update = new PushyPushDeliveryRequest(credentials);
            json = PushySingleton.getJackson().writeValueAsString(update);
        }
        catch (Exception exc) {
            throw new PushyException("Updating push delivery failed due to invalid JSON:" + exc.getMessage());
        }
        String result = PushyHTTP.post(PushyEndpoints.getAPIEndpoint(context) + "/pushes/" + pushyId + "/delivery", json, context);
        try {
            response = PushySingleton.getJackson().readValue(result, PushyPushDeliveryResponse.class);
        }
        catch (Exception exc) {
            throw new PushyException("Updating push delivery failed due to invalid response:" + exc.getMessage());
        }
        if (!PushyStringUtils.stringIsNullOrEmpty(response.error)) {
            throw new PushyException("Updating push delivery failed: " + response.error);
        }
        if (!response.success) {
            throw new PushyException("Updating push delivery failed: An unexpected response was encountered.");
        }
        PushyLogger.d("Notification marked as delivered");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setFCMToken(String token, Context context) throws Exception {
        while (mIsUpdatingFcmToken) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (token.equals(PushyPreferences.getString("pushyFCMToken", "", context))) {
            PushyLogger.d("FCM setFCMToken() called twice with same token");
            return;
        }
        mIsUpdatingFcmToken = true;
        try {
            PushyUpdateTokenResponse response;
            String json;
            PushyDeviceCredentials credentials = PushyAuthentication.getDeviceCredentials(context);
            if (credentials == null) {
                throw new PushyException("Updating FCM token failed: The device is not registered for push notifications.");
            }
            try {
                PushyUpdateTokenRequest update = new PushyUpdateTokenRequest(credentials, token);
                json = PushySingleton.getJackson().writeValueAsString(update);
            }
            catch (Exception exc) {
                throw new PushyException("Update token failed due to invalid JSON:" + exc.getMessage());
            }
            String result = PushyHTTP.post(PushyEndpoints.getAPIEndpoint(context) + "/devices/token", json, context);
            try {
                response = PushySingleton.getJackson().readValue(result, PushyUpdateTokenResponse.class);
            }
            catch (Exception exc) {
                throw new PushyException("Updating FCM token failed due to invalid response:" + exc.getMessage());
            }
            if (!PushyStringUtils.stringIsNullOrEmpty(response.error)) {
                throw new PushyException("Updating FCM token failed: " + response.error);
            }
            if (!response.success) {
                throw new PushyException("Updating FCM token failed: An unexpected response was encountered.");
            }
            PushyPreferences.saveString("pushyFCMToken", token, context);
            PushyLogger.d("FCM device token updated successfully");
        }
        finally {
            mIsUpdatingFcmToken = false;
        }
    }
}

