/*
 * Decompiled with CFR 0.152.
 */
package me.pushy.sdk.util;

import android.content.Context;
import android.content.Intent;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Handler;
import me.pushy.sdk.services.PushyJobService;
import me.pushy.sdk.services.PushySocketService;
import me.pushy.sdk.util.PushyAuthentication;
import me.pushy.sdk.util.PushyLogger;
import me.pushy.sdk.util.PushyPersistence;
import me.pushy.sdk.util.PushyPreferences;
import me.pushy.sdk.util.exceptions.PushyException;

public class PushyServiceManager {
    public static void start(final Context context) {
        if (PushyAuthentication.getDeviceCredentials(context) == null) {
            return;
        }
        if (!PushyPreferences.getBoolean("pushyNotificationsEnabled", true, context)) {
            PushyLogger.d("Notifications have been disabled by the app");
            return;
        }
        if (PushyServiceManager.usingJobService()) {
            PushyJobService.main(context);
        } else {
            PushyServiceManager.startSocketServiceWithAction(context, "Pushy.START");
        }
        if (!PushyPreferences.getBoolean("pushyAndroidIdPersisted", false, context) && PushyPersistence.getAndroidId(context) != null) {
            AsyncTask.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        if (PushyAuthentication.validateCredentials(PushyAuthentication.getDeviceCredentials(context), context)) {
                            PushyPreferences.saveBoolean("pushyAndroidIdPersisted", true, context);
                            PushyLogger.d("Android ID persisted successfully");
                        }
                    }
                    catch (PushyException e) {
                        PushyLogger.e("Failed to persist Android ID in background thread, will retry later", e);
                    }
                }
            });
        }
    }

    public static boolean usingJobService() {
        return Build.VERSION.SDK_INT >= 24 && !PushySocketService.isForegroundServiceEnabled();
    }

    public static void stop(final Context context) {
        if (PushyServiceManager.usingJobService()) {
            PushyJobService.stop();
        } else if (PushySocketService.isForegroundServiceEnabled()) {
            new Handler().postDelayed(new Runnable(){

                @Override
                public void run() {
                    context.stopService(new Intent(context, PushySocketService.class));
                }
            }, 500L);
        } else {
            context.stopService(new Intent(context, PushySocketService.class));
        }
    }

    private static void startSocketServiceWithAction(Context context, String action) {
        Intent actionIntent = new Intent(context, PushySocketService.class);
        actionIntent.setAction(action);
        if (PushySocketService.isForegroundServiceEnabled() && Build.VERSION.SDK_INT >= 26) {
            try {
                context.startForegroundService(actionIntent);
            }
            catch (Exception err) {
                if (err.getClass().getName().contains("ForegroundServiceStartNotAllowedException")) {
                    PushyLogger.d("ForegroundServiceStartNotAllowedException thrown, will try again on next Pushy.listen() invocation");
                }
                throw err;
            }
        } else {
            context.startService(actionIntent);
        }
    }
}

