/*
 * Decompiled with CFR 0.152.
 */
package me.pushy.sdk.services;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiManager;
import android.os.AsyncTask;
import android.os.IBinder;
import android.os.SystemClock;
import android.util.Log;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import me.pushy.sdk.util.PushyHTTP;
import me.pushy.sdk.util.PushyPersistence;
import me.pushy.sdk.util.PushySingleton;
import me.pushy.sdk.util.PushyStringUtils;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;

public class PushySocketService
extends Service {
    private WifiManager mWifiManager;
    private AlarmManager mAlarmManager;
    private ConnectivityManager mConnectivityManager;
    private WifiManager.WifiLock mWifiWakeLock;
    private MqttConnection mSocket;
    private long mRetryInterval = 500L;
    public static final String ACTION_START = "Pushy.START";
    public static final String ACTION_RECONNECT = "Pushy.RECONNECT";
    public static final String ACTION_KEEP_ALIVE = "Pushy.KEEP_ALIVE";
    private static final long INITIAL_RETRY_INTERVAL = 500L;
    private static final long MAXIMUM_RETRY_INTERVAL = 60000L;
    private static short MQTT_CONNECT_TIMEOUT = (short)15;
    private static boolean MQTT_RETAINED_PUBLISH = false;
    private static short MQTT_KEEP_ALIVE = (short)301;
    private static int MQTT_QUALITY_OF_SERVICE = 1;
    private BroadcastReceiver mConnectivityListener = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            boolean isNetworkAvailable = PushySocketService.this.isNetworkAvailable();
            if (isNetworkAvailable) {
                Log.d((String)"Pushy", (String)"Internet connected");
                if (!PushySocketService.this.mSocket.isConnected()) {
                    PushySocketService.this.reconnectAsync();
                } else if (PushySocketService.this.getConnectedNetwork() == 1 && PushySocketService.this.mSocket.getNetwork() == 0) {
                    PushySocketService.this.reconnectAsync();
                }
            } else {
                Log.d((String)"Pushy", (String)"Internet disconnected");
                PushySocketService.this.cancelReconnect();
            }
        }
    };

    public void onCreate() {
        super.onCreate();
        Log.d((String)"Pushy", (String)"Creating service");
        this.mWifiManager = (WifiManager)this.getSystemService("wifi");
        this.mAlarmManager = (AlarmManager)this.getSystemService("alarm");
        this.mConnectivityManager = (ConnectivityManager)this.getSystemService("connectivity");
        this.mSocket = new MqttConnection();
        this.handleCrashedService();
        this.start();
        this.registerReceiver(this.mConnectivityListener, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
    }

    public void onTaskRemoved(Intent rootIntent) {
        Log.d((String)"Pushy", (String)"Task removed, attempting restart in 3 seconds");
        Intent restartService = new Intent(this.getApplicationContext(), ((Object)((Object)this)).getClass());
        restartService.setPackage(this.getPackageName());
        PendingIntent restartServiceIntent = PendingIntent.getService((Context)this.getApplicationContext(), (int)1, (Intent)restartService, (int)0x40000000);
        this.mAlarmManager.set(3, SystemClock.elapsedRealtime() + 3000L, restartServiceIntent);
    }

    private void handleCrashedService() {
        this.stopKeepAliveTimerAndWifiLock();
        this.cancelReconnect();
    }

    public void onDestroy() {
        Log.d((String)"Pushy", (String)"Service destroyed");
        this.stop();
        super.onDestroy();
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        if (intent == null || intent.getAction() == null) {
            this.start();
        } else if (intent.getAction().equals(ACTION_START)) {
            this.start();
        } else if (intent.getAction().equals(ACTION_KEEP_ALIVE)) {
            this.sendKeepAlive();
        } else if (intent.getAction().equals(ACTION_RECONNECT)) {
            this.reconnectAsync();
        }
        return 1;
    }

    private void start() {
        if (!this.isNetworkAvailable()) {
            return;
        }
        if (this.mSocket.isConnecting() || this.mSocket.isConnected()) {
            return;
        }
        new ConnectAsync().execute(new Integer[0]);
    }

    private void stop() {
        this.cancelReconnect();
        this.stopKeepAliveTimerAndWifiLock();
        this.unregisterReceiver(this.mConnectivityListener);
        this.mSocket.disconnectExistingClient();
    }

    private String getClientID() {
        return PushyPersistence.getToken((Context)this);
    }

    private void sendKeepAlive() {
        if (this.mSocket.isConnected()) {
            new SendKeepAliveAsync().execute(new Integer[0]);
        }
    }

    private void startKeepAliveTimerAndWifiLock() {
        long interval = MQTT_KEEP_ALIVE * 1000;
        PendingIntent pendingIntent = this.getAlarmPendingIntent(ACTION_KEEP_ALIVE);
        this.mAlarmManager.setRepeating(0, System.currentTimeMillis() + interval, interval, pendingIntent);
        this.acquireWifiLock();
    }

    PendingIntent getAlarmPendingIntent(String action) {
        Intent keepAliveIntent = new Intent();
        keepAliveIntent.setClass((Context)this, PushySocketService.class);
        keepAliveIntent.setAction(action);
        return PendingIntent.getService((Context)this, (int)0, (Intent)keepAliveIntent, (int)0);
    }

    private void stopKeepAliveTimerAndWifiLock() {
        PendingIntent keepAliveIntent = this.getAlarmPendingIntent(ACTION_KEEP_ALIVE);
        this.mAlarmManager.cancel(keepAliveIntent);
        this.releaseWifiLock();
    }

    public void scheduleReconnect() {
        long now = System.currentTimeMillis();
        if (this.mRetryInterval >= 60000L) {
            this.mRetryInterval = 500L;
        }
        this.mRetryInterval = Math.min(this.mRetryInterval * 2L, 60000L);
        Log.d((String)"Pushy", (String)("Reconnecting in " + this.mRetryInterval + "ms."));
        PendingIntent keepAliveIntent = this.getAlarmPendingIntent(ACTION_RECONNECT);
        this.mAlarmManager.set(0, now + this.mRetryInterval, keepAliveIntent);
    }

    public void cancelReconnect() {
        PendingIntent reconnectIntent = this.getAlarmPendingIntent(ACTION_RECONNECT);
        this.mAlarmManager.cancel(reconnectIntent);
    }

    private void reconnectAsync() {
        this.stopKeepAliveTimerAndWifiLock();
        if (!this.isNetworkAvailable()) {
            return;
        }
        if (this.mSocket.isConnecting()) {
            return;
        }
        Log.d((String)"Pushy", (String)"Reconnecting...");
        new ConnectAsync().execute(new Integer[0]);
    }

    private void releaseWifiLock() {
        if (this.mWifiWakeLock == null) {
            return;
        }
        try {
            this.mWifiWakeLock.release();
        }
        catch (Exception exc) {
            Log.d((String)"Pushy", (String)"Wi-Fi lock release failed");
        }
        this.mWifiWakeLock = null;
        Log.d((String)"Pushy", (String)"Wi-Fi lock released");
    }

    private void acquireWifiLock() {
        if (this.mWifiWakeLock != null) {
            return;
        }
        this.mWifiWakeLock = this.mWifiManager.createWifiLock(1, "Pushy");
        this.mWifiWakeLock.acquire();
        Log.d((String)"Pushy", (String)"Wi-Fi lock acquired");
    }

    private boolean isNetworkAvailable() {
        NetworkInfo activeNetworkInfo = this.mConnectivityManager.getActiveNetworkInfo();
        return activeNetworkInfo != null && activeNetworkInfo.isAvailable() && activeNetworkInfo.isConnected();
    }

    private int getConnectedNetwork() {
        NetworkInfo wifi = this.mConnectivityManager.getNetworkInfo(1);
        NetworkInfo mobile = this.mConnectivityManager.getNetworkInfo(0);
        if (wifi != null && wifi.isConnected()) {
            return 1;
        }
        if (mobile != null && mobile.isConnected()) {
            return 0;
        }
        return -1;
    }

    public IBinder onBind(Intent intent) {
        return null;
    }

    private class MqttConnection
    implements MqttCallback {
        int mNetwork;
        boolean mIsConnecting;
        MqttClient mClient;

        private MqttConnection() {
        }

        public void connect() throws Exception {
            this.disconnectExistingClient();
            String brokerIP = "https://mqtt.pushy.me";
            if (brokerIP.startsWith("http")) {
                brokerIP = PushyHTTP.get(brokerIP + "/ip");
            }
            if (PushyStringUtils.stringIsNullOrEmpty(brokerIP)) {
                throw new Exception("Failed to retrieve MQTT broker IP.");
            }
            String clientID = PushySocketService.this.getClientID();
            Log.d((String)"Pushy", (String)("Broker IP: " + brokerIP));
            Log.d((String)"Pushy", (String)("Client ID: " + clientID));
            this.mClient = new MqttClient("tcp://" + brokerIP + ":" + 1883, clientID, new MemoryPersistence());
            this.mClient.setCallback(this);
            this.mNetwork = PushySocketService.this.getConnectedNetwork();
            MqttConnectOptions connectOptions = new MqttConnectOptions();
            connectOptions.setAutomaticReconnect(false);
            connectOptions.setCleanSession(false);
            connectOptions.setConnectionTimeout(MQTT_CONNECT_TIMEOUT);
            connectOptions.setKeepAliveInterval(MQTT_KEEP_ALIVE);
            this.mClient.connect(connectOptions);
            this.subscribeToTopic();
            PushySocketService.this.startKeepAliveTimerAndWifiLock();
            PushySocketService.this.mRetryInterval = 500L;
            Log.d((String)"Pushy", (String)"Connected successfully");
        }

        private void subscribeToTopic() throws Exception {
            this.mClient.subscribe(PushySocketService.this.getClientID(), MQTT_QUALITY_OF_SERVICE);
        }

        private void publish(String topic, String payload) throws Exception {
            if (this.mClient == null || !this.mClient.isConnected()) {
                throw new Exception("Publish failed: not connected");
            }
            this.mClient.publish(topic, payload.getBytes(), MQTT_QUALITY_OF_SERVICE, MQTT_RETAINED_PUBLISH);
        }

        public void sendKeepAlive() throws Exception {
            this.publish("keepalive", "");
        }

        public void disconnectExistingClient() {
            if (this.mClient == null || !this.mClient.isConnected()) {
                return;
            }
            try {
                this.mClient.disconnectForcibly(2000L, 2000L);
                this.mClient.close();
            }
            catch (MqttException mqttException) {
                // empty catch block
            }
        }

        public boolean isConnected() {
            return this.mClient != null && this.mClient.isConnected();
        }

        void parsePayload(byte[] payload, Intent intent) {
            try {
                String data = new String(payload);
                Map map = (Map)PushySingleton.getJackson().readValue(data, Map.class);
                for (Map.Entry entry : map.entrySet()) {
                    if (entry.getValue() == null) continue;
                    if (entry.getValue().getClass() == String.class) {
                        intent.putExtra((String)entry.getKey(), (String)entry.getValue());
                    }
                    if (entry.getValue().getClass() == Boolean.class) {
                        intent.putExtra((String)entry.getKey(), (Serializable)((Boolean)entry.getValue()));
                    }
                    if (entry.getValue().getClass() == Integer.class) {
                        intent.putExtra((String)entry.getKey(), (Serializable)((Integer)entry.getValue()));
                    }
                    if (entry.getValue().getClass() == Long.class) {
                        intent.putExtra((String)entry.getKey(), (Serializable)((Long)entry.getValue()));
                    }
                    if (entry.getValue().getClass() == Double.class || entry.getValue().getClass() == Float.class) {
                        intent.putExtra((String)entry.getKey(), (Serializable)((Double)entry.getValue()));
                    }
                    if (entry.getValue().getClass() != ArrayList.class) continue;
                    intent.putExtra((String)entry.getKey(), (Serializable)((ArrayList)entry.getValue()).toArray());
                }
            }
            catch (Exception exc) {
                Log.e((String)"Pushy", (String)exc.getMessage(), (Throwable)exc);
            }
        }

        @Override
        public void connectionLost(Throwable cause) {
            Log.d((String)"Pushy", (String)"Connection lost");
            PushySocketService.this.reconnectAsync();
        }

        @Override
        public void messageArrived(String topic, MqttMessage message) throws Exception {
            Log.d((String)"Pushy", (String)("Received push for package " + topic));
            Intent pushBroadcast = new Intent();
            this.parsePayload(message.getPayload(), pushBroadcast);
            pushBroadcast.setPackage(topic);
            pushBroadcast.setAction("pushy.me");
            PushySocketService.this.sendBroadcast(pushBroadcast);
        }

        @Override
        public void deliveryComplete(IMqttDeliveryToken token) {
        }

        public int getNetwork() {
            return this.mNetwork;
        }

        public boolean isConnecting() {
            return this.mIsConnecting;
        }

        public void setConnecting(boolean value) {
            this.mIsConnecting = value;
        }
    }

    public class SendKeepAliveAsync
    extends AsyncTask<Integer, String, Integer> {
        protected Integer doInBackground(Integer ... parameter) {
            if (!PushySocketService.this.mSocket.isConnected()) {
                return 0;
            }
            Log.d((String)"Pushy", (String)"Sending keep alive");
            try {
                PushySocketService.this.mSocket.sendKeepAlive();
            }
            catch (Exception e) {
                Log.d((String)"Pushy", (String)("Keep alive error: " + e.toString()), (Throwable)e);
            }
            return 0;
        }
    }

    public class ConnectAsync
    extends AsyncTask<Integer, String, Integer> {
        public ConnectAsync() {
            PushySocketService.this.mSocket.setConnecting(true);
        }

        protected Integer doInBackground(Integer ... parameter) {
            block2: {
                Log.d((String)"Pushy", (String)"Connecting...");
                try {
                    PushySocketService.this.mSocket.connect();
                }
                catch (Exception e) {
                    Log.d((String)"Pushy", (String)("Connect exception: " + e.toString()));
                    if (!PushySocketService.this.isNetworkAvailable()) break block2;
                    PushySocketService.this.scheduleReconnect();
                }
            }
            PushySocketService.this.mSocket.setConnecting(false);
            return 0;
        }
    }
}

