/*
 * Decompiled with CFR 0.152.
 */
package me.pushy.sdk;

import android.content.Context;
import me.pushy.sdk.model.PushyRegistrationRequest;
import me.pushy.sdk.model.PushyRegistrationResponse;
import me.pushy.sdk.util.PushyHTTP;
import me.pushy.sdk.util.PushyPermissionVerification;
import me.pushy.sdk.util.PushyPersistence;
import me.pushy.sdk.util.PushyPreferences;
import me.pushy.sdk.util.PushyServiceManager;
import me.pushy.sdk.util.PushySingleton;
import me.pushy.sdk.util.PushyStringUtils;
import me.pushy.sdk.util.exceptions.PushyException;
import me.pushy.sdk.util.exceptions.PushyJsonParseException;
import me.pushy.sdk.util.exceptions.PushyRegistrationException;

public class Pushy {
    public static void listen(Context context) {
        PushyServiceManager.startSocketService(context);
    }

    public static void togglePermissionVerification(boolean value, Context context) {
        PushyPreferences.saveBoolean("pushyPermissionVerification", value, context);
    }

    public static void toggleDirectConnectivity(boolean value, Context context) {
        PushyPreferences.saveBoolean("pushyDirectConnectivity", value, context);
    }

    public static void toggleNotifications(boolean value, Context context) {
        PushyPreferences.saveBoolean("pushyNotificationsEnabled", value, context);
        if (value) {
            PushyServiceManager.startSocketService(context);
        } else {
            PushyServiceManager.stopSocketService(context);
        }
    }

    public static void setHeartbeatInterval(int seconds, Context context) {
        if (seconds < 60) {
            seconds = 60;
        }
        PushyPreferences.saveInt("pushyKeepAliveInterval", seconds, context);
    }

    public static boolean isRegistered(Context context) {
        return PushyPersistence.getToken(context) != null;
    }

    public static String register(Context context) throws PushyException {
        PushyRegistrationResponse response;
        String json;
        Object register;
        PushyPermissionVerification.verifyManifestPermissions(context);
        String previousToken = PushyPersistence.getToken(context);
        if (previousToken != null) {
            Pushy.listen(context);
            PushyPersistence.saveToken(previousToken, context);
            return previousToken;
        }
        try {
            register = new PushyRegistrationRequest();
            ((PushyRegistrationRequest)register).app = context.getPackageName();
            json = PushySingleton.getJackson().writeValueAsString(register);
        }
        catch (Exception exc) {
            throw new PushyJsonParseException(exc.getMessage());
        }
        register = PushyHTTP.post("https://api.pushy.me/register", json);
        try {
            response = (PushyRegistrationResponse)PushySingleton.getJackson().readValue((String)register, PushyRegistrationResponse.class);
        }
        catch (Exception exc) {
            throw new PushyJsonParseException(exc.getMessage());
        }
        if (!PushyStringUtils.stringIsNullOrEmpty(response.error)) {
            throw new PushyRegistrationException("Registration failed: " + response.error);
        }
        if (response.token == null) {
            throw new PushyRegistrationException("Registration failed, please try again later.");
        }
        PushyPersistence.saveToken(response.token, context);
        Pushy.listen(context);
        return response.token;
    }
}

