/*
 * Decompiled with CFR 0.152.
 */
package me.pushy.sdk.util;

import android.content.Context;
import android.util.Log;
import me.pushy.sdk.config.PushyStorage;
import me.pushy.sdk.util.PushyEnterprise;
import me.pushy.sdk.util.PushyIO;
import me.pushy.sdk.util.PushyPreferences;

public class PushyPersistence {
    public static String getTokenPreferenceKey(Context context) {
        if (PushyEnterprise.isConfigured(context)) {
            return "pushyTokenEnterprise";
        }
        return "pushyToken";
    }

    public static String getToken(Context context) {
        String token = PushyPreferences.getString(PushyPersistence.getTokenPreferenceKey(context), null, context);
        if (token == null) {
            try {
                if (PushyPersistence.isTokenPersistedInExternalStorage(context) && (token = PushyPersistence.getTokenFromExternalStorage(context)) != null) {
                    PushyPreferences.saveString(PushyPersistence.getTokenPreferenceKey(context), token, context);
                }
            }
            catch (Exception exc) {
                Log.d((String)"Pushy", (String)("Get token from external storage failed: " + exc.getMessage()), (Throwable)exc);
            }
        } else if (!PushyPersistence.isTokenPersistedInExternalStorage(context)) {
            try {
                PushyPersistence.saveTokenInExternalStorage(token, context);
            }
            catch (Exception exc) {
                Log.d((String)"Pushy", (String)("Persisting the token to external storage failed: " + exc.getMessage()), (Throwable)exc);
            }
        }
        return token;
    }

    public static void saveToken(String token, Context context) {
        PushyPreferences.saveString(PushyPersistence.getTokenPreferenceKey(context), token, context);
        try {
            PushyPersistence.saveTokenInExternalStorage(token, context);
        }
        catch (Exception exc) {
            Log.d((String)"Pushy", (String)("Saving token to external storage failed: " + exc.getMessage()), (Throwable)exc);
        }
    }

    private static String getTokenFromExternalStorage(Context context) throws Exception {
        String path = PushyPersistence.getTokenExternalStoragePath(context);
        return PushyIO.readFromFile(path);
    }

    public static boolean isTokenPersistedInExternalStorage(Context context) {
        String path = PushyPersistence.getTokenExternalStoragePath(context);
        return PushyIO.fileExists(path);
    }

    public static String getTokenExternalStoragePath(Context context) {
        String fileName = "registration.id";
        if (PushyEnterprise.isConfigured(context)) {
            fileName = "enterprise.id";
        }
        return PushyStorage.EXTERNAL_STORAGE_DIRECTORY + context.getPackageName() + "/" + fileName;
    }

    public static void saveTokenInExternalStorage(String token, Context context) throws Exception {
        String path = PushyPersistence.getTokenExternalStoragePath(context);
        PushyIO.writeToFile(path, token);
    }
}

