/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3;

import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.paho.client.mqttv3.MqttPingSender;
import org.eclipse.paho.client.mqttv3.internal.ClientComms;
import org.eclipse.paho.client.mqttv3.logging.Logger;
import org.eclipse.paho.client.mqttv3.logging.LoggerFactory;

public class TimerPingSender
implements MqttPingSender {
    private static final String CLASS_NAME = TimerPingSender.class.getName();
    private static final Logger log = LoggerFactory.getLogger("org.eclipse.paho.client.mqttv3.internal.nls.logcat", CLASS_NAME);
    private ClientComms comms;
    private Timer timer;

    @Override
    public void init(ClientComms comms) {
        if (comms == null) {
            throw new IllegalArgumentException("ClientComms cannot be null.");
        }
        this.comms = comms;
    }

    @Override
    public void start() {
        String methodName = "start";
        String clientid = this.comms.getClient().getClientId();
        log.fine(CLASS_NAME, "start", "659", new Object[]{clientid});
        this.timer = new Timer("MQTT Ping: " + clientid);
    }

    @Override
    public void stop() {
        String methodName = "stop";
        log.fine(CLASS_NAME, "stop", "661", null);
        if (this.timer != null) {
            // empty if block
        }
    }

    @Override
    public void schedule(long delayInMilliseconds) {
    }

    private class PingTask
    extends TimerTask {
        private static final String methodName = "PingTask.run";

        private PingTask() {
        }

        @Override
        public void run() {
            log.fine(CLASS_NAME, methodName, "660", new Object[]{new Long(System.currentTimeMillis())});
            TimerPingSender.this.comms.checkForActivity();
        }
    }
}

