/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.internal.wire;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttAck;

public class MqttConnack
extends MqttAck {
    public static final String KEY = "Con";
    private int returnCode;
    private boolean sessionPresent;

    public MqttConnack(byte info, byte[] variableHeader) throws IOException {
        super((byte)2);
        ByteArrayInputStream bais = new ByteArrayInputStream(variableHeader);
        DataInputStream dis = new DataInputStream(bais);
        this.sessionPresent = (dis.readUnsignedByte() & 1) == 1;
        this.returnCode = dis.readUnsignedByte();
        dis.close();
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    @Override
    protected byte[] getVariableHeader() throws MqttException {
        return new byte[0];
    }

    @Override
    public boolean isMessageIdRequired() {
        return false;
    }

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public String toString() {
        return super.toString() + " session present:" + this.sessionPresent + " return code: " + this.returnCode;
    }

    public boolean getSessionPresent() {
        return this.sessionPresent;
    }
}

