/*
 * Decompiled with CFR 0.152.
 */
package me.pushy.sdk.util;

import android.content.Context;
import android.util.Log;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import me.pushy.sdk.model.PushyDeviceCredentials;
import me.pushy.sdk.model.api.PushyAuthRequest;
import me.pushy.sdk.model.api.PushyAuthResponse;
import me.pushy.sdk.util.PushyEndpoints;
import me.pushy.sdk.util.PushyHTTP;
import me.pushy.sdk.util.PushyIO;
import me.pushy.sdk.util.PushyPersistence;
import me.pushy.sdk.util.PushyPreferences;
import me.pushy.sdk.util.PushySingleton;
import me.pushy.sdk.util.PushyStringUtils;
import me.pushy.sdk.util.exceptions.PushyException;
import me.pushy.sdk.util.exceptions.PushyJsonParseException;

public class PushyAuthentication {
    public static PushyDeviceCredentials getDeviceCredentials(Context context) {
        PushyDeviceCredentials credentials = new PushyDeviceCredentials();
        credentials.token = PushyPreferences.getString(PushyPersistence.getEnvironmentPreferenceKey("pushyToken", context), null, context);
        credentials.authKey = PushyPreferences.getString(PushyPersistence.getEnvironmentPreferenceKey("pushyAuthKey", context), null, context);
        String tokenPath = PushyPersistence.getEnvironmentExternalStoragePath("registration.id", context);
        String authKeyPath = PushyPersistence.getEnvironmentExternalStoragePath("registration.key", context);
        if (credentials.token == null) {
            try {
                if (PushyIO.fileExists(tokenPath)) {
                    credentials.token = PushyIO.readFromFile(tokenPath);
                }
                if (PushyIO.fileExists(authKeyPath)) {
                    credentials.authKey = PushyIO.readFromFile(authKeyPath);
                }
                if (!PushyStringUtils.stringIsNullOrEmpty(credentials.token)) {
                    PushyAuthentication.saveDeviceCredentials(credentials, context);
                }
            }
            catch (Exception exc) {
                Log.d((String)"Pushy", (String)("External storage access failed: " + exc.getMessage()), (Throwable)exc);
            }
        } else if (!PushyIO.fileExists(tokenPath) || credentials.authKey != null && !PushyIO.fileExists(authKeyPath)) {
            try {
                PushyAuthentication.saveDeviceCredentials(credentials, context);
            }
            catch (Exception exc) {
                Log.d((String)"Pushy", (String)("Persisting the credentials to external storage failed: " + exc.getMessage()), (Throwable)exc);
            }
        }
        if (credentials.token == null) {
            return null;
        }
        return credentials;
    }

    public static void saveDeviceCredentials(PushyDeviceCredentials credentials, Context context) {
        PushyPreferences.saveString(PushyPersistence.getEnvironmentPreferenceKey("pushyToken", context), credentials.token, context);
        if (credentials.authKey != null) {
            PushyPreferences.saveString(PushyPersistence.getEnvironmentPreferenceKey("pushyAuthKey", context), credentials.authKey, context);
        }
        try {
            PushyIO.writeToFile(PushyPersistence.getEnvironmentExternalStoragePath("registration.id", context), credentials.token);
            if (credentials.authKey != null) {
                PushyIO.writeToFile(PushyPersistence.getEnvironmentExternalStoragePath("registration.key", context), credentials.authKey);
            }
        }
        catch (Exception exc) {
            Log.d((String)"Pushy", (String)("Saving credentials to external storage failed: " + exc.getMessage()), (Throwable)exc);
        }
    }

    public static void validateCredentials(PushyDeviceCredentials credentials, Context context) throws PushyException {
        PushyAuthResponse response;
        String json;
        try {
            json = PushySingleton.getJackson().writeValueAsString((Object)new PushyAuthRequest(credentials));
        }
        catch (JsonProcessingException exc) {
            throw new PushyJsonParseException(exc.getMessage());
        }
        String jsonResponse = PushyHTTP.post(PushyEndpoints.getAPIEndpoint(context) + "/devices/auth", json);
        try {
            response = (PushyAuthResponse)PushySingleton.getJackson().readValue(jsonResponse, PushyAuthResponse.class);
        }
        catch (IOException exc) {
            throw new PushyJsonParseException(exc.getMessage());
        }
        if (!PushyStringUtils.stringIsNullOrEmpty(response.error)) {
            throw new PushyException("Authentication failed: " + response.error);
        }
        if (!response.success) {
            throw new PushyException("Authentication failed, please try again later.");
        }
    }
}

