/*
 * Decompiled with CFR 0.152.
 */
package me.pushy.sdk.util;

import android.content.Context;
import me.pushy.sdk.util.PushyHTTP;
import me.pushy.sdk.util.PushyPreferences;
import me.pushy.sdk.util.PushyStringUtils;

public class PushyEndpoints {
    public static String getAPIEndpoint(Context context) {
        return PushyPreferences.getString("pushyEnterpriseAPIEndpoint", "https://api.pushy.me", context);
    }

    public static String getMQTTEndpoint(Context context) throws Exception {
        String enterpriseEndpoint = PushyPreferences.getString("pushyEnterpriseMQTTEndpoint", null, context);
        if (enterpriseEndpoint != null) {
            return enterpriseEndpoint;
        }
        boolean directConnectivity = PushyPreferences.getBoolean("pushyDirectConnectivity", false, context);
        if (directConnectivity) {
            return "tcp://mqtt.pushy.me:1883";
        }
        String brokerEndpoint = "https://mqtt.pushy.me/ip";
        if (brokerEndpoint.startsWith("tcp")) {
            return brokerEndpoint;
        }
        if (PushyStringUtils.stringIsNullOrEmpty(brokerEndpoint = PushyHTTP.get(brokerEndpoint))) {
            throw new Exception("Failed to retrieve MQTT broker IP.");
        }
        return "tcp://" + brokerEndpoint + ":" + 1883;
    }
}

