/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.internal.wire;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttWireMessage;

public class MqttSubscribe
extends MqttWireMessage {
    private String[] names;
    private int[] qos;
    private int count;

    public MqttSubscribe(byte info, byte[] data) throws IOException {
        super((byte)8);
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        DataInputStream dis = new DataInputStream(bais);
        this.msgId = dis.readUnsignedShort();
        this.count = 0;
        this.names = new String[10];
        this.qos = new int[10];
        boolean end = false;
        while (!end) {
            try {
                this.names[this.count] = this.decodeUTF8(dis);
                this.qos[this.count++] = dis.readByte();
            }
            catch (Exception e) {
                end = true;
            }
        }
        dis.close();
    }

    public MqttSubscribe(String[] names, int[] qos) {
        super((byte)8);
        this.names = names;
        this.qos = qos;
        if (names.length != qos.length) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < qos.length; ++i) {
            MqttMessage.validateQos(qos[i]);
        }
    }

    @Override
    public String toString() {
        int i;
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString());
        sb.append(" names:[");
        for (i = 0; i < this.count; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append("\"").append(this.names[i]).append("\"");
        }
        sb.append("] qos:[");
        for (i = 0; i < this.count; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.qos[i]);
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    protected byte getMessageInfo() {
        return (byte)(2 | (this.duplicate ? 8 : 0));
    }

    @Override
    protected byte[] getVariableHeader() throws MqttException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            dos.writeShort(this.msgId);
            dos.flush();
            return baos.toByteArray();
        }
        catch (IOException ex) {
            throw new MqttException(ex);
        }
    }

    @Override
    public byte[] getPayload() throws MqttException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            for (int i = 0; i < this.names.length; ++i) {
                this.encodeUTF8(dos, this.names[i]);
                dos.writeByte(this.qos[i]);
            }
            dos.flush();
            return baos.toByteArray();
        }
        catch (IOException ex) {
            throw new MqttException(ex);
        }
    }

    @Override
    public boolean isRetryable() {
        return true;
    }
}

